package com.jshx.log.listener;

import java.util.Date;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.core.utils.ReflectionUtil;
import com.jshx.log.entity.DataLog;

public class JsictPostUpdateEventListener implements PostUpdateEventListener {

	private static final long serialVersionUID = 547789885321158858L;

	@Override
	public void onPostUpdate(PostUpdateEvent event) {
		if(EntitiesMonitor.checkEntity(event.getEntity().getClass().getCanonicalName())){
			Session session = event.getSession().getSessionFactory().openSession();
			
			Criteria criteria = session.createCriteria(DataLog.class);
			criteria.add(Restrictions.eq("opId", event.getEntity().toString()));
			//criteria.setMaxResults(1);
			List<DataLog> dataLogList = criteria.list();
			if(dataLogList.isEmpty()){
				return;
			}
			DataLog dataLog = dataLogList.get(0);
			Date updateTime = new Date();
			long opDuration = updateTime.getTime() - dataLog.getCreateTime().getTime();
			dataLog.setOpDuration(opDuration);
			dataLog.setUpdateTime(updateTime);
			BaseModel entity = (BaseModel)event.getEntity();
			
			Object delFlag = ReflectionUtil.getFieldValue(entity, "delFlag");
			if(delFlag!=null){
				Integer flag = (Integer)delFlag;
				if(flag==0){
					StringBuilder log = new StringBuilder("修改实体类");
					log.append(event.getEntity().getClass().getCanonicalName()).append("的实例");
					log.append(entity.getId());
					dataLog.setOpLog(log.toString());
				}else if(flag==1){
					dataLog.setOpType("006");
					StringBuilder log = new StringBuilder("逻辑删除实体类");
					log.append(event.getEntity().getClass().getCanonicalName()).append("的实例");
					log.append(entity.getId());
					dataLog.setOpLog(log.toString());
				}
			}else{
				StringBuilder log = new StringBuilder("修改实体类");
				log.append(event.getEntity().getClass().getCanonicalName()).append("的实例");
				log.append(entity.getId());
				dataLog.setOpLog(log.toString());
			}
			
			
			session.beginTransaction();
			session.update(dataLog);
			session.getTransaction().commit();
			session.flush();
			session.close();
		}
	}

}
