package com.jshx.activiti.service;

import com.jshx.core.exception.BasalException;

/**
 * 通知提醒服务
 *
 * Created by chenjian on 16/6/13.
 */
public interface NotificationService {

    String NEW_TASK_TITLE = "您有一项新的待办任务";

    String NEW_TASK_CONTENT = "{0}提交了流程{1},需要您处理事项{2}";
    
    String DELAY_TASK_TITLE = "您有一项待办任务超时";

    String DELAY_TASK_CONTENT = "{0}提交了流程{1},需要您处理事项{2}，请您及时处理";

    /**
     * 发送通知提醒
     *
     * @param processInstanceId
     * @param taskId
     * @param buzzId
     */
    void sendNotification(String processInstanceId, String taskId, String buzzId) throws BasalException;
}
