package com.jshx.activiti.freeflow.command;

import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.log4j.Logger;
import com.jshx.activiti.freeflow.FreeFlowService;

public class DeleteExecutionTaskCmd implements Command<java.lang.Void>{

	private String executionId;
	
	private TaskEntity currentTaskEntity;
	

	public DeleteExecutionTaskCmd(TaskEntity currentTaskEntity)
	{
		executionId = currentTaskEntity.getExecutionId();	
		this.currentTaskEntity = currentTaskEntity;
	}
	
	public DeleteExecutionTaskCmd(String executionId)
	{
		this.executionId = executionId;	
	}

	@Override
	public Void execute(CommandContext commandContext)
	{	
		//删除当前的任务
		//不能删除当前正在执行的任务，所以要先清除掉关联
		if (currentTaskEntity != null)
		{
			Logger.getLogger(FreeFlowService.class).debug(
				String.format("deleting task: %s [id=%s]", currentTaskEntity.getName(), currentTaskEntity.getId()));
		}

			ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(executionId);			

			execution.deleteCascade("");//括号内应该填写删除的原因
			

		return null;
	}
}
