package com.jshx.activiti.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.activiti.entity.ActivitiOperLog;
import com.jshx.activiti.dao.ActivitiOperLogDao;

@Component("activitiOperLogDao")
public class ActivitiOperLogDaoImpl extends BaseDaoImpl implements ActivitiOperLogDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findActivitiOperLogByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findActivitiOperLog(Map<String, Object> paraMap){
		return this.findListByHqlId("findActivitiOperLogByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ActivitiOperLog getById(String id)
	{
		return (ActivitiOperLog)this.getObjectById(ActivitiOperLog.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(ActivitiOperLog activitiOperLog)
	{
		activitiOperLog.setId(null);
		this.saveOrUpdateObject(activitiOperLog);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(ActivitiOperLog activitiOperLog)
	{
		this.saveOrUpdateObject(activitiOperLog);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(ActivitiOperLog.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		ActivitiOperLog activitiOperLog = (ActivitiOperLog)this.getObjectById(ActivitiOperLog.class, id);
		activitiOperLog.setDelFlag(1);
		this.saveObject(activitiOperLog);
	}
}
