$(document).ready(function() {
	$('#calendar').fullCalendar({
		contentHeight: 500,
		header: {
			 left:   'prevYear,prev,today,next,nextYear',
			 center: 'title',
			 right:  'month,agendaWeek,agendaDay'
		},
	    monthNames: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"],
        monthNamesShort: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
        dayNames: ["周日", "星期一", "周二", "周三", "周四", "周五", "周六"],
        dayNamesShort: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
        firstDay: 1,
		selectable:true,
		buttonText:{
			 today:    '今天',
			 month:    '月',
			 week:     '周',
			 day:      '日'
		},
		editable: true,//判断该日程能否拖动
		viewDisplay: function (view) {
			asyncboxPrompt();
			var a = new Date();
            $("#calendar").fullCalendar('removeEvents');
            $.getJSON('scheduleQuery.action',  function (data) {
                for(var i=0;i<data.length;i++) { 
                    var obj = new Object();
                    obj.id = data[i].id;
                    obj.title = data[i].event;
                    obj.start = data[i].startdate;
                    obj.end = data[i].enddate;
                    obj.description = data[i].remark;
                    if(data[i].allday=="true"){
                    	obj.allDay = true;
                    }else{
                    	obj.allDay = false;
                    }
                    $("#calendar").fullCalendar('renderEvent',obj,true); //把从后台取出的数据进行封装以后在页面上以fullCalendar的方式进行显示 
            	}
            });
            $.close('tishiId');
        },
	    eventMouseover:function( event, jsEvent, view ) {
			$(this).css('border-color', 'red');
		},
		eventMouseout:function( event, jsEvent, view ) {
			$(this).css('border-color', '');
		},
	    eventClick: function(event, element) {
	    	var startDate = $.fullCalendar.formatDate(event.start, "yyyy-MM-dd HH:mm:ss");//格式化起始日期
	       // var endDate = $.fullCalendar.formatDate(event.end, "yyyy-MM-dd HH:mm:ss");//格式化截止日期
	        showOptionDialog(event.title,startDate,event.description,event.allDay,'update');//显示更新数据的对话框
	        //修改被点击的事件
	        $("#optionButton").click(function(){
	        	$.ajax( {
					async : true,
					type : "post",
					contentType : "application/x-www-form-urlencoded",
					cache : true,
					url:"scheduleUpdate.action",
					data:{//设置数据源
                        eventId:event.id,
                        event:$("#eventContent").val(),
                        startdate:$("#startDate").val(),
                         enddate:$("#endDate").val(),
                         userNames:$("#userNames").val(),
                        allDay:$('.eventHandTab input[name="isAllDay"]:checked').val(),
                        remark:$("#remark").val()
                    },
					timeout : 6000,
					beforeSend : function() {
                    	//if(!checkDateTime()){  
                    	//    asyncbox.alert("结束时间必须晚于开始时间！","系统提示",function(){});
                    	//    return false;  
                    	//}
						$("#sab").html("<img src='asyncbox/skins/ZCMS/images/wait.gif' alt='数据正在处理中...'/>");
					},
					success : function(result) {
						if(result=="True"){
							event.title=$("#eventContent").val();
				            event.start=$("#startDate").val();
				           event.end=$("#endDate").val();
				            event.description=$("#remark").val();
				          //  if($('.eventHandTab input[name="isAllDay"]:checked').val()=="true"){
				        //    	event.allDay = true;
				        //    }else{
				        //    	event.allDay = false;
				         //   } 
				        	$('#calendar').fullCalendar('updateEvent', event);//修改事件
						}else{
							asyncbox.alert("事件修改失败！","系统提示",function(){});
						}
						$.close("eventCL");
					},
					error : function(XMLHttpRequest, textStatus, errorThrown) {
						alert(XMLHttpRequest.responseText);
					}
				});
	        
	        	
	        });
	        $("#deleteEvent").click(function (){
	        	asyncbox.confirm('您确定要删除该事件?','系统提示',function(action){
	     		　　if(action == 'ok'){
		     			$.ajax( {
							async : true,
							type : "post",
							contentType : "application/x-www-form-urlencoded",
							cache : true,
							url:"scheduleDel.action",
							data:{//设置数据源
		                        id:event.id
		                    },
							timeout : 6000,
							beforeSend : function() {
		            			$("#DE").html("<img src='asyncbox/skins/ZCMS/images/wait.gif' alt='数据正在处理中...'/>");
							},
							success : function(result) {
								$.close("eventCL");
								if(result=="True"){
									$('#calendar').fullCalendar('removeEvents',event.id);  //删除事件
								}else{
									asyncbox.alert("事件删除失败！","系统提示",function(){});
								}
							},
							error : function(XMLHttpRequest, textStatus, errorThrown) {
								alert(XMLHttpRequest.responseText);
							}
						});
	     		　　　}
     		　　　if(action == 'cancel'||action == 'close'){}
     		　   });
	        	
	        });
	    },
		dayClick: function(date, allDay, jsEvent, view) {
	        var startDate = $.fullCalendar.formatDate(date, "yyyy-MM-dd HH:mm:ss");
	      //  var endDate = $.fullCalendar.formatDate(date, "yyyy-MM-dd HH:mm:ss");
			showOptionDialog("会议主题",startDate,'会议地点','会议相关内容','true','add');
			$("#optionButton").click(function(){
				var isAllDay = false;
				if($('.eventHandTab input[name="isAllDay"]:checked').val()=="true"){
					isAllDay = true;
				}
		        $.ajax( {
					async : true,
					type : "post",
					contentType : "application/x-www-form-urlencoded",
					cache : true,
					url:"scheduleAdd.action",
					data:{//设置数据源
                        event:$("#eventContent").val(),
                        startdate:$("#startDate").val(),
                        enddate:$("#endDate").val(),
                        userNames:$("#userNames").val(),
                        allday:$('.eventHandTab input[name="isAllDay"]:checked ').val(),
                        remark:$("#remark").val()
                    },
					timeout : 6000,
					beforeSend : function() {
                    	//if(!checkDateTime()){  
                    	//    asyncbox.alert("结束时间必须晚于开始时间！","系统提示",function(){});
                    	//    return false;  
                    	//};
						$("#sab").html("<img src='asyncbox/skins/ZCMS/images/wait.gif' alt='数据正在处理中...'/>");
					},
					success : function(result) {
						if(result.substring(0,4)=="True"){ 
							var eventSources=
					        {
					            events: [
							        {
							        	id:result.substring(5,result.length),
							            title: $("#eventContent").val(),
							            start: $("#startDate").val(),
							            end:$("#endDate").val(),
							            description:$("#remark").val(),
							            allDay : isAllDay 
							        }
							    ],
					            color: '#3a87ad',   // an option!
					            textColor: '#FFFFFF' // an option!
					        };
							$.close("eventCL");
							$('#calendar').fullCalendar('addEventSource', eventSources);
						}else{
							$.close("eventCL");
							asyncbox.alert("事件新增失败！","系统提示",function(){});
						}
					},
					error : function(XMLHttpRequest, textStatus, errorThrown) {
						alert(XMLHttpRequest.responseText);
					}
				});
				
			});
		}
	});
})

function selectUser()
			{	
				var commonUserIds=$("#userIds").val();
				str = showModalDialog("/njzsb/selectUsers.action?commonUserIds="+commonUserIds, window, 'dialogWidth:650px;dialogHeight:500px;scroll:no;center:yes');
				if(str!=null&&str.length>0)
				{
					$("#userIds").val(str[0]);
					$("#userNames").val(str[1]);
				}
			}


//关闭弹窗
function showOptionDialog(eventContent,startDate,endDate,remark,allDay,optionType){
	var titleContent="";
	if(optionType=="add"){
		titleContent="新增事件";
	}else if(optionType=="update"){
		titleContent="更新事件";
	}
	asyncbox.open({
		id : 'eventCL',
		title : titleContent,
		html:"<div class='eventHandTab'>"+
					"<table cellpadding='0' cellspacing='0' border='0' width='600px' align='center' >"+
					"<tr>"+
					"<td width='15%' align='right'>标题：</td>"+
	    			"<td width='85%'><input type='text' class='dfinput' style='width:95%' name='eventContent' id='eventContent'/></td>"+
		    		"</tr>"+
		    		"<tr>"+
		    		"<th width=\"15%\"><font style=\"color:red\">*</font><a href=\"javascript:selectUser();\" title=\"参会人员\">参会人员<a>：</th>"+
		    		"<td width=\"85%\" style=\"text-align:left;\">"+
		    		"<input type=\"text\" name=\"userNames\" id=\"userNames\" value=\"\" class=\"form_text\" type=\"text\" datatype=\"*1-25\" errormsg='此项为必填' readonly=\"readonly\" onclick=\"javascript:selectUser();\" style=\"width: 96%;\"/>"+
		    		"<input type=\"hidden\" name=\"userIds\" id=\"userIds\" value=\"${userIds }\"/>"+
		    			//"<td width='15%' align='right'>事件内容：</td>"+
		    			//"<td width='85%'><input type='text' class='dfinput' style='width:95%' name='eventContent' id='eventContent'/></td>"+
		    		"</tr>"+
		    		"<tr>"+
		    			"<td align='right'>会议时间：</td>"+
		    			"<td align='left'><input type='text' class='dfinput' name='startDate' style='width:95%' id='startDate' value=''/></td>"+
		    		"</tr>"+
		    		"<tr>"+
		    			"<td align='right'>会议地点：</td>"+
		    			"<td align='left'><input type='text' class='dfinput' name='endDate' style='width:95%' id='endDate' value=''/></td>"+
		    		"</tr>"+
		    		"<tr>"+
		    			"<td align='right'>会议内容：</td>"+
		    			"<td align='left'><textarea style='width: 95%;height: 100px;margin:8px 0 8px 0' name='remark' id='remark'></textarea></td>"+
		    		"</tr>"+
		    		"<tr>"+
		    			"<td align='right'>是否全天：</td>"+
	    			"<td align='left'><div style='float: left;width:55%;'><input type='radio' checked='checked' name='isAllDay' value='true'/>是&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' name='isAllDay' value='false'/>否</div><div style='float:left;width: 40%;text-align: right;' id='DE'><a href='javascript:void(0)' id='deleteEvent'>删除事件</a></div></td>"+
		    		"</tr>"+
		    		"<tr class='last'>"+
		    			"<td colspan='2' height='40px' align='center'>"+
			    			"<div style='width: 50%;margin:10px 0 10px 0;float: left;' id='sab'>"+
			    				"<input type='button' value='保存' id='optionButton' />"+
			    			"</div>"+
			    			"<div style='width: 50%;margin:10px 0 10px 0;float: left' >"+
			    				"<input type='button' value='取消' onclick=\"closeAlert()\" />"+
			    			"</div>"+
		    			"</td>"+
		    		"</tr>"+
		    	"</table>"+
	    	"</div>"
	});
	$("#optionEvent").html("");
	$("#eventContent").val(eventContent);//给事件标题赋初始值值
	$("#startDate").val(startDate);//给会议日期赋初始值
	$("#endDate").val(endDate);//给会议地点赋初始值
	$("#remark").val(remark);//会议内容
	$(".eventHandTab input[name='isAllDay'][value='"+allDay+"']").attr("checked","checked");//事件的发生是否是全天
	
	$('#startDate').datetimepicker({
		language:  'zh',
		showSecond: true,
		dateFormat: "yy-mm-dd",
		timeFormat: 'HH:mm:ss',//时间的格式
		//minDate: 0,//今天之前的日期不能选择
		stepHour: 1,
		stepMinute: 1,
		stepSecond: 1
	});
	//$('#endDate').datetimepicker({
	//	language:  'zh',
	//	showSecond: true,
	//	dateFormat: "yy-mm-dd",
	//	timeFormat: 'HH:mm:ss',//时间的格式
	//	//minDate: 0,//今天之前的日期不能选择
	//	stepHour: 1,
	//	stepMinute: 1,
	//	stepSecond: 1
	//});
}



//比较起始日期和终止日期的大小
//function checkDateTime(){
//	var startTime=$("#startDate").val();
//	var start=new Date(startTime.replace("-", "/").replace("-", "/"));
////	var endTime=$("#endDate").val();
///	var end=new Date(endTime.replace("-", "/").replace("-", "/"));
//	if(end<start){
//	}
//	return true;
//}


//Asyncbox插件提示
function asyncboxPrompt() {
	asyncbox.open({
		id : 'tishiId',
		title : '数据处理中，请稍后 . . .',
		html : "<table cellpadding='0' cellspacing='0' border='0' width='260px'><tr><td height='50px' valign='middle' align='center'><img src='images/handing.gif'/></td></tr></table>"
	});
}

/**
 * @desc 关闭弹出的窗口
 */
function closeAlert(){
	$.close("eventCL");
}
		