/*
SQLyog Enterprise - MySQL GUI v7.14 
MySQL - 5.5.19 : Database - platform400
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

CREATE DATABASE /*!32312 IF NOT EXISTS*/`platform400` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `platform400`;

/*Table structure for table `attachfiles` */

DROP TABLE IF EXISTS `attachfiles`;

CREATE TABLE `attachfiles` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `AttachName` varchar(500) DEFAULT NULL,
  `AttachType` varchar(100) DEFAULT NULL,
  `Content` blob,
  `ContentType` varchar(100) DEFAULT NULL,
  `FileName` varchar(100) DEFAULT NULL,
  `FormRowGuid` varchar(255) DEFAULT NULL,
  `infoID` int(11) DEFAULT NULL,
  `MessageID` int(11) DEFAULT NULL,
  `MsgID` int(11) DEFAULT NULL,
  `OnlineMsgID` int(11) DEFAULT NULL,
  `rowguid` varchar(255) DEFAULT NULL,
  `TempID` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `attachfiles` */

/*Table structure for table `behavior_log_param` */

DROP TABLE IF EXISTS `behavior_log_param`;

CREATE TABLE `behavior_log_param` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `delFlag` int(11) DEFAULT NULL,
  `deptId` varchar(255) DEFAULT NULL,
  `PARAM_NAME` varchar(255) DEFAULT NULL,
  `PARAM_VALUE` varchar(255) DEFAULT NULL,
  `LOG_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKAE9F1DE5A4192B04` (`LOG_ID`),
  KEY `FK_hi2g4x4hlnehwnk8ctkuejgcg` (`LOG_ID`),
  CONSTRAINT `FK_hi2g4x4hlnehwnk8ctkuejgcg` FOREIGN KEY (`LOG_ID`) REFERENCES `user_behavior_log` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `behavior_log_param` */

/*Table structure for table `code` */

DROP TABLE IF EXISTS `code`;

CREATE TABLE `code` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `CODE_NAME` varchar(40) NOT NULL,
  `DEL_FLAG` decimal(10,0) NOT NULL,
  `SORT_SQ` decimal(10,0) NOT NULL,
  `COMMENTS` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `code` */

insert  into `code`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CODE_NAME`,`DEL_FLAG`,`SORT_SQ`,`COMMENTS`) values ('0464f1a63362fccd013362fe3a390004',NULL,'402880e92db726b5012db729f65f0001',NULL,'402880e92db726b5012db729f65f0001','信息类型','0','0',NULL);
insert  into `code`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CODE_NAME`,`DEL_FLAG`,`SORT_SQ`,`COMMENTS`) values ('34ed7d8e2dbac147012dbac4f9060001',NULL,NULL,'2013-11-25 15:13:03','402880e92db726b5012db729f65f0001','部门属性','0','10','');
insert  into `code`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CODE_NAME`,`DEL_FLAG`,`SORT_SQ`,`COMMENTS`) values ('402809812e7f8c28012e7fa82239000c',NULL,'402880e92ebc31be012ebc3d94960003',NULL,'402880e92ebc31be012ebc3d94960003','是或否','0','2',NULL);
insert  into `code`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CODE_NAME`,`DEL_FLAG`,`SORT_SQ`,`COMMENTS`) values ('40288b813c5cd3a6013c5cdd681f0007',NULL,NULL,'2013-11-25 15:12:49','402880e92db726b5012db729f65f0001','用户行为类别','0','9','');
insert  into `code`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CODE_NAME`,`DEL_FLAG`,`SORT_SQ`,`COMMENTS`) values ('8a8180553c478187013c479015b5000e','2013-01-17 16:11:30','402880e92db726b5012db729f65f0001','2013-01-17 16:11:30','402880e92db726b5012db729f65f0001','数据操作类型','0','2','');
insert  into `code`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CODE_NAME`,`DEL_FLAG`,`SORT_SQ`,`COMMENTS`) values ('8a8180553eac23cd013eac26770a001f','2013-05-16 15:03:22','402880e92db726b5012db729f65f0001','2013-05-16 15:03:22','402880e92db726b5012db729f65f0001','角色类型','0','1','');
insert  into `code`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CODE_NAME`,`DEL_FLAG`,`SORT_SQ`,`COMMENTS`) values ('40284281498291ed01498296c0420002', '2014-11-06 08:52:38', '402880e92db726b5012db729f65f0001', NULL, NULL, '终端类型', '0', '0', '');
INSERT INTO  `code`(ROW_ID, CREATETIME, CREATEUSERID, UPDATETIME, UPDATEUSERID, CODE_NAME, DEL_FLAG, SORT_SQ, COMMENTS) VALUES ('4028809253556f0a015355701a810004', '2016-03-08 16:55:23', '402880e92db726b5012db729f65f0001', null, null, '敏感词过滤URL', 0, 0, '');
INSERT INTO `code`(ROW_ID, CREATETIME, CREATEUSERID, UPDATETIME, UPDATEUSERID, CODE_NAME, DEL_FLAG, SORT_SQ, COMMENTS) VALUES ('402881e753551f680153553e4c280012', '2016-03-08 16:00:59', '402880e92db726b5012db729f65f0001', null, null, '敏感词', 0, 0, '');
/*Table structure for table `code_value_extend` */

DROP TABLE IF EXISTS `code_value_extend`;

CREATE TABLE `code_value_extend` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `CODE_VALUE_ID` varchar(40) DEFAULT NULL,
  `INFO` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK3A4BB6DA5C4CB2CD` (`CODE_VALUE_ID`),
  KEY `FK_4t5aphjwwdj6j933v93hnkb4p` (`CODE_VALUE_ID`),
  CONSTRAINT `FK_4t5aphjwwdj6j933v93hnkb4p` FOREIGN KEY (`CODE_VALUE_ID`) REFERENCES `codevalue` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `code_value_extend` */

/*Table structure for table `codevalue` */

DROP TABLE IF EXISTS `codevalue`;

CREATE TABLE `codevalue` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `CHILD_NUM` decimal(10,0) DEFAULT NULL,
  `CODE_ID` varchar(50) NOT NULL,
  `DEL_FLAG` decimal(10,0) NOT NULL,
  `ITEM_CODE` varchar(100) NOT NULL,
  `ITEM_TEXT` varchar(100) NOT NULL,
  `ITEM_VALUE` varchar(20) NOT NULL,
  `SORT_SQ` decimal(10,0) NOT NULL,
  `PARRENT_ITEM_ID` varchar(32) DEFAULT NULL,
  `COMMENTS` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK64269F845ED6FF4` (`PARRENT_ITEM_ID`),
  KEY `FK_7dyhc8ul4d8lsm29057bv9k68` (`PARRENT_ITEM_ID`),
  CONSTRAINT `FK_7dyhc8ul4d8lsm29057bv9k68` FOREIGN KEY (`PARRENT_ITEM_ID`) REFERENCES `codevalue` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `codevalue` */

insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('0464f1a63362fccd013362fe6fdf0005',NULL,'402880e92db726b5012db729f65f0001',NULL,'402880e92db726b5012db729f65f0001','0','0464f1a63362fccd013362fe3a390004','0','052','系统信息','0','0',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('0464f1a63362fccd013362fe8ba30006',NULL,'402880e92db726b5012db729f65f0001',NULL,'402880e92db726b5012db729f65f0001','0','0464f1a63362fccd013362fe3a390004','0','053','普通信息','1','0',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('402809812ec18be5012ec1d971cf0013',NULL,NULL,NULL,NULL,'0','402809812e7f8c28012e7fa82239000c','0','021','是','1','0',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('402809812ec18be5012ec1d986440014',NULL,NULL,NULL,NULL,'0','402809812e7f8c28012e7fa82239000c','0','022','否','0','0',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('402880e92ebc40c5012ebc5e0054002e',NULL,'402880e92db726b5012db729f65f0001',NULL,'402880e92db726b5012db729f65f0001','0','34ed7d8e2dbac147012dbac4f9060001','0','001','省级部门','01','0',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('402880e92ebc40c5012ebc5e2457002f',NULL,'402880e92db726b5012db729f65f0001',NULL,'402880e92db726b5012db729f65f0001','0','34ed7d8e2dbac147012dbac4f9060001','0','002','市级部门','02','0',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('402880e92ebc40c5012ebc5e3b0c0030',NULL,'402880e92db726b5012db729f65f0001',NULL,'402880e92db726b5012db729f65f0001','0','34ed7d8e2dbac147012dbac4f9060001','0','003','会员','03','0',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('402880e92ebc40c5012ebc5e5b550031',NULL,'402880e92db726b5012db729f65f0001',NULL,'402880e92db726b5012db729f65f0001','0','34ed7d8e2dbac147012dbac4f9060001','0','004','一般部门','04','0',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('40288b813c5ca249013c5ca98cce0009','2013-01-21 18:31:21','402880e92db726b5012db729f65f0001','2013-01-21 18:32:08','402880e92db726b5012db729f65f0001','0','8a8180553c478187013c479015b5000e','0','073','批量查询','005','5',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('40288b813c5cd3a6013c5cddcdb30008','2013-01-21 19:28:25','402880e92db726b5012db729f65f0001','2013-01-21 19:28:25','402880e92db726b5012db729f65f0001','0','40288b813c5cd3a6013c5cdd681f0007','0','074','访问记录','001','1',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('8a8180553c478187013c47905c36000f','2013-01-17 16:11:48','402880e92db726b5012db729f65f0001','2013-01-21 18:31:56','402880e92db726b5012db729f65f0001','0','8a8180553c478187013c479015b5000e','0','067','查看详情','001','1',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('8a8180553c478187013c479093630010','2013-01-17 16:12:02','402880e92db726b5012db729f65f0001','2013-01-17 16:12:02','402880e92db726b5012db729f65f0001','0','8a8180553c478187013c479015b5000e','0','068','新建','002','2',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('8a8180553c478187013c479110590011','2013-01-17 16:12:34','402880e92db726b5012db729f65f0001','2013-01-17 16:12:34','402880e92db726b5012db729f65f0001','0','8a8180553c478187013c479015b5000e','0','069','更新','003','3',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('8a8180553c478187013c47913bf10012','2013-01-17 16:12:45','402880e92db726b5012db729f65f0001','2013-01-22 09:50:25','402880e92db726b5012db729f65f0001','0','8a8180553c478187013c479015b5000e','0','070','物理删除','004','4',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('8a8180553c5fcc3d013c5ff330a7000b','2013-01-22 09:50:38','402880e92db726b5012db729f65f0001','2013-01-22 09:50:38','402880e92db726b5012db729f65f0001','0','8a8180553c478187013c479015b5000e','0','075','逻辑删除','006','6',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('8a8180553eac23cd013eac2d7f670029',NULL,NULL,NULL,NULL,'0','8a8180553eac23cd013eac26770a001f','0','076','系统角色','001','1',NULL,NULL);
insert  into `codevalue`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CHILD_NUM`,`CODE_ID`,`DEL_FLAG`,`ITEM_CODE`,`ITEM_TEXT`,`ITEM_VALUE`,`SORT_SQ`,`PARRENT_ITEM_ID`,`COMMENTS`) values ('8a8180553eac23cd013eac4c642a006d','2013-05-16 15:44:47','402880e92db726b5012db729f65f0001','2013-05-16 15:44:47','402880e92db726b5012db729f65f0001','0','8a8180553eac23cd013eac26770a001f','0','080','岗位角色','002','0',NULL,NULL);

/*Table structure for table `content_attachs` */

DROP TABLE IF EXISTS `content_attachs`;

CREATE TABLE `content_attachs` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `DEPTID` varchar(50) DEFAULT NULL,
  `DELFLAG` decimal(10,0) DEFAULT NULL,
  `INFO_ID` varchar(32) DEFAULT NULL,
  `DOC_NAME` varchar(400) DEFAULT NULL,
  `DOC_URL` varchar(1000) DEFAULT NULL,
  `DOC_TYPE` varchar(50) DEFAULT NULL,
  `ATTACH_NAME` varchar(400) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `content_attachs` */

/*Table structure for table `content_informations` */

DROP TABLE IF EXISTS `content_informations`;

CREATE TABLE `content_informations` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `INFO_TITLE` varchar(200) DEFAULT NULL,
  `INFO_CONTENT` longblob,
  `INFO_TYPE` varchar(50) DEFAULT NULL,
  `DEPT_ID` varchar(32) DEFAULT NULL,
  `TOP_FLAG` varchar(50) DEFAULT NULL,
  `EXPIRE_FLAG` varchar(50) DEFAULT NULL,
  `USER_ID` varchar(32) DEFAULT NULL,
  `PUBLIC_DATETIME` datetime DEFAULT NULL,
  `DEL_FLAG` varchar(50) DEFAULT NULL,
  `PUBLIC_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKFF46DAED95CDE28C` (`USER_ID`),
  KEY `FKFF46DAEDF2828FD9` (`DEPT_ID`),
  KEY `FK_76otgbi1koio4ep10m9jsxgvg` (`DEPT_ID`),
  KEY `FK_7pepq8e2ia6s1i63duyabsf1v` (`USER_ID`),
  CONSTRAINT `FK_76otgbi1koio4ep10m9jsxgvg` FOREIGN KEY (`DEPT_ID`) REFERENCES `department` (`ROW_ID`),
  CONSTRAINT `FK_7pepq8e2ia6s1i63duyabsf1v` FOREIGN KEY (`USER_ID`) REFERENCES `users` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `content_informations` */

/*Table structure for table `data_log` */

DROP TABLE IF EXISTS `data_log`;

CREATE TABLE `data_log` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `delFlag` int(11) DEFAULT NULL,
  `deptId` varchar(255) DEFAULT NULL,
  `ENTITY_NAME` varchar(255) DEFAULT NULL,
  `OP_DURATION` bigint(20) DEFAULT NULL,
  `OP_ID` varchar(255) DEFAULT NULL,
  `OP_LOG` varchar(255) DEFAULT NULL,
  `OP_TYPE` varchar(255) DEFAULT NULL,
  `RECORD_NUM` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK995C590F340E1A9F` (`CREATEUSERID`),
  KEY `FK_aewanlxi3jomrpvf0i0x6th3k` (`CREATEUSERID`),
  CONSTRAINT `FK_aewanlxi3jomrpvf0i0x6th3k` FOREIGN KEY (`CREATEUSERID`) REFERENCES `users` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `data_log` */

/*Table structure for table `department` */

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `AREA_CODE` varchar(50) DEFAULT NULL,
  `DEL_FLAG` decimal(10,0) NOT NULL,
  `DEPT_CODE` varchar(100) NOT NULL,
  `DEPT_NAME` varchar(100) NOT NULL,
  `DEPT_TYPE_CODE` varchar(10) DEFAULT NULL,
  `EXPIRATION_DATE` datetime DEFAULT NULL,
  `HAS_CHILD` decimal(10,0) NOT NULL,
  `IS_PUBLIC` decimal(10,0) DEFAULT NULL,
  `LINKED_DEPT_TYPE_CODE` varchar(30) DEFAULT NULL,
  `NEED_APPROVAL` decimal(10,0) DEFAULT NULL,
  `NEED_SUB_FLOW` varchar(10) DEFAULT NULL,
  `OPEN_DATE` datetime DEFAULT NULL,
  `SORT_SQ` decimal(10,0) NOT NULL,
  `USER_LIMITED_NUMBER` decimal(10,0) DEFAULT NULL,
  `PARENT_DEPT_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK4F782F521A6F544` (`PARENT_DEPT_ID`),
  KEY `FK_2j9aq6hkbq4x9q4fssmek759e` (`PARENT_DEPT_ID`),
  CONSTRAINT `FK_2j9aq6hkbq4x9q4fssmek759e` FOREIGN KEY (`PARENT_DEPT_ID`) REFERENCES `department` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `department` */

insert  into `department`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`AREA_CODE`,`DEL_FLAG`,`DEPT_CODE`,`DEPT_NAME`,`DEPT_TYPE_CODE`,`EXPIRATION_DATE`,`HAS_CHILD`,`IS_PUBLIC`,`LINKED_DEPT_TYPE_CODE`,`NEED_APPROVAL`,`NEED_SUB_FLOW`,`OPEN_DATE`,`SORT_SQ`,`USER_LIMITED_NUMBER`,`PARENT_DEPT_ID`) values ('402880e92db5d2ee012db601b2220004',NULL,NULL,'2014-01-15 08:55:34','402880e92db726b5012db729f65f0001',NULL,'0','001','系统管理','01',NULL,'10',NULL,'',NULL,'1',NULL,'2',NULL,NULL);

/*Table structure for table `dept_extend` */

DROP TABLE IF EXISTS `dept_extend`;

CREATE TABLE `dept_extend` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `DEPT_ID` varchar(40) DEFAULT NULL,
  `INFO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKEBFE1254F2828FD9` (`DEPT_ID`),
  CONSTRAINT `FKEBFE1254F2828FD9` FOREIGN KEY (`DEPT_ID`) REFERENCES `department` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `dept_extend` */

/*Table structure for table `exception_log` */

DROP TABLE IF EXISTS `exception_log`;

CREATE TABLE `exception_log` (
  `ROW_ID` varchar(40) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `DEPTID` varchar(50) DEFAULT NULL,
  `DELFLAG` int(11) DEFAULT '0',
  `CLASS_NAME` varchar(200) DEFAULT NULL,
  `MOTHOD_NAME` varchar(100) DEFAULT NULL,
  `MSG` text,
  `log_level` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKCA3A8714340E1A9F` (`CREATEUSERID`),
  KEY `FK_a0bddo4rhud47gvn421q961k0` (`CREATEUSERID`),
  CONSTRAINT `FK_a0bddo4rhud47gvn421q961k0` FOREIGN KEY (`CREATEUSERID`) REFERENCES `users` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exception_log` */

/*Table structure for table `form_category` */

DROP TABLE IF EXISTS `form_category`;

CREATE TABLE `form_category` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `CATEGORY_NAME` varchar(20) NOT NULL,
  `CATEGORY_NUM` varchar(20) NOT NULL,
  `SORT_SQ` int(11) NOT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `form_category` */

/*Table structure for table `form_incategory` */

DROP TABLE IF EXISTS `form_incategory`;

CREATE TABLE `form_incategory` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `CategoryNum` varchar(255) DEFAULT NULL,
  `TableID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `form_incategory` */

/*Table structure for table `form_tablefield` */

DROP TABLE IF EXISTS `form_tablefield`;

CREATE TABLE `form_tablefield` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `ALLOWNULL` decimal(10,0) DEFAULT NULL,
  `CONTROLWIDTH` decimal(10,0) DEFAULT NULL,
  `DATASOURCE` varchar(255) DEFAULT NULL,
  `DATASOURCETYPE` varchar(255) DEFAULT NULL,
  `DATASOURCE_CODENAME` varchar(255) DEFAULT NULL,
  `DECIMALLENGTH` decimal(10,0) DEFAULT NULL,
  `DEFAULTVALUE` varchar(255) DEFAULT NULL,
  `DISPINDETAIL` decimal(10,0) DEFAULT NULL,
  `DISPINGRID` decimal(10,0) DEFAULT NULL,
  `FIELDDEFAULTVALUE` varchar(255) DEFAULT NULL,
  `FIELDDISPLAYNAME` varchar(255) DEFAULT NULL,
  `FIELDDISPLAYTYPE` varchar(255) DEFAULT NULL,
  `FIELDINDEX` decimal(10,0) DEFAULT NULL,
  `FIELDLENGTH` decimal(10,0) DEFAULT NULL,
  `FIELDNAME` varchar(255) DEFAULT NULL,
  `FIELDTYPE` varchar(255) DEFAULT NULL,
  `GRIDMULTIROWS` decimal(10,0) DEFAULT NULL,
  `GRIDWIDTH` decimal(10,0) DEFAULT NULL,
  `ISFOREIGNKEY` decimal(10,0) DEFAULT NULL,
  `ISQUERYCONDITION` decimal(10,0) DEFAULT NULL,
  `ISSORTFIELD` decimal(10,0) DEFAULT NULL,
  `MUSTFILL` decimal(10,0) DEFAULT NULL,
  `SORTDIRECTION` varchar(255) DEFAULT NULL,
  `SORTSQ` decimal(10,0) DEFAULT NULL,
  `UNIQUEFIELD` decimal(10,0) DEFAULT NULL,
  `VALIDCHECKFORMULA` varchar(255) DEFAULT NULL,
  `VALUEURL` varchar(255) DEFAULT NULL,
  `TABLEID` varchar(32) NOT NULL,
  `COLUMN_WIDTH` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK5AC4A027DE2490D8` (`TABLEID`),
  KEY `FK_qyhsl3qibhnukv9kgiqkwn9to` (`TABLEID`),
  CONSTRAINT `FK_qyhsl3qibhnukv9kgiqkwn9to` FOREIGN KEY (`TABLEID`) REFERENCES `form_tableinfo` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `form_tablefield` */

/*Table structure for table `form_tableinfo` */

DROP TABLE IF EXISTS `form_tableinfo`;

CREATE TABLE `form_tableinfo` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `DISPLAYINMENU` decimal(10,0) DEFAULT NULL,
  `FILEPREXNAME` varchar(255) DEFAULT NULL,
  `GENERATEPATH` varchar(255) DEFAULT NULL,
  `PAGETYPE` decimal(10,0) DEFAULT NULL,
  `PHYSICALNAME` varchar(255) DEFAULT NULL,
  `PROJECTNAME` varchar(255) DEFAULT NULL,
  `SORTSQ` decimal(10,0) DEFAULT NULL,
  `SRC_PACKAGE` varchar(255) DEFAULT NULL,
  `TABLENAME` varchar(255) DEFAULT NULL,
  `LABEL_WIDTH` varchar(5) DEFAULT NULL,
  `TABLE_WIDTH` varchar(5) DEFAULT NULL,
  `TEXT_WIDTH` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `form_tableinfo` */

/*Table structure for table `function_point` */

DROP TABLE IF EXISTS `function_point`;

CREATE TABLE `function_point` (
  `ROW_ID` varchar(40) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `DEPTID` varchar(50) DEFAULT NULL,
  `DELFLAG` int(11) DEFAULT '0',
  `FUNC_NAME` varchar(30) DEFAULT NULL,
  `FUNC_PERMISSION` varchar(100) DEFAULT NULL,
  `IS_BANDING_MODULE` varchar(1) DEFAULT NULL,
  `MODULE_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK_FUNC_POINT_idx` (`MODULE_ID`),
  CONSTRAINT `FK_FUNC_POINT` FOREIGN KEY (`MODULE_ID`) REFERENCES `module` (`ROW_ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `function_point` */

/*Table structure for table `leave_info` */

DROP TABLE IF EXISTS `leave_info`;

CREATE TABLE `leave_info` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `APPLY_TIME` datetime DEFAULT NULL,
  `delFlag` int(11) DEFAULT NULL,
  `deptId` varchar(255) DEFAULT NULL,
  `ENDTIME` datetime DEFAULT NULL,
  `HR_BACK_REASON` varchar(255) DEFAULT NULL,
  `IS_DEPTLEADER_PASS` bit(1) DEFAULT NULL,
  `IS_HR_PASS` bit(1) DEFAULT NULL,
  `LEADER_BACK_REASON` varchar(255) DEFAULT NULL,
  `LEAVE_TYPE` varchar(255) DEFAULT NULL,
  `PROCESS_INSTANCE_ID` varchar(255) DEFAULT NULL,
  `RE_APPLY` bit(1) DEFAULT NULL,
  `REASON` varchar(255) DEFAULT NULL,
  `STARTTIME` datetime DEFAULT NULL,
  `USER_ID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `leave_info` */

insert  into `leave_info`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`APPLY_TIME`,`delFlag`,`deptId`,`ENDTIME`,`HR_BACK_REASON`,`IS_DEPTLEADER_PASS`,`IS_HR_PASS`,`LEADER_BACK_REASON`,`LEAVE_TYPE`,`PROCESS_INSTANCE_ID`,`RE_APPLY`,`REASON`,`STARTTIME`,`USER_ID`) values ('ff808081429d59f901429e03b1dc001f','2013-11-28 17:21:51','402880e92db726b5012db729f65f0001','2013-11-28 17:21:51','402880e92db726b5012db729f65f0001',NULL,0,'402880e92db5d2ee012db601b2220004',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'',NULL,'');

/*Table structure for table `linked_department` */

DROP TABLE IF EXISTS `linked_department`;

CREATE TABLE `linked_department` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `MAIN_DEPT_ID` varchar(32) DEFAULT NULL,
  `SUB_DEPT_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKB6B1D13817E47353` (`MAIN_DEPT_ID`),
  KEY `FKB6B1D138C991B4DA` (`SUB_DEPT_ID`),
  KEY `FK_3nrpc7hmgxn5oqn1o7gsdpp9g` (`MAIN_DEPT_ID`),
  KEY `FK_qeu3fsgo4uac6kwd52huf53fw` (`SUB_DEPT_ID`),
  CONSTRAINT `FK_3nrpc7hmgxn5oqn1o7gsdpp9g` FOREIGN KEY (`MAIN_DEPT_ID`) REFERENCES `department` (`ROW_ID`),
  CONSTRAINT `FK_qeu3fsgo4uac6kwd52huf53fw` FOREIGN KEY (`SUB_DEPT_ID`) REFERENCES `department` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `linked_department` */

/*Table structure for table `login_image` */

DROP TABLE IF EXISTS `login_image`;

CREATE TABLE `login_image` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `delFlag` int(11) DEFAULT NULL,
  `deptId` varchar(255) DEFAULT NULL,
  `IMAGE_NAME` varchar(255) DEFAULT NULL,
  `IMAGE_URL` varchar(255) DEFAULT NULL,
  `IS_USING` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `login_image` */

/*Table structure for table `logon_log` */

DROP TABLE IF EXISTS `logon_log`;

CREATE TABLE `logon_log` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `FROM_IP` varchar(30) DEFAULT NULL,
  `LOGIN_TYPE` varchar(20) DEFAULT NULL,
  `VISITED_DATE` datetime DEFAULT NULL,
  `USER_ID` varchar(32) DEFAULT NULL,
  `USERAGENT` varchar(255) DEFAULT NULL,
  `BROWSER` varchar(50) DEFAULT NULL,
  `OS` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK49EE94E895CDE28C` (`USER_ID`),
  KEY `FK_s43ld2a8vtf1lna5u5g7y9rjx` (`USER_ID`),
  CONSTRAINT `FK_s43ld2a8vtf1lna5u5g7y9rjx` FOREIGN KEY (`USER_ID`) REFERENCES `users` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `logon_log` */

insert  into `logon_log`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`FROM_IP`,`LOGIN_TYPE`,`VISITED_DATE`,`USER_ID`,`USERAGENT`,`BROWSER`,`OS`) values ('8a81805c43936226014393631eef0000','2014-01-15 08:53:03','402880e92db726b5012db729f65f0001',NULL,NULL,'127.0.0.1','电脑','2014-01-15 08:53:03','402880e92db726b5012db729f65f0001','Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.12 (KHTML, like Gecko) Maxthon/3.0 Chrome/18.0.966.0 Safari/535.12','Chrome','Windows');

/*Table structure for table `module` */

DROP TABLE IF EXISTS `module`;

CREATE TABLE `module` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `HAS_CHILD` decimal(10,0) DEFAULT NULL,
  `IS_PUBLIC` decimal(10,0) DEFAULT NULL,
  `IS_VISIBLE` decimal(10,0) NOT NULL,
  `MODULE_ADDR` varchar(500) DEFAULT NULL,
  `MODULE_CODE` varchar(100) NOT NULL,
  `MODULE_NAME` varchar(30) NOT NULL,
  `OTHER_PROPERTY` varchar(100) DEFAULT NULL,
  `SORT_SQ` decimal(10,0) DEFAULT NULL,
  `TARGET` varchar(30) DEFAULT NULL,
  `PARENT_MODULE_ID` varchar(32) DEFAULT NULL,
  `BIG_ICON_ADDR` varchar(100) DEFAULT NULL,
  `IS_AUTO_EXPAND` int(11) DEFAULT NULL,
  `MODULE_FULL_NAME` varchar(100) DEFAULT NULL,
  `SMALL_ICON_ADDR` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK87DE9A6CB2E62517` (`PARENT_MODULE_ID`),
  KEY `FK_l7mlojoubmn0g815lm6vnumsw` (`PARENT_MODULE_ID`),
  CONSTRAINT `FK_l7mlojoubmn0g815lm6vnumsw` FOREIGN KEY (`PARENT_MODULE_ID`) REFERENCES `module` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `module` */

insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('0464f18f318d3dbb01318d41ef240004',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:19:32','402880e92db726b5012db729f65f0001','0','0','1','jsp/version/versionList.action','M0109','客户端版本管理','','3','框架','402880e92ebc40c5012ebc430db50002',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402809812ec18be5012ec1a35b700002',NULL,'402880e92ebc31be012ebc3d94960003','2014-01-15 08:56:00','402880e92db726b5012db729f65f0001','5','0','1','jsp/information/contentInformationsList.action','M06','信息管理',NULL,'1','框架',NULL,NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc430db50002',NULL,'402880e92ebc31be012ebc3d94960003','2014-01-15 08:56:13','402880e92db726b5012db729f65f0001','8','0','1','','M01','系统管理',NULL,'2','框架',NULL,NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc43c0aa0004',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:19:38','402880e92db726b5012db729f65f0001','3','0','1','','M0101','系统日志','','2','框架','402880e92ebc40c5012ebc430db50002',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc445fc80005',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:17:20','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/user/list.action','M010214','用户管理','','3','框架','402880e92ebc40c5012ebc4894ee0012',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc4522da0009',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:20:47','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/dept/list.action','M010213','部门管理','','2','框架','402880e92ebc40c5012ebc4894ee0012',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc46bfe0000c',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:20:34','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/log/listOpLog.action?moduleCode=M010103','M010103','用户访问日志','','6','框架','402880e92ebc40c5012ebc43c0aa0004',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc473ee4000e',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:20:29','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/log/listLogonLog.action?module.moduleCode=M010104','M010104','用户登录日志','','5','框架','402880e92ebc40c5012ebc43c0aa0004',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc4894ee0012',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:22:38','402880e92db726b5012db729f65f0001','9','0','1','','M0102','权限管理','','1','框架','402880e92ebc40c5012ebc430db50002',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc4967de0013',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:20:55','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/code/initListCode.action','M010201','一维代码管理','','4','框架','402880e92ebc40c5012ebc4894ee0012',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc4a0c6b0015',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:22:38','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/role/list.action?userRole.roleType=ALL','M010202','角色管理','','5','框架','402880e92ebc40c5012ebc4894ee0012',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc4b29f10019',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:16:02','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/module/list.action','M010203','模块管理','','1','框架','402880e92ebc40c5012ebc4894ee0012',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc4dc201001d',NULL,'402880e92ebc31be012ebc3d94960003','2013-11-15 09:19:43','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/form/formTableInitList.action','M0108','表单管理','','4','框架','402880e92ebc40c5012ebc430db50002',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc6317eb003f',NULL,'402880e92ebc31be012ebc3d94960003','2014-01-15 08:56:18','402880e92db726b5012db729f65f0001','3','0','1','','M02','个人设置',NULL,'3','框架',NULL,NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc64aad00040',NULL,'402880e92ebc31be012ebc3d94960003','2013-06-05 16:25:41','402880e92db726b5012db729f65f0001','0','1','1','personal/modSelfInfo.jsp','M0204','修改个人信息','','1','框架','402880e92ebc40c5012ebc6317eb003f',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('402880e92ebc40c5012ebc680f570042',NULL,'402880e92ebc31be012ebc3d94960003','2013-06-05 16:25:45','402880e92db726b5012db729f65f0001','0','1','1','jsp/personal/listQuicklyStart.action','M0203','快捷菜单','','2','框架','402880e92ebc40c5012ebc6317eb003f',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('40288b813c5cd3a6013c5cd7ed810003','2013-01-21 19:22:00','402880e92db726b5012db729f65f0001','2013-11-15 09:17:34','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/behavior/userBehaviorList.action','M010108','用户行为设置','','1','框架','402880e92ebc40c5012ebc43c0aa0004',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('40288b813c5cd3a6013c5cd986060005','2013-01-21 19:23:45','402880e92db726b5012db729f65f0001','2013-11-15 09:20:07','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/behavior/userBehaviorIndex.action','M010107','用户行为日志','','2','框架','402880e92ebc40c5012ebc43c0aa0004',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('4028a38142594fb9014259597fb50002','2013-11-15 09:21:46','402880e92db726b5012db729f65f0001','2013-11-15 09:21:46','402880e92db726b5012db729f65f0001','0','1','1','personal/changePassword.jsp','M0110','修改密码','','3','框架',NULL,NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('8a8180553c47ac56013c47ade0850003','2013-01-17 16:44:03','402880e92db726b5012db729f65f0001','2013-11-15 09:20:23','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/log/exceptionLogList.action','M010105','异常日志','','4','框架','402880e92ebc40c5012ebc43c0aa0004',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('8a8180553c4c4e95013c4c4fef290083','2013-01-18 14:19:32','402880e92db726b5012db729f65f0001','2013-11-15 09:20:17','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/log/dataLogList.action','M010106','数据操作日志','','3','框架','402880e92ebc40c5012ebc43c0aa0004',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('8a8180553f1dd07d013f1dd2c2290024','2013-06-07 16:48:38','402880e92db726b5012db729f65f0001','2013-11-15 09:22:38','402880e92db726b5012db729f65f0001','0','0','1','jsp/admin/permission/functionPointList.action','M010215','功能点权限','','6','框架','402880e92ebc40c5012ebc4894ee0012',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('8a818517400f896b01400f8c04240003','2013-07-24 15:19:29','402880e92db726b5012db729f65f0001','2013-11-22 16:47:43','402880e92db726b5012db729f65f0001','2','0','0','','M05','工作流管理',NULL,'3','框架',NULL,NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427dd0c4850006','2013-11-22 11:18:23','402880e92db726b5012db729f65f0001','2013-11-22 16:45:10','402880e92db726b5012db729f65f0001','0','0','1','jsp/loginImage/loginImageList.action','M0112','登录页设置',NULL,'5','框架','402880e92ebc40c5012ebc430db50002',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427efd88b00011','2013-11-22 16:46:54','402880e92db726b5012db729f65f0001','2013-11-22 16:46:54','402880e92db726b5012db729f65f0001','0','0','0','activiti/initProcessDefList.action','M0501','流程部署',NULL,NULL,'框架','8a818517400f896b01400f8c04240003',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427efe4b5d0012','2013-11-22 16:47:43','402880e92db726b5012db729f65f0001','2013-11-22 16:47:43','402880e92db726b5012db729f65f0001','0','0','0','activiti/initModelList.action','M0502','模型管理',NULL,NULL,'框架','8a818517400f896b01400f8c04240003',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427effd50e0013','2013-11-22 16:49:24','402880e92db726b5012db729f65f0001','2013-11-22 16:55:51','402880e92db726b5012db729f65f0001','4','0','0','','M07','工作流示例',NULL,'4','框架',NULL,NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427f010a730014','2013-11-22 16:50:43','402880e92db726b5012db729f65f0001','2013-11-22 16:50:43','402880e92db726b5012db729f65f0001','0','0','0','activiti/initToClaimTaskList.action','M0701','待签收任务',NULL,'1','框架','ff808081427da10b01427effd50e0013',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427f01808a0015','2013-11-22 16:51:14','402880e92db726b5012db729f65f0001','2013-11-22 16:51:14','402880e92db726b5012db729f65f0001','0','0','0','activiti/initTodoTaskListFormKey.action','M0702','待办任务',NULL,'2','框架','ff808081427da10b01427effd50e0013',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427f01d18a0016','2013-11-22 16:51:34','402880e92db726b5012db729f65f0001','2013-11-22 16:55:41','402880e92db726b5012db729f65f0001','0','0','0','activiti/initClaimedTaskList.action','M0705','在办任务',NULL,'3','框架','ff808081427da10b01427effd50e0013',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427f022bde0017','2013-11-22 16:51:58','402880e92db726b5012db729f65f0001','2013-11-22 16:56:42','402880e92db726b5012db729f65f0001','1','0','0','','M0706','请假流程',NULL,'4','框架','ff808081427da10b01427effd50e0013',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427f06824d0019','2013-11-22 16:56:42','402880e92db726b5012db729f65f0001','2013-11-22 16:56:42','402880e92db726b5012db729f65f0001','0','0','0','jsp/leave/leaveInfoList.action','M070601','请假单列表',NULL,'1','框架','ff808081427da10b01427f022bde0017',NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427f06e7e7001a','2013-11-22 16:57:08','402880e92db726b5012db729f65f0001','2013-11-22 16:57:08','402880e92db726b5012db729f65f0001','0','0','0','jsp/leave/initApply.action','M070602','请假申请',NULL,'2','框架',NULL,NULL,NULL,NULL,NULL);
insert  into `module`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) values ('ff808081427da10b01427f07362d001b','2013-11-22 16:57:28','402880e92db726b5012db729f65f0001','2013-11-22 16:57:28','402880e92db726b5012db729f65f0001','0','0','0','jsp/leave/initTodoTaskList.action','M070603','请假待办',NULL,'3','框架',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `module` (`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`HAS_CHILD`,`IS_PUBLIC`,`IS_VISIBLE`,`MODULE_ADDR`,`MODULE_CODE`,`MODULE_NAME`,`OTHER_PROPERTY`,`SORT_SQ`,`TARGET`,`PARENT_MODULE_ID`,`BIG_ICON_ADDR`,`IS_AUTO_EXPAND`,`MODULE_FULL_NAME`,`SMALL_ICON_ADDR`) VALUES ('4028811552dd84830152dd87e2150004','2016-02-14 10:06:56','402880e92db726b5012db729f65f0001','2016-02-14 10:07:36','402880e92db726b5012db729f65f0001',0,1,1,'welcome.action','M10','首页',NULL,1,'框架',NULL,NULL,NULL,NULL,NULL);
/*Table structure for table `module_right` */

DROP TABLE IF EXISTS `module_right`;

CREATE TABLE `module_right` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `MODULE_ID` varchar(32) DEFAULT NULL,
  `ROLE_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK20E64669CD12F817` (`ROLE_ID`),
  KEY `FK20E64669DB456E6C` (`MODULE_ID`),
  KEY `FK_fs7k0ffbu9mywrnbrcg76gmxy` (`MODULE_ID`),
  KEY `FK_pduduqo2djvav7oq0qpy7653w` (`ROLE_ID`),
  CONSTRAINT `FK_fs7k0ffbu9mywrnbrcg76gmxy` FOREIGN KEY (`MODULE_ID`) REFERENCES `module` (`ROW_ID`),
  CONSTRAINT `FK_pduduqo2djvav7oq0qpy7653w` FOREIGN KEY (`ROLE_ID`) REFERENCES `userrole` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `module_right` */

/*Table structure for table `online_user` */

DROP TABLE IF EXISTS `online_user`;

CREATE TABLE `online_user` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `LOGIN_TIME` datetime DEFAULT NULL,
  `LOGIN_TYPE` varchar(40) DEFAULT NULL,
  `USER_ID` varchar(40) DEFAULT NULL,
  `SESSION_ID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK7F06063795CDE28C` (`USER_ID`),
  KEY `FK_l4ailtj62ckw1om7dcpfe2hlh` (`USER_ID`),
  CONSTRAINT `FK_l4ailtj62ckw1om7dcpfe2hlh` FOREIGN KEY (`USER_ID`) REFERENCES `users` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `online_user` */

insert  into `online_user`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`LOGIN_TIME`,`LOGIN_TYPE`,`USER_ID`,`SESSION_ID`) values ('8a81805c43936226014393631f3d0001','2014-01-15 08:53:03','402880e92db726b5012db729f65f0001',NULL,NULL,'2014-01-15 08:53:03','电脑','402880e92db726b5012db729f65f0001','B0E2FF3890142E980C55D06BAA5C9DC4');

/*Table structure for table `operation_log` */

DROP TABLE IF EXISTS `operation_log`;

CREATE TABLE `operation_log` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `FROM_IP` varchar(30) DEFAULT NULL,
  `URL` varchar(200) DEFAULT NULL,
  `VISITED_DATE` datetime DEFAULT NULL,
  `MODULE_ID` varchar(32) DEFAULT NULL,
  `USER_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKBF4D402C95CDE28C` (`USER_ID`),
  KEY `FKBF4D402CDB456E6C` (`MODULE_ID`),
  KEY `FK_qy8inkxg8wx61jjq5thni3bwy` (`MODULE_ID`),
  KEY `FK_5cgks5s0uklkk0d2pr5bqh1gk` (`USER_ID`),
  CONSTRAINT `FK_5cgks5s0uklkk0d2pr5bqh1gk` FOREIGN KEY (`USER_ID`) REFERENCES `users` (`ROW_ID`),
  CONSTRAINT `FK_qy8inkxg8wx61jjq5thni3bwy` FOREIGN KEY (`MODULE_ID`) REFERENCES `module` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `operation_log` */

/*Table structure for table `permission` */

DROP TABLE IF EXISTS `permission`;

CREATE TABLE `permission` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `PERMISSION_EXPRESSION` varchar(200) NOT NULL,
  `ROLE_ID` varchar(40) DEFAULT NULL,
  `USER_ID` varchar(40) DEFAULT NULL,
  `PERMISSION_TYPE` int(11) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKFE0FB1CFCD12F817` (`ROLE_ID`),
  KEY `FKFE0FB1CF95CDE28C` (`USER_ID`),
  KEY `FK_8jxbhn4x4psk6a4g4unuq0yky` (`ROLE_ID`),
  CONSTRAINT `FKFE0FB1CF95CDE28C` FOREIGN KEY (`USER_ID`) REFERENCES `users` (`ROW_ID`),
  CONSTRAINT `FK_8jxbhn4x4psk6a4g4unuq0yky` FOREIGN KEY (`ROLE_ID`) REFERENCES `userrole` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `permission` */

/*Table structure for table `portal` */

DROP TABLE IF EXISTS `portal`;

CREATE TABLE `portal` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `IS_PUBLIC` int(11) DEFAULT NULL,
  `TITLE` varchar(50) DEFAULT NULL,
  `URL` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `portal` */

/*Table structure for table `portal_personal` */

DROP TABLE IF EXISTS `portal_personal`;

CREATE TABLE `portal_personal` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `LEFT_PORTAL` varchar(500) DEFAULT NULL,
  `RIGHT_PORTAL` varchar(50) DEFAULT NULL,
  `USERCODE` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `portal_personal` */

/*Table structure for table `portal_right` */

DROP TABLE IF EXISTS `portal_right`;

CREATE TABLE `portal_right` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `PORTAL_ID` varchar(32) DEFAULT NULL,
  `ROLE_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKFB59A869CD12F817` (`ROLE_ID`),
  KEY `FKFB59A8697F822E6C` (`PORTAL_ID`),
  KEY `FK_3q9cm52g8f3sh38eiw4242mer` (`PORTAL_ID`),
  KEY `FK_7yyovg6tgkt7qthbkihjcvfuh` (`ROLE_ID`),
  CONSTRAINT `FK_3q9cm52g8f3sh38eiw4242mer` FOREIGN KEY (`PORTAL_ID`) REFERENCES `portal` (`ROW_ID`),
  CONSTRAINT `FK_7yyovg6tgkt7qthbkihjcvfuh` FOREIGN KEY (`ROLE_ID`) REFERENCES `userrole` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `portal_right` */

/*Table structure for table `quickly_start` */

DROP TABLE IF EXISTS `quickly_start`;

CREATE TABLE `quickly_start` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `SORT_SQ` decimal(10,0) DEFAULT NULL,
  `MODULE_ID` varchar(32) DEFAULT NULL,
  `USER_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKBBA62BDD95CDE28C` (`USER_ID`),
  KEY `FKBBA62BDDDB456E6C` (`MODULE_ID`),
  KEY `FK_n98r9jvv1vnemqe44p8xn1074` (`MODULE_ID`),
  KEY `FK_f53mos0fgms6aebiwbdvwfvxe` (`USER_ID`),
  CONSTRAINT `FK_f53mos0fgms6aebiwbdvwfvxe` FOREIGN KEY (`USER_ID`) REFERENCES `users` (`ROW_ID`),
  CONSTRAINT `FK_n98r9jvv1vnemqe44p8xn1074` FOREIGN KEY (`MODULE_ID`) REFERENCES `module` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `quickly_start` */

/*Table structure for table `report` */

DROP TABLE IF EXISTS `report`;

CREATE TABLE `report` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `DELFLAG` int(11) NOT NULL,
  `DEPLOYFILENAME` varchar(32) NOT NULL,
  `DEPLOYER` varchar(32) DEFAULT NULL,
  `deptId` varchar(255) DEFAULT NULL,
  `LATESTVERSION` int(11) DEFAULT NULL,
  `REPORTNAME` varchar(32) NOT NULL,
  `SQLSCRIPT` varchar(1024) DEFAULT NULL,
  `URL` varchar(128) NOT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `report` */

/*Table structure for table `report_attachment` */

DROP TABLE IF EXISTS `report_attachment`;

CREATE TABLE `report_attachment` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `FILENAME` varchar(32) NOT NULL,
  `REPORTID` varchar(32) NOT NULL,
  `REPORTNAME` varchar(32) NOT NULL,
  `UPLOADFILEPATH` varchar(128) NOT NULL,
  `VERSION` int(11) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `report_attachment` */

/*Table structure for table `user_behavior` */

DROP TABLE IF EXISTS `user_behavior`;

CREATE TABLE `user_behavior` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `BEHAVIOR_NAME` varchar(255) DEFAULT NULL,
  `BEHAVIOR_SERVICE` varchar(255) DEFAULT NULL,
  `BEHAVIOR_TYPE` varchar(255) DEFAULT NULL,
  `BEHAVIOR_URL` varchar(255) DEFAULT NULL,
  `DEFAULT_LOG` varchar(255) DEFAULT NULL,
  `delFlag` int(11) DEFAULT NULL,
  `deptId` varchar(255) DEFAULT NULL,
  `IS_CONTINUE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_behavior` */

/*Table structure for table `user_behavior_log` */

DROP TABLE IF EXISTS `user_behavior_log`;

CREATE TABLE `user_behavior_log` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `delFlag` int(11) DEFAULT NULL,
  `deptId` varchar(255) DEFAULT NULL,
  `LOG_CONTENT` varchar(255) DEFAULT NULL,
  `LOGGED_DATE` datetime DEFAULT NULL,
  `REMOTE_IP` varchar(50) DEFAULT NULL,
  `BEHAVIOR_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKFCC2C7AB8403B67E` (`BEHAVIOR_ID`),
  KEY `FKFCC2C7AB340E1A9F` (`CREATEUSERID`),
  KEY `FK_ikqi63pl9fm5bg2nc7r14ce24` (`BEHAVIOR_ID`),
  KEY `FK_a52wj4xrjwqaisfy9iv5jv9bv` (`CREATEUSERID`),
  CONSTRAINT `FK_a52wj4xrjwqaisfy9iv5jv9bv` FOREIGN KEY (`CREATEUSERID`) REFERENCES `users` (`ROW_ID`),
  CONSTRAINT `FK_ikqi63pl9fm5bg2nc7r14ce24` FOREIGN KEY (`BEHAVIOR_ID`) REFERENCES `user_behavior` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_behavior_log` */

/*Table structure for table `user_extend` */

DROP TABLE IF EXISTS `user_extend`;

CREATE TABLE `user_extend` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `INFO` varchar(200) DEFAULT NULL,
  `USER_ID` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKFC7F020E95CDE28C` (`USER_ID`),
  CONSTRAINT `FKFC7F020E95CDE28C` FOREIGN KEY (`USER_ID`) REFERENCES `users` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_extend` */

/*Table structure for table `user_linked_dept` */

DROP TABLE IF EXISTS `user_linked_dept`;

CREATE TABLE `user_linked_dept` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `LINKED_DEP_ID` varchar(40) NOT NULL,
  `USER_ID` varchar(40) NOT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK5D586637D6C1B6B5` (`LINKED_DEP_ID`),
  CONSTRAINT `FK5D586637D6C1B6B5` FOREIGN KEY (`LINKED_DEP_ID`) REFERENCES `department` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_linked_dept` */

/*Table structure for table `user_right` */

DROP TABLE IF EXISTS `user_right`;

CREATE TABLE `user_right` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `ROLE_ID` varchar(32) DEFAULT NULL,
  `USER_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FKC6C4CC8895CDE28C` (`USER_ID`),
  KEY `FKC6C4CC88CD12F817` (`ROLE_ID`),
  KEY `FK_mer9jawrahegi5xv6wynh74vw` (`ROLE_ID`),
  KEY `FK_64apph6qguufg95gtrv90dv7v` (`USER_ID`),
  CONSTRAINT `FK_64apph6qguufg95gtrv90dv7v` FOREIGN KEY (`USER_ID`) REFERENCES `users` (`ROW_ID`),
  CONSTRAINT `FK_mer9jawrahegi5xv6wynh74vw` FOREIGN KEY (`ROLE_ID`) REFERENCES `userrole` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_right` */

insert  into `user_right`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`ROLE_ID`,`USER_ID`) values ('8a8180553fe55a89013fe568ade10076','2013-07-16 10:56:50','402880e92db726b5012db729f65f0001','2013-07-16 10:56:50','402880e92db726b5012db729f65f0001','4ae6f5932db72e88012db72fa5060001','402880e92db726b5012db729f65f0001');

/*Table structure for table `userrole` */

DROP TABLE IF EXISTS `userrole`;

CREATE TABLE `userrole` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `ACCESSCONTROL` decimal(10,0) DEFAULT NULL,
  `CAPTION` varchar(100) DEFAULT NULL,
  `DELFLAG` decimal(10,0) DEFAULT NULL,
  `DEPT_CODE` varchar(100) DEFAULT NULL,
  `ISLOWER` decimal(10,0) DEFAULT NULL,
  `IS_PUBLIC` decimal(10,0) DEFAULT NULL,
  `ROLE_CODE` varchar(200) DEFAULT NULL,
  `ROLENAME` varchar(100) DEFAULT NULL,
  `SORTSQ` decimal(10,0) DEFAULT NULL,
  `IS_SUP_ADMIN` decimal(1,0) DEFAULT NULL,
  `IS_DEPT_ADMIN` decimal(1,0) DEFAULT NULL,
  `PARENT_ROLE_ID` varchar(40) DEFAULT NULL,
  `ROLE_TYPE` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `SYS_C0034114` (`ROLENAME`),
  KEY `FK1ED17EC1DC375D82` (`PARENT_ROLE_ID`),
  KEY `FK_rh8w4vnf1wu80gyk3nfp97dq3` (`PARENT_ROLE_ID`),
  CONSTRAINT `FK_rh8w4vnf1wu80gyk3nfp97dq3` FOREIGN KEY (`PARENT_ROLE_ID`) REFERENCES `userrole` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `userrole` */

insert  into `userrole`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`ACCESSCONTROL`,`CAPTION`,`DELFLAG`,`DEPT_CODE`,`ISLOWER`,`IS_PUBLIC`,`ROLE_CODE`,`ROLENAME`,`SORTSQ`,`IS_SUP_ADMIN`,`IS_DEPT_ADMIN`,`PARENT_ROLE_ID`,`ROLE_TYPE`) values ('4ae6f5932db72e88012db72fa5060001',NULL,NULL,'2013-06-23 22:31:28','402880e92db726b5012db729f65f0001','1',NULL,'0',NULL,'0','0','A01','系统管理员','99','1','0',NULL,'001');

/*Table structure for table `users` */

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `CSS_ID` varchar(50) DEFAULT NULL,
  `DEL_FLAG` decimal(10,0) NOT NULL,
  `DEPT_CODE` varchar(50) NOT NULL,
  `DISPLAY_NAME` varchar(100) NOT NULL,
  `DISPLAY_NUM` decimal(10,0) DEFAULT NULL,
  `DUTY` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `LOGIN_ID` varchar(20) NOT NULL,
  `MOBILE` varchar(11) DEFAULT NULL,
  `PASSWORD` varchar(50) NOT NULL,
  `SORT_SQ` decimal(10,0) DEFAULT NULL,
  `TEL` varchar(50) DEFAULT NULL,
  `DEPT_ID` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`),
  KEY `FK4D495E8F2828FD9` (`DEPT_ID`),
  KEY `FK_9ag9wrtm6f9xp9uuheq9psd8y` (`DEPT_ID`),
  CONSTRAINT `FK_9ag9wrtm6f9xp9uuheq9psd8y` FOREIGN KEY (`DEPT_ID`) REFERENCES `department` (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `users` */

insert  into `users`(`ROW_ID`,`CREATETIME`,`CREATEUSERID`,`UPDATETIME`,`UPDATEUSERID`,`CSS_ID`,`DEL_FLAG`,`DEPT_CODE`,`DISPLAY_NAME`,`DISPLAY_NUM`,`DUTY`,`EMAIL`,`LOGIN_ID`,`MOBILE`,`PASSWORD`,`SORT_SQ`,`TEL`,`DEPT_ID`) values ('402880e92db726b5012db729f65f0001',NULL,NULL,'2013-07-17 10:18:37','402880e92db726b5012db729f65f0001',NULL,'0','001','系统管理员',NULL,'系统管理','','admin','','b1f5694531e102425ae62e381f858cee','1','','402880e92db5d2ee012db601b2220004');

/*Table structure for table `version` */

DROP TABLE IF EXISTS `version`;

CREATE TABLE `version` (
  `ROW_ID` varchar(32) NOT NULL,
  `CREATETIME` datetime DEFAULT NULL,
  `CREATEUSERID` varchar(32) DEFAULT NULL,
  `UPDATETIME` datetime DEFAULT NULL,
  `UPDATEUSERID` varchar(32) DEFAULT NULL,
  `DELFLAG` decimal(10,0) DEFAULT NULL,
  `DEPTID` varchar(255) DEFAULT NULL,
  `VERSION_DOWNLOAD` varchar(255) DEFAULT NULL,
  `VERSION_NUMBER` varchar(255) DEFAULT NULL,
  `VERSION_PLATFORM` varchar(255) DEFAULT NULL,
  `CONTENT` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ROW_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `version` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
