/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.ExecutionException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Subject {
    public Object getPrincipal();

    public PrincipalCollection getPrincipals();

    public boolean isPermitted(String var1);

    public boolean isPermitted(Permission var1);

    public boolean[] isPermitted(String ... var1);

    public boolean[] isPermitted(List<Permission> var1);

    public boolean isPermittedAll(String ... var1);

    public boolean isPermittedAll(Collection<Permission> var1);

    public void checkPermission(String var1) throws AuthorizationException;

    public void checkPermission(Permission var1) throws AuthorizationException;

    public void checkPermissions(String ... var1) throws AuthorizationException;

    public void checkPermissions(Collection<Permission> var1) throws AuthorizationException;

    public boolean hasRole(String var1);

    public boolean[] hasRoles(List<String> var1);

    public boolean hasAllRoles(Collection<String> var1);

    public void checkRole(String var1) throws AuthorizationException;

    public void checkRoles(Collection<String> var1) throws AuthorizationException;

    public void checkRoles(String ... var1) throws AuthorizationException;

    public void login(AuthenticationToken var1) throws AuthenticationException;

    public boolean isAuthenticated();

    public boolean isRemembered();

    public Session getSession();

    public Session getSession(boolean var1);

    public void logout();

    public <V> V execute(Callable<V> var1) throws ExecutionException;

    public void execute(Runnable var1);

    public <V> Callable<V> associateWith(Callable<V> var1);

    public Runnable associateWith(Runnable var1);

    public void runAs(PrincipalCollection var1) throws NullPointerException, IllegalStateException;

    public boolean isRunAs();

    public PrincipalCollection getPreviousPrincipals();

    public PrincipalCollection releaseRunAs();

    public static class Builder {
        private final SubjectContext subjectContext;
        private final SecurityManager securityManager;

        public Builder() {
            this(SecurityUtils.getSecurityManager());
        }

        public Builder(SecurityManager securityManager) {
            if (securityManager == null) {
                throw new NullPointerException("SecurityManager method argument cannot be null.");
            }
            this.securityManager = securityManager;
            this.subjectContext = this.newSubjectContextInstance();
            if (this.subjectContext == null) {
                throw new IllegalStateException("Subject instance returned from 'newSubjectContextInstance' cannot be null.");
            }
            this.subjectContext.setSecurityManager(securityManager);
        }

        protected SubjectContext newSubjectContextInstance() {
            return new DefaultSubjectContext();
        }

        protected SubjectContext getSubjectContext() {
            return this.subjectContext;
        }

        public Builder sessionId(Serializable sessionId) {
            if (sessionId != null) {
                this.subjectContext.setSessionId(sessionId);
            }
            return this;
        }

        public Builder host(String host) {
            if (StringUtils.hasText(host)) {
                this.subjectContext.setHost(host);
            }
            return this;
        }

        public Builder session(Session session) {
            if (session != null) {
                this.subjectContext.setSession(session);
            }
            return this;
        }

        public Builder principals(PrincipalCollection principals) {
            if (!CollectionUtils.isEmpty(principals)) {
                this.subjectContext.setPrincipals(principals);
            }
            return this;
        }

        public Builder sessionCreationEnabled(boolean enabled) {
            this.subjectContext.setSessionCreationEnabled(enabled);
            return this;
        }

        public Builder authenticated(boolean authenticated) {
            this.subjectContext.setAuthenticated(authenticated);
            return this;
        }

        public Builder contextAttribute(String attributeKey, Object attributeValue) {
            if (attributeKey == null) {
                String msg = "Subject context map key cannot be null.";
                throw new IllegalArgumentException(msg);
            }
            if (attributeValue == null) {
                this.subjectContext.remove(attributeKey);
            } else {
                this.subjectContext.put(attributeKey, attributeValue);
            }
            return this;
        }

        public Subject buildSubject() {
            return this.securityManager.createSubject(this.subjectContext);
        }
    }
}

