/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.resources.rawcert;

import cn.com.infosec.netsign.frame.util.PBCUtil;
import cn.com.infosec.netsign.resources.ResourceException;
import cn.com.infosec.netsign.resources.ResourceList;
import cn.com.infosec.netsign.resources.ResourcePool;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResource;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.resources.rawcert.RAWCertProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PBCRAWCertProxy
extends RAWCertProxy {
    public boolean set(ResourceList rs) throws ResourceException {
        switch (this.type) {
            case 3001: {
                return this.setResourceByBankcodeAndSave(rs, null, true);
            }
            case 3002: {
                return this.setResourceByBankcodeAndSave(rs, null, false);
            }
        }
        return false;
    }

    private synchronized boolean setResourceByBankcodeAndSave(ResourceList list, ResourcePool pool, boolean save) throws ResourceException {
        PBCRAWCert cert = (PBCRAWCert)this.query.get("resource");
        if (cert == null) {
            return false;
        }
        String bankCode = cert.getBankCode();
        if (list == null) {
            if (pool == null) {
                return false;
            }
            String listName = (String)this.query.get("name");
            if (listName != null) {
                list = pool.get(listName);
            } else {
                if (cert.getPath() == null) {
                    return false;
                }
                PBCRAWCertProxy proxy = new PBCRAWCertProxy();
                proxy.addCondition("path", cert.getPath());
                proxy.setType(2002);
                list = pool.getResourceList(proxy);
            }
            if (list == null) {
                return false;
            }
        }
        PBCRAWCertProxy proxy = new PBCRAWCertProxy();
        proxy.setType(1001);
        proxy.addCondition("subjectorbankcode", cert.getBankCode());
        List ps = list.getResource(proxy);
        PBCRAWCertResourceList certList = (PBCRAWCertResourceList)list;
        boolean needSaveDetail = false;
        boolean needSaveCert = false;
        if (ps != null && ps.size() > 0) {
            PBCRAWCert certOld = (PBCRAWCert)ps.get(0);
            if (cert.getCert() != null) {
                if (!Arrays.equals(cert.getCertEncoded(), certOld.getCertEncoded())) {
                    certList.getDnCertMap().remove(certOld.getCertDN());
                    certOld.setCert(cert.getCert());
                    if (cert.getBankName() != null && !"".equals(cert.getBankName()) && !cert.getBankName().equals(certOld.getBankName())) {
                        certOld.setBankName(cert.getBankName());
                    }
                    if (cert.isInBlackList() != certOld.isInBlackList()) {
                        certOld.setBlackList(cert.isInBlackList());
                    }
                    certOld.setUpdateTimes((ArrayList)cert.getModifyTimes());
                    certList.getDnCertMap().put(certOld.getCertDN(), certOld);
                    needSaveCert = true;
                    needSaveDetail = true;
                    certList.log("Certificate [" + certOld.getCertDN() + "] of [" + certList.getName() + "] updated.");
                } else {
                    if (cert.getBankName() != null && !"".equals(cert.getBankName()) && !cert.getBankName().equals(certOld.getBankName())) {
                        certOld.setBankName(cert.getBankName());
                        needSaveDetail = true;
                    }
                    if (cert.isInBlackList() != certOld.isInBlackList()) {
                        certOld.setBlackList(cert.isInBlackList());
                        needSaveDetail = true;
                    }
                    if (cert.getModifyTimes().size() > 0) {
                        certOld.setUpdateTimes((ArrayList)cert.getModifyTimes());
                        needSaveDetail = true;
                    }
                    certList.log("Certificate [" + cert.getCertDN() + "] uploaded is a same certificate in the list [" + certList.getName() + "].");
                }
            } else {
                certList.log("Update CertInfo : No Certificate entry of bankcode:[" + cert.getBankCode() + "]");
                if (cert.getBankName() != null && !"".equals(cert.getBankName()) && !cert.getBankName().equals(certOld.getBankName())) {
                    certOld.setBankName(cert.getBankName());
                    needSaveDetail = true;
                }
                if (cert.isInBlackList() != certOld.isInBlackList()) {
                    certOld.setBlackList(cert.isInBlackList());
                    needSaveDetail = true;
                }
            }
        } else {
            certList.log("Certificate [" + cert.getCertDN() + "] bankcode[" + cert.getBankCode() + "] is a new one of [" + certList.getName() + "]");
            certList.add(cert);
            if (cert.getCert() != null) {
                needSaveCert = true;
            }
            needSaveDetail = true;
        }
        if (save) {
            if (needSaveCert) {
                if (cert.save()) {
                    certList.log("Save certificate to " + certList.getName() + " successed. DN[" + cert.getCertDN() + "] BankCode[" + cert.getBankCode() + "]");
                } else {
                    certList.log("Save certificate to " + certList.getName() + " failed. DN[" + cert.getCertDN() + "] BankCode[" + cert.getBankCode() + "]");
                    return false;
                }
            }
            if (needSaveDetail) {
                certList.saveDetail();
                certList.log("Save detail for " + certList.getName() + " successed.");
                return true;
            }
            certList.log("Nothing changed for " + certList.getName() + ".");
            return true;
        }
        return needSaveCert || needSaveDetail;
    }

    public boolean set(ResourcePool rp) throws ResourceException {
        switch (this.type) {
            case 3001: {
                return this.setResourceByBankcodeAndSave(null, rp, true);
            }
            case 3002: {
                return this.setResourceByBankcodeAndSave(null, rp, false);
            }
        }
        return false;
    }

    public List filtrateResource(ResourceList rs) {
        switch (this.type) {
            case 1001: {
                return this.findResourceByDNorBankCode(rs);
            }
            case 1003: {
                return this.findResourceByEveryThing(rs);
            }
            case 1004: {
                return this.findResourceByNotinEveryThing(rs);
            }
        }
        return null;
    }

    private List findResourceByNotinEveryThing(ResourceList rs) {
        String str = (String)this.query.get("findstr");
        if (str == null || "".equals(str)) {
            return null;
        }
        PBCRAWCertResourceList certList = (PBCRAWCertResourceList)rs;
        ArrayList<PBCRAWCertResource> list = new ArrayList<PBCRAWCertResource>();
        int i = 0;
        int size = certList.size();
        while (i < size) {
            String time;
            String datef;
            PBCRAWCertResource cert = (PBCRAWCertResource)rs.get(i);
            if (!(cert.getBankName() != null && cert.getBankName().indexOf(str) > -1 || cert.getBankCode() != null && cert.getBankCode().indexOf(str) > -1 || cert.getCertDN() != null && cert.getCertDN().indexOf(str) > -1 || cert.getNotBeforeLong() > 0L && (datef = PBCUtil.dateFormat.format(new Date(cert.getNotBeforeLong()))).indexOf(str) > -1 || cert.getNotAfterLong() > 0L && (datef = PBCUtil.dateFormat.format(new Date(cert.getNotAfterLong()))).indexOf(str) > -1 || cert.getModifyTimes() != null && cert.getModifyTimes().size() > 0 && (time = (String)cert.getModifyTimes().get(cert.getModifyTimes().size() - 1)).indexOf(str) > -1)) {
                list.add(cert);
            }
            ++i;
        }
        return list;
    }

    private List findResourceByEveryThing(ResourceList rs) {
        String str = (String)this.query.get("findstr");
        if (str == null || "".equals(str)) {
            return null;
        }
        PBCRAWCertResourceList certList = (PBCRAWCertResourceList)rs;
        ArrayList<PBCRAWCertResource> list = new ArrayList<PBCRAWCertResource>();
        int i = 0;
        int size = certList.size();
        while (i < size) {
            String time;
            String datef;
            PBCRAWCertResource cert = (PBCRAWCertResource)rs.get(i);
            if (cert.getBankName() != null && cert.getBankName().indexOf(str) > -1) {
                list.add(cert);
            } else if (cert.getBankCode() != null && cert.getBankCode().indexOf(str) > -1) {
                list.add(cert);
            } else if (cert.getCertDN() != null && cert.getCertDN().indexOf(str) > -1) {
                list.add(cert);
            } else if (cert.getNotBeforeLong() > 0L && (datef = PBCUtil.dateFormat.format(new Date(cert.getNotBeforeLong()))).indexOf(str) > -1) {
                list.add(cert);
            } else if (cert.getNotAfterLong() > 0L && (datef = PBCUtil.dateFormat.format(new Date(cert.getNotAfterLong()))).indexOf(str) > -1) {
                list.add(cert);
            } else if (cert.getModifyTimes() != null && cert.getModifyTimes().size() > 0 && (time = (String)cert.getModifyTimes().get(cert.getModifyTimes().size() - 1)).indexOf(str) > -1) {
                list.add(cert);
            }
            ++i;
        }
        return list;
    }

    private List findResourceByDNorBankCode(ResourceList rs) {
        PBCRAWCertResourceList list = (PBCRAWCertResourceList)rs;
        ArrayList<PBCRAWCertResource> result = new ArrayList<PBCRAWCertResource>();
        String bankcode = (String)this.query.get("subjectorbankcode");
        if (bankcode == null) {
            return null;
        }
        PBCRAWCertResource cert = list.get(bankcode);
        if (cert != null) {
            result.add(cert);
            return result;
        }
        return null;
    }

    public List filtrateResource(ResourcePool rp) {
        switch (this.type) {
            case 1001: {
                return this.findResourceByDNorBankCode(rp);
            }
            case 1003: {
                return this.findResourceByEveryThing(rp);
            }
            case 1004: {
                return this.findResourceByNotinEveryThing(rp);
            }
        }
        return null;
    }

    private List findResourceByNotinEveryThing(ResourcePool rp) {
        String listName = (String)this.query.get("name");
        if (listName != null) {
            ResourceList rs = rp.get(listName);
            if (rs != null) {
                return this.findResourceByNotinEveryThing(rs);
            }
            return null;
        }
        if (rp.keySet().isEmpty()) {
            return null;
        }
        ArrayList result = new ArrayList();
        Iterator iter = rp.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            List r = this.findResourceByNotinEveryThing((ResourceList)entry.getValue());
            if (r == null || r.size() <= 0) continue;
            result.addAll(r);
        }
        return result;
    }

    private List findResourceByEveryThing(ResourcePool rp) {
        String listName = (String)this.query.get("name");
        if (listName != null) {
            ResourceList rs = rp.get(listName);
            if (rs != null) {
                return this.findResourceByEveryThing(rs);
            }
            return null;
        }
        if (rp.keySet().isEmpty()) {
            return null;
        }
        ArrayList result = new ArrayList();
        Iterator iter = rp.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            List r = this.findResourceByEveryThing((ResourceList)entry.getValue());
            if (r == null || r.size() <= 0) continue;
            result.addAll(r);
        }
        return result;
    }

    private List findResourceByDNorBankCode(ResourcePool rp) {
        String listName = (String)this.query.get("name");
        if (listName != null) {
            ResourceList rs = rp.get(listName);
            if (rs != null) {
                return this.findResourceByDNorBankCode(rs);
            }
            return null;
        }
        if (rp.entrySet().isEmpty()) {
            return null;
        }
        Iterator iter = rp.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            List result = this.findResourceByDNorBankCode((ResourceList)entry.getValue());
            if (result == null || result.size() <= 0) continue;
            return result;
        }
        return null;
    }

    public boolean delete(ResourceList rs) throws ResourceException {
        switch (this.type) {
            case 4001: {
                return this.deleteResourceBySubjectOrBankcode(rs);
            }
            case 4002: {
                return this.deleteCertInfoBySubjectOrBankcode(rs);
            }
        }
        return false;
    }

    private boolean deleteResourceBySubjectOrBankcode(ResourceList rs) throws ResourceException {
        String str = (String)this.query.get("subjectorbankcode");
        if (str == null) {
            return false;
        }
        PBCRAWCertProxy rcp = new PBCRAWCertProxy();
        rcp.setType(1001);
        rcp.addCondition("subjectorbankcode", str);
        List certs = rs.getResource(rcp);
        PBCRAWCertResourceList pcrl = (PBCRAWCertResourceList)rs;
        if (certs != null && certs.size() > 0) {
            PBCRAWCert cert = (PBCRAWCert)certs.get(0);
            if (cert.getCert() == null) {
                pcrl.remove(cert);
                pcrl.getBankCodeCertMap().remove(cert.getBankCode());
                pcrl.saveDetail();
                pcrl.log("Delete certificate [" + str + "] from [" + pcrl.getName() + "] successed.");
                return true;
            }
            if (cert.deleteAndSaveAs()) {
                pcrl.remove(cert);
                pcrl.getBankCodeCertMap().remove(cert.getBankCode());
                pcrl.getDnCertMap().remove(cert.getCertDN());
                pcrl.saveDetail();
                pcrl.log("Delete certificate [" + cert.getCertDN() + "] [" + cert.getBankCode() + "] from [" + pcrl.getName() + "] successed.");
                return true;
            }
            pcrl.log("Delete certificate [" + cert.getCertDN() + "] [" + cert.getBankCode() + "] from [" + pcrl.getName() + "] failed.");
            return false;
        }
        rs.log("Delete certificate from [" + rs.getName() + "] failed resource [" + str + "] not exists.");
        return false;
    }

    private synchronized boolean deleteCertInfoBySubjectOrBankcode(ResourceList rs) throws ResourceException {
        PBCRAWCert rawcert = (PBCRAWCert)this.query.get("resource");
        String str = rawcert.getCertDN();
        if (str == null) {
            return false;
        }
        PBCRAWCertProxy rcp = new PBCRAWCertProxy();
        rcp.setType(1001);
        rcp.addCondition("subjectorbankcode", str);
        List certs = rs.getResource(rcp);
        PBCRAWCertResourceList pcrl = (PBCRAWCertResourceList)rs;
        if (certs != null && certs.size() > 0) {
            PBCRAWCert cert = (PBCRAWCert)certs.get(0);
            if (cert.getCertDN() == null) {
                pcrl.log("Delete certificate [" + str + "] from [" + pcrl.getName() + "] failed no certificate entry exists.");
                return false;
            }
            pcrl.getDnCertMap().remove(cert.getCertDN());
            cert.deleteAndSaveAs();
            cert.clearCertificateInfo();
            cert.setUpdateTimes((ArrayList)rawcert.getModifyTimes());
            pcrl.saveDetail();
            pcrl.log("Delete certificate [" + cert.getBankCode() + "] from [" + pcrl.getName() + "] successed.");
            return true;
        }
        pcrl.log("Delete certificate from [" + pcrl.getName() + "] failed resource [" + str + "] not exists.");
        return false;
    }

    public boolean delete(ResourcePool rp) throws ResourceException {
        switch (this.type) {
            case 4001: {
                return this.deleteResourceBySubjectOrBankcode(rp);
            }
            case 4002: {
                return this.deleteCertInfoBySubjectOrBankcode(rp);
            }
        }
        return false;
    }

    private boolean deleteResourceBySubjectOrBankcode(ResourcePool rp) throws ResourceException {
        String listName = (String)this.query.get("name");
        ResourceList list = null;
        if (listName != null) {
            list = rp.get(listName);
            if (list == null) {
                return false;
            }
            return this.deleteResourceBySubjectOrBankcode(list);
        }
        if (rp.entrySet().isEmpty()) {
            return false;
        }
        Iterator iter = rp.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!this.deleteResourceBySubjectOrBankcode((ResourceList)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean deleteCertInfoBySubjectOrBankcode(ResourcePool rp) throws ResourceException {
        String listName = (String)this.query.get("name");
        ResourceList list = null;
        if (listName != null) {
            list = rp.get(listName);
            if (list == null) {
                return false;
            }
            return this.deleteCertInfoBySubjectOrBankcode(list);
        }
        if (rp.entrySet().isEmpty()) {
            return false;
        }
        Iterator iter = rp.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!this.deleteCertInfoBySubjectOrBankcode((ResourceList)entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

