/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.resources;

import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.ResourceList;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.ResourcePool;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ResourceReloader
implements Runnable {
    private HashMap detaiModifies = new HashMap();

    public void run() {
        ResourcePool pool = ResourceManager.getAllResourceList();
        long sleep = ExtendedConfig.getResourceReloadInterval();
        sleep = sleep <= 30000L ? 60000L : sleep;
        while (true) {
            ConsoleLogger.logString("Resource reloader start...");
            try {
                Iterator iter = pool.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    ResourceList rl = (ResourceList)entry.getValue();
                    ConsoleLogger.logString("Resource reloader: check resource list " + rl.getName());
                    try {
                        long modifyNow = this.getModifyTime(rl);
                        Long modifyLast = (Long)this.detaiModifies.get(rl.getName());
                        if (modifyLast != null) {
                            if (modifyNow != modifyLast) {
                                ConsoleLogger.logString("Resource reloader: reload the resource list " + rl.getName());
                                rl.reload();
                                this.detaiModifies.put(rl.getName(), new Long(modifyNow));
                                continue;
                            }
                            ConsoleLogger.logString("Resource reloader: resource list " + rl.getName() + " did not changed");
                            continue;
                        }
                        ConsoleLogger.logString("Resource reloader: resource list " + rl.getName() + " is new");
                        this.detaiModifies.put(rl.getName(), new Long(modifyNow));
                    }
                    catch (Exception e) {
                        ConsoleLogger.logException(e);
                    }
                }
                try {
                    Thread.sleep(sleep);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
            }
            ConsoleLogger.logString("Resource reloader finished.");
        }
    }

    private long getModifyTime(ResourceList rl) {
        String detailFile = rl.getDetailFile();
        if (detailFile == null) {
            return 0L;
        }
        File f = new File(detailFile);
        if (!f.exists() || f.isDirectory()) {
            return 0L;
        }
        return f.lastModified();
    }
}

