/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.resources;

import cn.com.infosec.netsign.logger.ConsoleLogger;
import com.itextpdf.text.Image;
import java.io.File;
import java.util.HashMap;

public class PDFStamps {
    private static HashMap stamps = new HashMap();

    public static void load() {
        File stampsDir = new File("data/pdfstamp");
        if (stampsDir.exists()) {
            File[] fs = stampsDir.listFiles();
            int i = 0;
            int length = fs.length;
            while (i < length) {
                try {
                    Image img = Image.getInstance((String)fs[i].getAbsolutePath());
                    stamps.put(fs[i].getName(), img);
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                }
                ++i;
            }
        }
    }

    public static void delete(String stampName) {
        try {
            stamps.remove(stampName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Image load(String stampName) {
        File stamp = new File("data/pdfstamp/" + stampName);
        if (stamp.exists()) {
            try {
                Image img = Image.getInstance((String)stamp.getAbsolutePath());
                stamps.put(stampName, img);
                return img;
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
            }
        }
        return null;
    }

    public static void put(String stampName, Image img) {
        if (stampName != null && img != null) {
            stamps.put(stampName, img);
        }
    }

    public static Image get(String stampName) {
        return (Image)stamps.get(stampName);
    }
}

