/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.pbc;

import cn.com.infosec.netsign.frame.util.XMLUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.pbc.PartnerCert;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PartnerCertsFile {
    private ArrayList parttenerCerts = new ArrayList();
    private int recordCount;

    private PartnerCertsFile() {
    }

    public int size() {
        if (this.parttenerCerts == null) {
            return 0;
        }
        return this.parttenerCerts.size();
    }

    public PartnerCert get(int i) {
        return (PartnerCert)this.parttenerCerts.get(i);
    }

    public static PartnerCertsFile parse(String file, Logger logger) throws Exception {
        PartnerCertsFile pcf;
        block15: {
            logger.info((Object)"PartnerCertsFile Parse IBPSODT0601 file...");
            FileInputStream in = null;
            pcf = null;
            try {
                in = new FileInputStream(file);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(in);
                Element root = dom.getDocumentElement();
                Element element = (Element)root.getElementsByTagName("IBPS_CERT_DATA").item(0);
                NodeList nl = element.getElementsByTagName("IBPS_CERT_COUNT");
                if (nl != null && nl.getLength() >= 0) {
                    pcf = new PartnerCertsFile();
                    pcf.recordCount = XMLUtil.getIntValue((Element)nl.item(0), 0);
                    logger.info((Object)("PartnerCertsFile Parse IBPSODT0601 IBPS_CERT_COUNT: " + pcf.recordCount));
                    nl = element.getElementsByTagName("CERT");
                    if (nl != null && nl.getLength() >= 0) {
                        if (nl.getLength() != pcf.recordCount) {
                            logger.info((Object)("PartnerCertsFile Parse IBPSODT0601 Count of CERT element is " + nl.getLength() + " but IBPS_CERT_COUNT is " + pcf.recordCount));
                            logger.info((Object)"PartnerCertsFile Parse IBPSODT0601 failed");
                            pcf = null;
                            break block15;
                        }
                        int i = 0;
                        int size = nl.getLength();
                        while (i < size) {
                            Element e = (Element)nl.item(i);
                            try {
                                PartnerCert pc = PartnerCert.parse(e, logger);
                                if (pc != null) {
                                    pcf.parttenerCerts.add(pc);
                                }
                            }
                            catch (Exception ex) {
                                ConsoleLogger.logException(ex);
                            }
                            ++i;
                        }
                        break block15;
                    }
                    logger.info((Object)"PartnerCertsFile Bad format IBPSODT0601 file: No CERT element");
                    logger.info((Object)"PartnerCertsFile Parse IBPSODT0601 failed");
                    pcf = null;
                    break block15;
                }
                logger.info((Object)"PartnerCertsFile Bad format IBPSODT0601 file: No IBPS_CERT_COUNT element");
                logger.info((Object)"PartnerCertsFile Parse IBPSODT0601 failed");
                pcf = null;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        logger.info((Object)"PartnerCertsFile Parse IBPSODT0601 file finished");
        return pcf;
    }
}

