/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.pbc;

import cn.com.infosec.netsign.frame.util.XMLUtil;
import cn.com.infosec.util.encoders.Base64;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class PartnerCert {
    private byte[] detached;
    private String bankID;
    private String subject;

    public static PartnerCert parse(Element e, Logger logger) throws Exception {
        int end;
        logger.info((Object)"PartnerCert Parse partner certificate begin...");
        PartnerCert pc = new PartnerCert();
        pc.subject = XMLUtil.getStringValue(e, "CERTDN", null);
        if (pc.subject == null) {
            logger.info((Object)"PartnerCert Subject of certificate is null");
            logger.info((Object)"PartnerCert Parse certificate failed");
            return null;
        }
        pc.bankID = XMLUtil.getStringValue(e, "BANKCODE", null);
        if (pc.bankID == null) {
            logger.info((Object)("PartnerCert Partner id of certificate " + pc.subject + " is null"));
            logger.info((Object)("PartnerCert Parse certificate " + pc.subject + " failed"));
            return null;
        }
        if (pc.subject.indexOf(pc.bankID) < 0) {
            logger.info((Object)("PartnerCert Partner id:" + pc.bankID + " not a part of subject:" + pc.subject));
            logger.info((Object)("PartnerCert Parse certificate " + pc.subject + " failed"));
            return null;
        }
        String certmsg = XMLUtil.getStringValue(e, "CERTMSGBODY", null);
        if (certmsg == null) {
            logger.info((Object)("PartnerCert CERTMSGBODY of certificate " + pc.subject + " is null"));
            logger.info((Object)("PartnerCert Parse certificate " + pc.subject + " failed"));
            return null;
        }
        int start = (certmsg = new String(Base64.decode((String)certmsg))).indexOf("<DgtSgntr>") + 10;
        if (start >= (end = certmsg.indexOf("</DgtSgntr>", start))) {
            logger.info((Object)("PartnerCert No signature text for " + pc.subject));
            logger.info((Object)("PartnerCert Parse certificate " + pc.subject + " failed"));
            return null;
        }
        String p7b = certmsg.substring(start, end).trim();
        pc.detached = Base64.decode((String)p7b);
        logger.info((Object)("PartnerCert Parse partner certificate " + pc.subject + " finished"));
        return pc;
    }

    public byte[] getDetached() {
        return this.detached;
    }

    public void setDetached(byte[] detached) {
        this.detached = detached;
    }

    public String getBankID() {
        return this.bankID;
    }

    public void setBankID(String bankID) {
        this.bankID = bankID;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }
}

