/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.logger;

import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.AbstractLogger;
import cn.com.infosec.netsign.logger.LoggerException;
import cn.com.infosec.netsign.logger.LoggerRes;
import cn.com.infosec.netsign.logger.MyPatternLayout;
import cn.com.infosec.netsign.logger.MyRollingFileAppender;
import cn.com.infosec.netsign.logger.MySyslogAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DebugLogger
extends AbstractLogger {
    public DebugLogger(LoggerRes res) throws LoggerException {
        this.createDebuglogger(res);
    }

    public void Log(String msg) {
        long tid = Thread.currentThread().getId();
        this.logger.debug((Object)("Thread:" + tid + " " + msg));
    }

    private void createDebuglogger(LoggerRes loggerres) throws LoggerException {
        MyPatternLayout layout = new MyPatternLayout();
        layout.SetHeader(loggerres.getHeader());
        layout.setConversionPattern("%d{yyyy-MM-dd HH:mm:ss} %m%n");
        this.logger = Logger.getLogger((String)loggerres.getLoggerName());
        if (loggerres.IsUseRemoteLogger()) {
            this.logger.removeAppender("syslogAppender");
            MySyslogAppender appender = new MySyslogAppender();
            appender.init(loggerres, layout, loggerres.getDebugLogFacility());
            this.logger.addAppender((Appender)appender);
            this.logger.setLevel(Level.ALL);
        }
        this.logger.removeAppender("FileAppender");
        MyRollingFileAppender da = null;
        try {
            da = new MyRollingFileAppender((Layout)layout, loggerres.getLogFile());
            da.setName("FileAppender");
            if (ExtendedConfig.logBuffer() > 0) {
                da.setBufferSize(ExtendedConfig.logBuffer() * 1024);
                da.setBufferedIO(true);
            }
            da.setMaxBackupIndex(loggerres.getMaxBackUpIndex());
            da.setMaxFileSize(loggerres.getMaxFileSize());
            this.logger.addAppender((Appender)da);
            this.logger.setLevel(Level.DEBUG);
        }
        catch (Exception ex) {
            throw new LoggerException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        LoggerRes res = new LoggerRes();
        res.setLogFile("debug2.log");
        res.setMaxFileSize("1kb");
        DebugLogger logger = new DebugLogger(res);
        int i = 0;
        while (i < 100) {
            logger.Log("Sign  ok");
            ++i;
        }
    }
}

