/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.util;

import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.xmlparser.BinaryXMLParser;
import cn.com.infosec.xmlparser.BinaryXMLParserFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class SNMPAgentUtil {
    public static void main(String[] arg) {
        SNMPAgentUtil.addDownloadCRLService("test", "d:/TEMP");
    }

    private static boolean restartSNMPAgent(String serverHome) {
        try {
            String cmd = String.valueOf(serverHome) + "/SNMPAgent/SNMPAgent.sh";
            Runtime run = Runtime.getRuntime();
            Process p = run.exec(String.valueOf(cmd) + " -stop", null, new File(cmd).getParentFile());
            ConsoleLogger.logString(String.valueOf(cmd) + " -stop");
            InputStream in = p.getInputStream();
            byte[] result = new byte[1];
            int c = 0;
            while ((c = in.read(result)) > 0) {
                Thread.sleep(1000L);
                ConsoleLogger.logString("waiting for stop snmp " + c);
            }
            in.close();
            p.destroy();
            Thread.sleep(2000L);
            run.exec(String.valueOf(cmd) + " -start", null, new File(cmd).getParentFile());
            ConsoleLogger.logString(String.valueOf(cmd) + " -start");
            return true;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return false;
        }
    }

    public static boolean addNetSignService(String serviceName, String serverHome) {
        File f = new File(String.valueOf(serverHome) + "/SNMPAgent");
        if (f.exists()) {
            FileOutputStream out = null;
            FileInputStream in = null;
            try {
                in = new FileInputStream(String.valueOf(f.getAbsolutePath()) + "/SNMPAgent.xml");
                byte[] agentBS = new byte[in.available()];
                byte[] newAgent = null;
                in.read(agentBS);
                in.close();
                BinaryXMLParser parser = BinaryXMLParserFactory.getInstance((String)"Infosec");
                parser.setXML(agentBS);
                boolean hadtables = false;
                boolean hadnstables = false;
                if (parser.movetoElementByName("JMXTablemaps".getBytes())) {
                    hadtables = true;
                }
                in = new FileInputStream(String.valueOf(serverHome) + "/config/nssnmpprop.xml");
                byte[] tmp = new byte[in.available()];
                in.read(tmp);
                in.close();
                if (!hadtables) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("<JMXTablemaps>\n<JMXTablemap name=\"NetSignServices\" jmxserver=\"NetSignServer\" oidprefix=\"1.3.6.1.4.1.47566.3.2.1\">\n");
                    buf.append("<jmxObjectName>\n<entry objectName=\"cn.com.infosec.netsign.jmx.mbeans:type=").append(serviceName).append("\"/>\n</jmxObjectName>\n");
                    buf.append(new String(tmp)).append("\n</JMXTablemap>\n</JMXTablemaps>\n");
                    newAgent = parser.insertXML(buf.toString().getBytes(), "SNMPAgent");
                } else {
                    if (parser.movetoElement("JMXTablemap name=\"NetSignServices\"".getBytes())) {
                        hadnstables = true;
                    }
                    if (!hadnstables) {
                        StringBuffer buf = new StringBuffer();
                        buf.append("<JMXTablemap name=\"NetSignServices\" jmxserver=\"NetSignServer\" oidprefix=\"1.3.6.1.4.1.47566.3.2.1\">\n");
                        buf.append("<jmxObjectName>\n<entry objectName=\"cn.com.infosec.netsign.jmx.mbeans:type=").append(serviceName).append("\"/>\n</jmxObjectName>\n");
                        buf.append(new String(tmp)).append("\n</JMXTablemap>\n");
                        newAgent = parser.insertXML(buf.toString().getBytes(), "JMXTablemaps");
                    } else {
                        StringBuffer buf = new StringBuffer();
                        buf.append("<entry objectName=\"cn.com.infosec.netsign.jmx.mbeans:type=").append(serviceName).append("\"/>\n");
                        newAgent = parser.insertXML(buf.toString().getBytes(), "jmxObjectName");
                    }
                }
                if (newAgent != null) {
                    out = new FileOutputStream(String.valueOf(f.getAbsolutePath()) + "/SNMPAgent.xml");
                    out.write(newAgent);
                    out.flush();
                }
                boolean bl = SNMPAgentUtil.restartSNMPAgent(serverHome);
                return bl;
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                return false;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public static boolean deleteNSConfig(String serviceName, String serverHome) {
        File f = new File(String.valueOf(serverHome) + "/SNMPAgent");
        if (f.exists()) {
            FileOutputStream out = null;
            FileInputStream in = null;
            try {
                in = new FileInputStream(String.valueOf(f.getAbsolutePath()) + "/SNMPAgent.xml");
                byte[] agentBS = new byte[in.available()];
                byte[] newAgent = null;
                in.read(agentBS);
                in.close();
                BinaryXMLParser parser = BinaryXMLParserFactory.getInstance((String)"Infosec");
                parser.setXML(agentBS);
                boolean deleteEntry = false;
                boolean deleteTab = false;
                boolean deleteTabs = false;
                if (parser.moveto(("entry objectName=\"cn.com.infosec.netsign.jmx.mbeans:type=" + serviceName + "\"").getBytes())) {
                    deleteEntry = true;
                    parser.setLocation(0);
                    int i = 0;
                    while (parser.moveto("entry objectName=\"cn.com.infosec.netsign.jmx.mbeans:type=".getBytes())) {
                        parser.setLocation(parser.getLocation() + 1);
                        ++i;
                    }
                    if (i == 1) {
                        deleteTab = true;
                        parser.setLocation(0);
                        if (!parser.moveto("JMXTablemap name=\"DownloadCRLServices".getBytes())) {
                            deleteTabs = true;
                        }
                    }
                }
                parser.setLocation(0);
                newAgent = deleteTabs ? parser.deleteElement("JMXTablemaps".getBytes(), "JMXTablemaps".getBytes()) : (deleteTab ? parser.deleteElement("JMXTablemap name=\"NetSignServices".getBytes(), "JMXTablemap".getBytes()) : parser.deleteElement(("entry objectName=\"cn.com.infosec.netsign.jmx.mbeans:type=" + serviceName + "\"").getBytes(), "entry".getBytes()));
                if (newAgent != null) {
                    out = new FileOutputStream(String.valueOf(f.getAbsolutePath()) + "/SNMPAgent.xml");
                    out.write(newAgent);
                    out.flush();
                }
                boolean bl = SNMPAgentUtil.restartSNMPAgent(serverHome);
                return bl;
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                return false;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean deleteDCConfig(String serviceName, String serverHome) {
        File f = new File(String.valueOf(serverHome) + "/SNMPAgent");
        if (f.exists()) {
            FileOutputStream out = null;
            FileInputStream in = null;
            try {
                in = new FileInputStream(String.valueOf(f.getAbsolutePath()) + "/SNMPAgent.xml");
                byte[] agentBS = new byte[in.available()];
                byte[] newAgent = null;
                in.read(agentBS);
                in.close();
                BinaryXMLParser parser = BinaryXMLParserFactory.getInstance((String)"Infosec");
                parser.setXML(agentBS);
                boolean deleteEntry = false;
                boolean deleteTab = false;
                boolean deleteTabs = false;
                if (parser.moveto(("entry objectName=\"cn.com.infosec.downloadcrl.mbeans:type=" + serviceName + "\"").getBytes())) {
                    deleteEntry = true;
                    parser.setLocation(0);
                    int i = 0;
                    while (parser.moveto("entry objectName=\"cn.com.infosec.downloadcrl.mbeans:type=".getBytes())) {
                        parser.setLocation(parser.getLocation() + 1);
                        ++i;
                    }
                    if (i == 1) {
                        deleteTab = true;
                        parser.setLocation(0);
                        if (!parser.moveto("JMXTablemap name=\"NetSignServices".getBytes())) {
                            deleteTabs = true;
                        }
                    }
                }
                parser.setLocation(0);
                if (deleteTabs) {
                    newAgent = parser.deleteElement("JMXTablemaps".getBytes(), "JMXTablemaps".getBytes());
                } else if (deleteTab) {
                    newAgent = parser.deleteElement("JMXTablemap name=\"DownloadCRLServices".getBytes(), "JMXTablemap".getBytes());
                } else if (deleteEntry) {
                    newAgent = parser.deleteElement(("entry objectName=\"cn.com.infosec.downloadcrl.mbeans:type=" + serviceName + "\"").getBytes(), "entry".getBytes());
                }
                if (deleteEntry) {
                    parser.setXML(newAgent);
                    parser.setLocation(0);
                    newAgent = parser.deleteElement(("rule name=\"" + serviceName).getBytes(), "rule".getBytes());
                }
                if (newAgent != null) {
                    out = new FileOutputStream(String.valueOf(f.getAbsolutePath()) + "/SNMPAgent.xml");
                    out.write(newAgent);
                    out.flush();
                }
                boolean bl = SNMPAgentUtil.restartSNMPAgent(serverHome);
                return bl;
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                return false;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean addDownloadCRLService(String serviceName, String serverHome) {
        File f = new File(String.valueOf(serverHome) + "/SNMPAgent");
        if (f.exists()) {
            FileOutputStream out = null;
            FileInputStream in = null;
            try {
                StringBuffer buf;
                in = new FileInputStream(String.valueOf(f.getAbsolutePath()) + "/SNMPAgent.xml");
                byte[] agentBS = new byte[in.available()];
                byte[] newAgent = null;
                in.read(agentBS);
                in.close();
                BinaryXMLParser parser = BinaryXMLParserFactory.getInstance((String)"Infosec");
                parser.setXML(agentBS);
                boolean hadtables = false;
                boolean hadnstables = false;
                if (parser.movetoElementByName("JMXTablemaps".getBytes())) {
                    hadtables = true;
                }
                in = new FileInputStream(String.valueOf(serverHome) + "/config/dcsnmpprop.xml");
                byte[] tmp = new byte[in.available()];
                in.read(tmp);
                in.close();
                if (!hadtables) {
                    buf = new StringBuffer();
                    buf.append("<JMXTablemaps>\n<JMXTablemap name=\"DownloadCRLServices\" jmxserver=\"DownloadCRL\" oidprefix=\"1.3.6.1.4.1.47566.3.3.1\">\n");
                    buf.append("<jmxObjectName>\n<entry objectName=\"cn.com.infosec.downloadcrl.mbeans:type=").append(serviceName).append("\"/>\n</jmxObjectName>\n");
                    buf.append(new String(tmp)).append("\n</JMXTablemap>\n</JMXTablemaps>\n");
                    newAgent = parser.insertXML(buf.toString().getBytes(), "SNMPAgent");
                } else {
                    if (parser.movetoElement("JMXTablemap name=\"DownloadCRLServices\"".getBytes())) {
                        hadnstables = true;
                    }
                    if (!hadnstables) {
                        buf = new StringBuffer();
                        buf.append("<JMXTablemap name=\"DownloadCRLServices\" jmxserver=\"DownloadCRL\" oidprefix=\"1.3.6.1.4.1.47566.3.3.1\">\n");
                        buf.append("<jmxObjectName>\n<entry objectName=\"cn.com.infosec.downloadcrl.mbeans:type=").append(serviceName).append("\"/>\n</jmxObjectName>\n");
                        buf.append(new String(tmp)).append("\n</JMXTablemap>\n");
                        newAgent = parser.insertXML(buf.toString().getBytes(), "JMXTablemaps");
                    } else {
                        buf = new StringBuffer();
                        buf.append("<entry objectName=\"cn.com.infosec.downloadcrl.mbeans:type=").append(serviceName).append("\"/>\n");
                        newAgent = parser.insertXML(buf.toString().getBytes(), "jmxObjectName");
                    }
                }
                parser.setXML(newAgent);
                buf = new StringBuffer();
                buf.append("<rule name=\"").append(serviceName).append("\" type=\"stringcompare\">\n");
                buf.append("\t<entry name=\"jmx\" value=\"DownloadCRL/cn.com.infosec.downloadcrl.mbeans:type=").append(serviceName).append("/DcDownFaildCount\"/>\n");
                buf.append("\t<entry name=\"compareoperator\" value=\"CONTAIN\" />\n");
                buf.append("\t<entry name=\"targetvalue\" value=\"failed\" />\n");
                buf.append("\t<entry name=\"sendmessage\" value=\"Download crl ").append(serviceName).append(" $1\" />");
                buf.append("\t<entry name=\"trapOID\" value=\"1.3.6.1.4.1.47566.3.9.2\" />\n");
                buf.append("</rule>\n");
                byte[] trapAdded = parser.insertXML(buf.toString().getBytes(), "traprules");
                newAgent = trapAdded;
                if (newAgent != null) {
                    out = new FileOutputStream(String.valueOf(f.getAbsolutePath()) + "/SNMPAgent.xml");
                    out.write(newAgent);
                    out.flush();
                }
                boolean bl = SNMPAgentUtil.restartSNMPAgent(serverHome);
                return bl;
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
                return false;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }
}

