/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.util;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.SM3;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.sm2.SM2;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class PrivateKeyUtil {
    public static String encryptPrivateKey(byte[] priK, String password) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] preparedKey = null;
        if (priK.length % 2 == 1) {
            preparedKey = new byte[priK.length + 1];
            preparedKey[0] = 0;
            System.arraycopy(priK, 0, preparedKey, 1, priK.length);
        } else {
            preparedKey = priK;
        }
        int half = preparedKey.length / 2;
        byte[] priKH = new byte[half];
        System.arraycopy(preparedKey, 0, priKH, 0, half);
        byte[] priKL = new byte[half];
        System.arraycopy(preparedKey, half, priKL, 0, half);
        byte[] pwd = MessageDigest.getInstance("SHA1").digest(password.getBytes());
        byte[] pwdH = new byte[10];
        System.arraycopy(pwd, 0, pwdH, 0, 10);
        byte[] pwdL = new byte[10];
        System.arraycopy(pwd, 10, pwdL, 0, 10);
        SecretKeySpec key = new SecretKeySpec(pwdL, "RC4");
        Cipher c = Cipher.getInstance("RC4", "INFOSEC");
        c.init(1, key);
        byte[] encedKeyH = c.doFinal(priKH);
        key = new SecretKeySpec(pwdH, "RC4");
        c = Cipher.getInstance("RC4", "INFOSEC");
        c.init(1, key);
        byte[] encedKeyL = c.doFinal(priKL);
        byte[] encedKey = new byte[encedKeyH.length + encedKeyL.length];
        System.arraycopy(encedKeyH, 0, encedKey, 0, encedKeyH.length);
        System.arraycopy(encedKeyL, 0, encedKey, encedKeyH.length, encedKeyL.length);
        return Base64.encode((byte[])encedKey);
    }

    public static byte[] decryptPrivateKey(String priK, String password) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] preparedKey = Base64.decode((String)priK);
        int half = preparedKey.length / 2;
        byte[] priKH = new byte[half];
        System.arraycopy(preparedKey, 0, priKH, 0, half);
        byte[] priKL = new byte[half];
        System.arraycopy(preparedKey, half, priKL, 0, half);
        byte[] pwd = MessageDigest.getInstance("SHA1").digest(password.getBytes());
        byte[] pwdH = new byte[10];
        System.arraycopy(pwd, 0, pwdH, 0, 10);
        byte[] pwdL = new byte[10];
        System.arraycopy(pwd, 10, pwdL, 0, 10);
        SecretKeySpec key = new SecretKeySpec(pwdL, "RC4");
        Cipher c = Cipher.getInstance("RC4", "INFOSEC");
        c.init(2, key);
        byte[] decedKeyH = c.doFinal(priKH);
        key = new SecretKeySpec(pwdH, "RC4");
        c = Cipher.getInstance("RC4", "INFOSEC");
        c.init(2, key);
        byte[] decedKeyL = c.doFinal(priKL);
        byte[] decedKey = new byte[decedKeyH.length + decedKeyL.length];
        System.arraycopy(decedKeyH, 0, decedKey, 0, decedKeyH.length);
        System.arraycopy(decedKeyL, 0, decedKey, decedKeyH.length, decedKeyL.length);
        return decedKey;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        byte[] priK = PrivateKeyUtil.decryptPrivateKey("6CDldS9LPsjlDsk3u3G+pmdrMzBag+hwY1dpe81kEl8=", "C=CN,O=CFCA SM2 TEST OCA21,OU=CMBC,CN=041@ZtestSM273101@testSM273101@00000001:19a63087cf00ec42d821c23dc6f948e9add028ad");
        ConsoleLogger.logBinary("prik", priK);
        SM2Certificate cert = new SM2Certificate((InputStream)new ByteArrayInputStream(Base64.decode((String)"MIIBnTCCAUGgAwIBAgIFMAAAIHIwDAYIKoEcz1UBg3UFADArMQswCQYDVQQGEwJDTjEcMBoGA1UEChMTQ0ZDQSBTTTIgVEVTVCBPQ0EyMTAeFw0xMjA3MzEwODQ0MDVaFw0xMzA3MzEwODQ0MDVaMGwxCzAJBgNVBAYTAkNOMRwwGgYDVQQKExNDRkNBIFNNMiBURVNUIE9DQTIxMQ0wCwYDVQQLEwRDTUJDMTAwLgYDVQQDFCcwNDFAWnRlc3RTTTI3MzEwMUB0ZXN0U00yNzMxMDFAMDAwMDAwMDEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAATi9poAhbUVn38yX3ygkQWCppIasFe2CBw5G3xdhdwZ9dngYDJ4Qa4p7+p980YOtz8RMLDE75uD3E9z57prOqEWow8wDTALBgNVHQ8EBAMCBsAwDAYIKoEcz1UBg3UFAANIADBFAiA/RszY52vRpDT229+XmxWRACywsWJJqV1mQM40jSp50wIhAOu2STLGUwnDv2oXpm73n1IOzVOmTwCkhy0bcMMGRGsf")));
        SM2PrivateKey prik = new SM2PrivateKey(priK);
        byte[] digest = SM3.SM3Digest((byte[])"11111111".getBytes());
        ConsoleLogger.logBinary("digest", digest);
        byte[] signed = SM2.signHash((byte[])digest, (byte[])priK);
        SM2PublicKey pubk = (SM2PublicKey)cert.getPublicKey();
        byte[] bs = new byte[64];
        System.arraycopy(pubk.getX(), 0, bs, 0, 32);
        System.arraycopy(pubk.getY(), 0, bs, 32, 32);
        ConsoleLogger.logBinary("public key", bs);
        boolean v = SM2.verifyHash((byte[])digest, (byte[])signed, (byte[])bs);
        System.out.println(v);
    }
}

