/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.util;

import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class FileUploadUtil {
    private String name = "";
    private long fileSize = 0L;
    private List items;

    public static void resetFileContent(String file) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new FileInputStream(file);
                out = new FileOutputStream(String.valueOf(file) + ".tmp");
                OutputStreamWriter writer = new OutputStreamWriter(out);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = null;
                StringBuffer buf = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    line = line.replaceAll("&nbsp;", " ");
                    line = line.replaceAll("&lt;", "<");
                    line = line.replaceAll("&gt;", ">");
                    line = line.replaceAll("&amp;", "&");
                    line = line.replaceAll("&quot;", "\"");
                    line = line.replaceAll("&apos;", "'");
                    writer.write(line);
                    writer.write("\n");
                    writer.flush();
                }
                in.close();
                out.close();
                File f = new File(file);
                f.delete();
                File tmp = new File(String.valueOf(file) + ".tmp");
                tmp.renameTo(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public FileUploadUtil(HttpServletRequest request, String tmpDir) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(10000000);
        factory.setRepository(new File(tmpDir));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            this.items = upload.parseRequest(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getParameterValues(String field) {
        if (this.items == null || this.items.size() == 0 || field == null || field.equals("")) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int size = this.items.size();
        while (i < size) {
            FileItem iTmp = (FileItem)this.items.get(i);
            if (iTmp.getFieldName().equals(field)) {
                if (ExtendedConfig.getEncoding() != null) {
                    try {
                        list.add(iTmp.getString(ExtendedConfig.getEncoding()));
                    }
                    catch (Exception e) {
                        ConsoleLogger.logException(e);
                    }
                } else {
                    list.add(iTmp.getString());
                }
            }
            ++i;
        }
        if (list.size() > 0) {
            return list.toArray(new String[0]);
        }
        return null;
    }

    public String getParameter(String field) {
        if (this.items == null || this.items.size() == 0 || field == null || field.equals("")) {
            return null;
        }
        int i = 0;
        int size = this.items.size();
        while (i < size) {
            FileItem iTmp = (FileItem)this.items.get(i);
            if (iTmp.getFieldName().equals(field)) {
                if (ExtendedConfig.getEncoding() == null) {
                    return iTmp.getString();
                }
                try {
                    return iTmp.getString(ExtendedConfig.getEncoding());
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    public File getFile(String field, String saveDir) {
        if (this.items == null || this.items.size() == 0 || field == null || "".equals(field)) {
            return null;
        }
        int i = 0;
        int size = this.items.size();
        while (i < size) {
            FileItem iTmp = (FileItem)this.items.get(i);
            if (iTmp.getFieldName().equals(field)) {
                this.fileSize = iTmp.getSize();
                this.name = iTmp.getName();
                if (!iTmp.isFormField() && iTmp.getSize() > 0L) {
                    File tmpDir;
                    String fileName = iTmp.getName();
                    if (fileName.indexOf("\\") > -1) {
                        String[] tmp = fileName.split("\\\\");
                        fileName = tmp[tmp.length - 1];
                    }
                    if (!(tmpDir = new File(saveDir)).exists()) {
                        tmpDir.mkdirs();
                    }
                    File f = new File(String.valueOf(saveDir) + "/" + fileName);
                    try {
                        iTmp.write(f);
                        return f;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public long getFileSize() {
        return this.fileSize;
    }
}

