/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.util;

import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.der.util.DERSegment;
import cn.com.infosec.netsign.frame.util.ASN1Util;
import cn.com.infosec.netsign.frame.util.ByteArray;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertificateUtil {
    public static X509Certificate generateCertificate(String file) {
        if (file == null) {
            return null;
        }
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            byte[] bs = new byte[in.available()];
            in.read(bs);
            X509Certificate x509Certificate = CertificateUtil.generateCertificate(bs);
            return x509Certificate;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static X509Certificate generateCertificate(byte[] cert) throws Exception {
        ByteArrayInputStream in = null;
        if (cert[0] == 48) {
            int tl = (cert[1] & 0xFF) - 128;
            if (tl <= 0) throw new CertificateException("Illegal code: 30 " + (cert[1] & 0xFF));
            byte[] ltmp = new byte[tl];
            System.arraycopy(cert, 2, ltmp, 0, tl);
            int length = new BigInteger(ltmp).intValue();
            if (length <= 0 || length != cert.length - 2 - tl) throw new CertificateException("Illegal length: " + length);
            in = new ByteArrayInputStream(cert);
        } else {
            String head = "-----BEGIN CERTIFICATE-----";
            String tail = "-----END CERTIFICATE-----";
            String b64Cert = new String(cert);
            if (b64Cert.indexOf(head) > -1) {
                b64Cert = b64Cert.replaceFirst(head, "").replaceFirst(tail, "");
            }
            byte[] certTmp = Base64.decode((String)b64Cert.trim());
            in = new ByteArrayInputStream(certTmp);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
        X509Certificate certi = (X509Certificate)cf.generateCertificate(in);
        try {
            certi.getSubjectDN().getName();
            return certi;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getSubjectKid(X509Certificate cert) {
        byte[] subkid = cert.getExtensionValue(X509Extensions.SubjectKeyIdentifier.getId());
        if (subkid == null || subkid.length == 0) {
            return CertificateUtil.getSubjectKid(cert.getPublicKey());
        }
        byte[] tmp = new byte[subkid.length - 4];
        System.arraycopy(subkid, 4, tmp, 0, tmp.length);
        subkid = tmp;
        String kidStr = "";
        int i = 0;
        int length = subkid.length;
        while (i < length) {
            String tmp2 = Integer.toHexString(0xFF & subkid[i]);
            kidStr = String.valueOf(kidStr) + (tmp2.length() == 1 ? "0" + tmp2 : tmp2);
            ++i;
        }
        return kidStr;
    }

    public static String getSubjectKid(PublicKey pubk) {
        byte[] subkid = null;
        byte[] keyBs = pubk.getEncoded();
        keyBs = ASN1Util.getValue(keyBs);
        keyBs = ASN1Util.getObject(keyBs, 1);
        keyBs = ASN1Util.getValue(keyBs);
        try {
            MessageDigest dig = MessageDigest.getInstance("SHA1");
            subkid = dig.digest(keyBs);
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
        String kidStr = "";
        int i = 0;
        int length = subkid.length;
        while (i < length) {
            String tmp = Integer.toHexString(0xFF & subkid[i]);
            kidStr = String.valueOf(kidStr) + (tmp.length() == 1 ? "0" + tmp : tmp);
            ++i;
        }
        return kidStr;
    }

    public static byte[] getPublicKey(byte[] cert) {
        DERSegment seg = new DERSegment(cert);
        seg = seg.getInnerDERSegment().getInnerDERSegment();
        return seg.getDERSegment(6).getEncoded();
    }

    public static byte[] generateSM2CertificateByP10(byte[] p10, byte[] rootPriKey, byte[] baseCert) throws NoSuchAlgorithmException, CryptoException, NoSuchProviderException {
        byte[] cert = new byte[baseCert.length];
        System.arraycopy(baseCert, 0, cert, 0, baseCert.length);
        DERSegment seg = new DERSegment(p10);
        seg = seg.getInnerDERSegment().getInnerDERSegment().getDERSegment(2);
        byte[] pubk = seg.getEncoded();
        byte[] byArray = new byte[20];
        byArray[0] = 48;
        byArray[1] = 82;
        byArray[2] = 48;
        byArray[3] = 12;
        byArray[4] = 6;
        byArray[5] = 7;
        byArray[6] = 42;
        byArray[7] = -122;
        byArray[8] = 72;
        byArray[9] = -50;
        byArray[10] = 61;
        byArray[11] = 2;
        byArray[12] = 1;
        byArray[13] = 2;
        byArray[14] = 1;
        byArray[15] = 7;
        byArray[16] = 3;
        byArray[17] = 66;
        byArray[19] = 4;
        byte[] pubkhead = byArray;
        int pubkIndex = ByteArray.find(cert, pubkhead);
        System.arraycopy(pubk, 0, cert, pubkIndex, 84);
        seg = new DERSegment(cert);
        seg = seg.getInnerDERSegment().getDERSegment(0);
        byte[] tbs = seg.getEncoded();
        byte[] signed = SDFJNI.SM2SignWithExternalKey((byte[])tbs, (String)"SM3", (byte[])rootPriKey, null, null);
        System.arraycopy(signed, 0, cert, cert.length - 64, 64);
        return cert;
    }

    public static String trimDN(String dn) {
        String[] temp = dn.split(",");
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < temp.length) {
            buffer.append(String.valueOf(temp[i].trim()) + ",");
            ++i;
        }
        String value = buffer.toString();
        return value.substring(0, value.length() - 1);
    }

    public static String turnDN(String DN) {
        String[] temp = DN.split(",");
        String turnDN = temp[temp.length - 1].trim();
        int i = temp.length - 2;
        while (i >= 0) {
            turnDN = String.valueOf(turnDN) + "," + temp[i].trim();
            --i;
        }
        return turnDN;
    }

    public static void main(String[] args) throws Exception {
        FileInputStream in = new FileInputStream("D:\\TEMP\\ecc\\rootca.cer");
        byte[] bs = new byte[in.available()];
        in.read(bs);
        ConsoleLogger.logBinary("pubk", CertificateUtil.getPublicKey(bs));
    }
}

