/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.crypto.weekalg.WeekAlgorithm;
import cn.com.infosec.netsign.crypto.weekalg.WeekAlgorithmList;
import cn.com.infosec.netsign.crypto.weekalg.WeekDigestAlgorithm;
import cn.com.infosec.netsign.crypto.weekalg.WeekSymmetryAlgorithm;
import cn.com.infosec.netsign.crypto.weekalg.WeekUnsymmetryAlgorithm;
import cn.com.infosec.netsign.der.util.ConsoleLogger;
import cn.com.infosec.netsign.frame.config.WeekAlg;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WeekAlgConfig {
    private ArrayList algList = new ArrayList();

    public WeekAlg get(int i) {
        return (WeekAlg)this.algList.get(i);
    }

    public int size() {
        return this.algList.size();
    }

    public void clean() {
        this.algList.clear();
    }

    public void addAlg(WeekAlg wa) {
        int i = 0;
        int size = this.algList.size();
        while (i < size) {
            WeekAlg tmpWa = (WeekAlg)this.algList.get(i);
            if (tmpWa.getName().equals(wa.getName())) {
                this.algList.set(i, wa);
                return;
            }
            ++i;
        }
        this.algList.add(wa);
    }

    public static WeekAlgConfig parse(String file) {
        WeekAlgConfig weekAlgConfig;
        WeekAlgConfig wac = new WeekAlgConfig();
        FileInputStream fis = null;
        try {
            File f = new File(file);
            if (!f.exists() || f.length() == 0L) {
                return null;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(f);
            Element root = doc.getDocumentElement();
            NodeList nl = root.getElementsByTagName("alg");
            int i = 0;
            int length = nl.getLength();
            while (i < length) {
                Element algNode = (Element)nl.item(i);
                WeekAlg wa = WeekAlg.parse(algNode);
                wac.addAlg(wa);
                if (!(wa.isSign() && wa.isVerify() && wa.isEncrypt() && wa.isDecrypt())) {
                    if (wa.getType().equals("digest")) {
                        WeekDigestAlgorithm wda = new WeekDigestAlgorithm();
                        wda.setName(wa.getName());
                        wda.setSign(wa.isSign());
                        wda.setVerify(wa.isVerify());
                        WeekAlgorithmList.addAlg((WeekAlgorithm)wda);
                    }
                    if (wa.getType().equals("symmetry")) {
                        WeekSymmetryAlgorithm wsa = new WeekSymmetryAlgorithm();
                        wsa.setName(wa.getName());
                        wsa.setEncrypt(wa.isEncrypt());
                        wsa.setDecrypt(wa.isDecrypt());
                        WeekAlgorithmList.addAlg((WeekAlgorithm)wsa);
                    }
                }
                if (wa.getType().equals("unsymmetry")) {
                    WeekUnsymmetryAlgorithm wua = new WeekUnsymmetryAlgorithm();
                    wua.setName(wa.getName());
                    wua.setMinKeySize(wa.getMinKeyLength());
                    WeekAlgorithmList.addAlg((WeekAlgorithm)wua);
                }
                ++i;
            }
            weekAlgConfig = wac;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return null;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return weekAlgConfig;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<weekalg>\n");
        int i = 0;
        int size = this.algList.size();
        while (i < size) {
            WeekAlg wa = (WeekAlg)this.algList.get(i);
            buf.append("\t").append(wa.toString()).append("\n");
            ++i;
        }
        buf.append("</weekalg>");
        return buf.toString();
    }
}

