/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.util.XMLUtil;
import org.w3c.dom.Element;

public class WeekAlg {
    public static final String TYPE_DIGEST = "digest";
    public static final String TYPE_SYMMETRY = "symmetry";
    public static final String TYPE_UNSYMMETRY = "unsymmetry";
    private String name;
    private String type;
    private int minKeyLength;
    private boolean sign = true;
    private boolean verify = true;
    private boolean encrypt = true;
    private boolean decrypt = true;

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getMinKeyLength() {
        return this.minKeyLength;
    }

    public boolean isSign() {
        return this.sign;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public boolean isDecrypt() {
        return this.decrypt;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMinKeyLength(int minKeyLength) {
        this.minKeyLength = minKeyLength;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public void setDecrypt(boolean decrypt) {
        this.decrypt = decrypt;
    }

    public static WeekAlg parse(Element e) {
        WeekAlg wa = new WeekAlg();
        wa.setName(e.getAttribute("name"));
        wa.setType(e.getAttribute("type"));
        wa.setMinKeyLength(XMLUtil.getIntAttribute(e, "minkeylength", 0));
        wa.setSign(XMLUtil.getBooleanAttribute(e, "sign", true));
        wa.setVerify(XMLUtil.getBooleanAttribute(e, "verify", true));
        wa.setEncrypt(XMLUtil.getBooleanAttribute(e, "encrypt", true));
        wa.setDecrypt(XMLUtil.getBooleanAttribute(e, "decrypt", true));
        return wa;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<alg name=\"").append(this.name).append("\" type=\"").append(this.type).append("\" ");
        if (this.type.equals(TYPE_DIGEST)) {
            buf.append("sign=\"").append(this.sign).append("\" verify=\"").append(this.verify).append("\" ");
        }
        if (this.type.equals(TYPE_SYMMETRY)) {
            buf.append("encrypt=\"").append(this.encrypt).append("\" decrypt=\"").append(this.decrypt).append("\" ");
        }
        if (this.type.equals(TYPE_UNSYMMETRY)) {
            buf.append("minkeylength=\"").append(this.minKeyLength).append("\" ");
        }
        buf.append(" />");
        return buf.toString();
    }
}

