/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.CRLConfig;
import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.config.OCSPConfig;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TrustField
implements Config,
Serializable,
Cloneable {
    private String name;
    private ArrayList certs;
    private String keytype = "RSA";
    private OCSPConfig ocspConfig;
    private CRLConfig crlConfig;

    public static TrustField parse(Element e) {
        CRLConfig c;
        OCSPConfig o;
        Element certs;
        TrustField t = new TrustField();
        t.name = ConfigUtil.getAttributeValue(e, "name", "TrustField");
        t.keytype = ConfigUtil.getNodeText(e, "keytype", "RSA");
        if (t.keytype.equals("null")) {
            t.keytype = "RSA";
        }
        if ((certs = ConfigUtil.getElement(e, "certs")) == null) {
            return null;
        }
        NodeList nl = certs.getElementsByTagName("cert");
        t.certs = new ArrayList();
        int i = 0;
        int length = nl.getLength();
        while (i < length) {
            Text text;
            Element eTmp = (Element)nl.item(i);
            NodeList nlTmp = eTmp.getChildNodes();
            if (nlTmp != null && (text = (Text)nlTmp.item(0)) != null) {
                t.addCert(text.getNodeValue());
            }
            ++i;
        }
        Element eTmp = ConfigUtil.getElement(e, "ocsp-config");
        if (eTmp != null && (o = OCSPConfig.parse(eTmp)) != null) {
            t.ocspConfig = o;
        }
        if (t.ocspConfig == null && (eTmp = ConfigUtil.getElement(e, "crl-config")) != null && (c = CRLConfig.parse(eTmp)) != null) {
            t.crlConfig = c;
        }
        return t;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("\t<trustfield name=\"").append(this.name).append("\">\n");
        buf.append("\t\t<!--\u8bc1\u4e66\u94fe\uff0c\u914d\u7f6e\u987a\u5e8f\u4e3a\uff1a\u7ea7\u522b\u7531\u4f4e\u81f3\u9ad8-->\n");
        if (this.certs != null && this.certs.size() > 0) {
            buf.append("\t\t<certs>\n");
            int i = 0;
            int size = this.certs.size();
            while (i < size) {
                buf.append("\t\t\t<cert>").append(this.certs.get(i)).append("</cert>\n");
                ++i;
            }
            buf.append("\t\t</certs>\n");
        }
        if (this.keytype != null) {
            buf.append("\t\t<keytype>").append(this.keytype).append("</keytype>\n");
        }
        if (this.crlConfig != null) {
            buf.append(this.crlConfig.toXML());
        }
        if (this.ocspConfig != null) {
            buf.append(this.ocspConfig.toXML());
        }
        buf.append("\t</trustfield>\n");
        return buf.toString();
    }

    public void addCert(String file) {
        this.certs.add(file);
    }

    public int certsSize() {
        return this.certs.size();
    }

    public void remove(int i) {
        this.certs.remove(i);
    }

    public void remove(String file) {
        int i = 0;
        int size = this.certs.size();
        while (i < size) {
            String tmp = (String)this.certs.get(i);
            if (tmp.equals(file)) {
                this.certs.remove(i);
            }
            ++i;
        }
    }

    public ArrayList getCerts() {
        return this.certs;
    }

    public void setCerts(ArrayList certs) {
        this.certs = certs;
    }

    public CRLConfig getCrlConfig() {
        return this.crlConfig;
    }

    public void setCrlConfig(CRLConfig crlConfig) {
        this.crlConfig = crlConfig;
    }

    public OCSPConfig getOcspConfig() {
        return this.ocspConfig;
    }

    public void setOcspConfig(OCSPConfig ocspConfig) {
        this.ocspConfig = ocspConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object clone() throws CloneNotSupportedException {
        TrustField tf = new TrustField();
        tf.setName(this.name);
        tf.setKeytype(this.keytype);
        if (this.ocspConfig != null) {
            tf.setOcspConfig((OCSPConfig)this.ocspConfig.clone());
        } else {
            tf.setOcspConfig(null);
        }
        if (this.crlConfig != null) {
            tf.setCrlConfig((CRLConfig)this.crlConfig.clone());
        } else {
            tf.setCrlConfig(null);
        }
        if (this.certs != null) {
            tf.setCerts((ArrayList)this.certs.clone());
        } else {
            tf.setCerts(null);
        }
        return tf;
    }

    public String getKeytype() {
        return this.keytype;
    }

    public void setKeytype(String keytype) {
        this.keytype = keytype;
    }
}

