/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.config.Service;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceConfig
implements Config,
Serializable {
    private String accessLogFile = "access.log";
    private String accessLogFileSize = "10MB";
    private int accessLogRollback = 100;
    private String errorLogFile = "error.log";
    private String errorLogFileSize = "10MB";
    private int errorLogRollback = 100;
    private HashMap services = new HashMap();

    public static ServiceConfig parse(String file) {
        FileInputStream in = null;
        try {
            NodeList serviceL;
            ServiceConfig s = new ServiceConfig();
            in = new FileInputStream(file);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            Element root = doc.getDocumentElement();
            NodeList localLogL = root.getElementsByTagName("local-log");
            if (localLogL != null) {
                NodeList errorLogL;
                Element localLogE = (Element)localLogL.item(0);
                NodeList accessLogL = localLogE.getElementsByTagName("access-log");
                if (accessLogL != null) {
                    Element accessLogE = (Element)accessLogL.item(0);
                    s.accessLogFile = ConfigUtil.getAttributeValue(accessLogE, "filename", "access.log");
                    s.accessLogFileSize = ConfigUtil.getAttributeValue(accessLogE, "filesize", "10MB");
                    s.accessLogRollback = Integer.parseInt(ConfigUtil.getAttributeValue(accessLogE, "maxrollback", "100"));
                }
                if ((errorLogL = localLogE.getElementsByTagName("error-log")) != null) {
                    Element errorLogE = (Element)errorLogL.item(0);
                    s.errorLogFile = ConfigUtil.getAttributeValue(errorLogE, "filename", "error.log");
                    s.errorLogFileSize = ConfigUtil.getAttributeValue(errorLogE, "filesize", "10MB");
                    s.errorLogRollback = Integer.parseInt(ConfigUtil.getAttributeValue(errorLogE, "maxrollback", "100"));
                }
            }
            if ((serviceL = root.getElementsByTagName("service")) != null) {
                int i = 0;
                int length = serviceL.getLength();
                while (i < length) {
                    Element serviceE = (Element)serviceL.item(i);
                    Service service = Service.parse(serviceE);
                    if (service == null) {
                        System.out.println("Parse service failed");
                    } else {
                        s.addService(service);
                    }
                    ++i;
                }
            }
            ServiceConfig serviceConfig = s;
            return serviceConfig;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"GBK\"?>\n");
        buf.append("<service-config>\n");
        buf.append("\t<!--\u5168\u5c40\u914d\u7f6e-->\n");
        buf.append("\t<local-log>\n");
        buf.append("\t\t<access-log filename=\"").append(this.accessLogFile).append("\" filesize=\"").append(this.accessLogFileSize).append("\" maxrollback=\"").append(this.accessLogRollback).append("\" />\n");
        buf.append("\t\t<error-log filename=\"").append(this.errorLogFile).append("\" filesize=\"").append(this.errorLogFileSize).append("\" maxrollback=\"").append(this.errorLogRollback).append("\" />\n");
        buf.append("\t</local-log>\n");
        Service[] services = this.getServiceEntries();
        int i = 0;
        int length = services.length;
        while (i < length) {
            buf.append(services[i].toXML());
            ++i;
        }
        buf.append("</service-config>\n");
        return buf.toString();
    }

    public String getAccessLogFile() {
        return this.accessLogFile;
    }

    public void setAccessLogFile(String accessLogFile) {
        this.accessLogFile = accessLogFile;
    }

    public String getAccessLogFileSize() {
        return this.accessLogFileSize;
    }

    public void setAccessLogFileSize(String accessLogFileSize) {
        this.accessLogFileSize = accessLogFileSize;
    }

    public int getAccessLogRollback() {
        return this.accessLogRollback;
    }

    public void setAccessLogRollback(int accessLogRollback) {
        this.accessLogRollback = accessLogRollback;
    }

    public String getErrorLogFile() {
        return this.errorLogFile;
    }

    public void setErrorLogFile(String debugLogFile) {
        this.errorLogFile = debugLogFile;
    }

    public String getErrorLogFileSize() {
        return this.errorLogFileSize;
    }

    public void setErrorLogFileSize(String debugLogFileSize) {
        this.errorLogFileSize = debugLogFileSize;
    }

    public int getErrorLogRollback() {
        return this.errorLogRollback;
    }

    public void setErrorLogRollback(int debugLogRollback) {
        this.errorLogRollback = debugLogRollback;
    }

    public HashMap getServices() {
        return this.services;
    }

    public void setServices(HashMap services) {
        this.services = services;
    }

    public void addService(Service service) {
        this.services.put(service.getName(), service);
    }

    public Service[] getServiceEntries() {
        return this.services.values().toArray(new Service[0]);
    }

    public Service getService(String name) {
        return (Service)this.services.get(name);
    }

    public Service removeService(String name) {
        return (Service)this.services.remove(name);
    }
}

