/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class ProcessorPolicyConfig
implements Config {
    private HashMap needPwdProcessors = new HashMap();

    public void addProcessorPwdPolicy(String name, boolean check) {
        if (check) {
            this.needPwdProcessors.put(name, "1");
        }
    }

    public boolean getProcessorPwdPolicy(String name) {
        return this.needPwdProcessors.containsKey(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessorPolicyConfig parse(String file) {
        ProcessorPolicyConfig config = new ProcessorPolicyConfig();
        File f = new File(file);
        if (f.exists()) {
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(f);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String[] p2;
                        String[] p1;
                        if ((line = line.trim()).equals("") || line.startsWith("#") || (p1 = line.split("=")).length != 2 || (p2 = p1[0].split("\\.")).length != 2 || !p2[1].equals("checkapipwd") || !p1[1].equals("yes")) continue;
                        config.addProcessorPwdPolicy(p2[0], true);
                        System.out.println(String.valueOf(p2[0]) + " would check apipassword");
                    }
                    return config;
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                    try {
                        if (in == null) return config;
                        in.close();
                        return config;
                    }
                    catch (Exception e2) {
                        ConsoleLogger.logException(e2);
                    }
                }
                return config;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                }
            }
        }
        config.addProcessorPwdPolicy("DeleteRAWCertProcessor", true);
        System.out.println("DeleteRAWCertProcessor would check apipassword");
        config.addProcessorPwdPolicy("DetachedSignProcessor", true);
        System.out.println("DetachedSignProcessor would check apipassword");
        config.addProcessorPwdPolicy("RAWSignProcessor", true);
        System.out.println("RAWSignProcessor would check apipassword");
        config.addProcessorPwdPolicy("UploadRAWCertProcessor", true);
        System.out.println("UploadRAWCertProcessor would check apipassword");
        return config;
    }

    public String toXML() {
        return null;
    }
}

