/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import java.io.Serializable;
import org.w3c.dom.Element;

public class OCSPConfig
implements Config,
Serializable,
Cloneable {
    private String ocspCert = "";
    private String ip = "";
    private int port;

    public static OCSPConfig parse(Element e) {
        OCSPConfig o = new OCSPConfig();
        o.ocspCert = ConfigUtil.getNodeText(e, "ocsp-cert", null);
        if (o.ocspCert == null) {
            return null;
        }
        o.ip = ConfigUtil.getNodeText(e, "ip", null);
        if (o.ip == null) {
            return null;
        }
        o.port = ConfigUtil.getNodeInt(e, "port", -1);
        if (o.port < 0 || o.port > 65535) {
            return null;
        }
        return o;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("\t\t<ocsp-config>\n");
        buf.append("\t\t\t\t<ocsp-cert>").append(this.ocspCert).append("</ocsp-cert>\n");
        buf.append("\t\t\t\t<ip>").append(this.ip).append("</ip>\n");
        buf.append("\t\t\t\t<port>").append(this.port).append("</port>\n");
        buf.append("\t\t</ocsp-config>\n");
        return buf.toString();
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getOcspCert() {
        return this.ocspCert;
    }

    public void setOcspCert(String ocspCert) {
        this.ocspCert = ocspCert;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Object clone() throws CloneNotSupportedException {
        OCSPConfig ocsp = new OCSPConfig();
        if (this.ocspCert != null && !"".equals(this.ocspCert)) {
            ocsp.setOcspCert(this.ocspCert);
        } else {
            ocsp.setOcspCert(null);
        }
        ocsp.setIp(this.ip);
        ocsp.setPort(this.port);
        return ocsp;
    }
}

