/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.config.DownloadCRLService;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DownloadCRLConfig
implements Config {
    HashMap pool = null;
    private String dchome;
    private HashMap services;
    private String confignm = "";
    private String type;
    private String ldapurl;
    private String searchbasedn;
    private String searchfilter;
    private String maxcrls;
    private String url;
    private String crldir = "./../crl";
    private String timerspan;
    private String logfile;
    private String crlfilename;
    private String name;
    private String timeout;
    private boolean isreal = false;

    public DownloadCRLConfig(String DownloadcrlConfigflnm) {
        this.pool = new HashMap();
        this.confignm = DownloadcrlConfigflnm;
    }

    public void setConfigEntryItemValue(String ConfigElementKeyNM, String ConfigItemKeyNm, String ConfigItemValue) {
        this.setConfigElementValue(ConfigElementKeyNM, ConfigItemKeyNm, ConfigItemValue);
    }

    public void setConfigElementValue(String ConfigElementKeyNM, String ConfigItemKeyNm, String ConfigItemValue) {
        HashMap<String, String> httemp = (HashMap<String, String>)this.pool.get(ConfigElementKeyNM);
        if (httemp == null) {
            httemp = new HashMap<String, String>();
        }
        httemp.put(ConfigItemKeyNm, ConfigItemValue);
        this.pool.put(ConfigElementKeyNM, httemp);
    }

    public DownloadCRLConfig() {
        this.services = new HashMap();
    }

    public String getDchome() {
        return this.dchome;
    }

    public void setDchome(String dchome) {
        this.dchome = dchome;
    }

    public HashMap getServices() {
        return this.services;
    }

    public void setServices(HashMap services) {
        this.services = services;
    }

    public int serviceSize() {
        if (this.services != null) {
            return this.services.size();
        }
        return 0;
    }

    public void addService(DownloadCRLService service) {
        if (this.services == null) {
            this.services = new HashMap();
        }
        this.services.put(service.getName(), service);
    }

    public DownloadCRLService getService(String name) {
        if (this.services != null) {
            return (DownloadCRLService)this.services.get(name);
        }
        return null;
    }

    public void remove(String name) {
        if (this.services != null) {
            this.services.remove(name);
        }
    }

    public DownloadCRLService[] getAllService() {
        if (this.services != null) {
            return this.services.values().toArray(new DownloadCRLService[0]);
        }
        return null;
    }

    public static DownloadCRLConfig parse(String file) {
        FileInputStream in = null;
        try {
            DownloadCRLConfig c = new DownloadCRLConfig();
            in = new FileInputStream(file);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            Element e = doc.getDocumentElement();
            c.dchome = ConfigUtil.getNodeText(e, "dchome", "DownLoadCRL");
            NodeList nl = e.getElementsByTagName("dcservice");
            if (nl != null && nl.getLength() > 0) {
                int i = 0;
                int length = nl.getLength();
                while (i < length) {
                    Element service = (Element)nl.item(i);
                    c.addService(DownloadCRLService.parse(service));
                    ++i;
                }
            }
            DownloadCRLConfig downloadCRLConfig = c;
            return downloadCRLConfig;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"GBK\"?>\n");
        buf.append("<downloadcrl-config>\n");
        buf.append("\t<!--DownloadServer\u7684\u6839\u76ee\u5f55-->\n");
        buf.append("\t<dchome>").append(this.dchome).append("</dchome>\n");
        buf.append("\t<!--\u670d\u52a1\u914d\u7f6e\uff0cname\u4e3a\u670d\u52a1\u540d\u79f0\uff0c\u5e94\u4f7f\u7528ldap\u7684basedn-->\n");
        DownloadCRLService[] ses = this.services.values().toArray(new DownloadCRLService[0]);
        int i = 0;
        int size = ses.length;
        while (i < size) {
            buf.append(ses[i].toXML());
            ++i;
        }
        buf.append("</downloadcrl-config>\n");
        return buf.toString();
    }

    private byte[] toByteXML() throws Exception {
        HashMap tab = (HashMap)this.pool.get("INFO");
        this.timeout = (String)tab.get("timeout");
        this.type = (String)tab.get("downtype");
        this.ldapurl = (String)tab.get("ldaphost");
        this.searchbasedn = (String)tab.get("searchbasedn");
        this.searchfilter = (String)tab.get("searchfilter");
        this.maxcrls = (String)tab.get("maxcrls");
        this.url = (String)tab.get("httpurl");
        try {
            this.isreal = Boolean.parseBoolean((String)tab.get("isreal"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tab.get("store-path") != null) {
            this.crldir = (String)tab.get("store-path");
        }
        this.timerspan = (String)tab.get("timerspan");
        this.logfile = String.valueOf(this.confignm.replaceFirst("/NetSignServer/", "/NetSignServer/log/")) + ".log";
        this.crlfilename = (String)tab.get("crlfilename");
        this.name = new File(this.confignm).getName();
        this.name = this.name.substring(0, this.name.indexOf("."));
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"GB2312\"?>\n");
        buf.append("<downloader name=\"" + this.name + "\">\n");
        buf.append("\t<timeout>" + Integer.parseInt(this.timeout) * 1000 + "</timeout>\n");
        buf.append("\t<download-interval>" + Integer.parseInt(this.timerspan.trim()) * 1000 + "</download-interval>\n");
        buf.append("\t<save-interval>0</save-interval>\n");
        buf.append("\t<total-download-thread>1</total-download-thread>\n\t<total-save-thread>1</total-save-thread>\n");
        buf.append("\t<store-rule persist-mechanism=\"2\" derencode=\"true\">\n");
        buf.append("\t\t<store-path isreal=\"" + this.isreal + "\">" + this.crldir + "</store-path>\n\t</store-rule>\n");
        buf.append("\t<log debug-mode=\"false\">\n");
        buf.append("\t\t<log-file>" + this.logfile + "</log-file>\n");
        buf.append("\t\t<max-file-size>20MB</max-file-size>\n\t\t<max-backup-index>10</max-backup-index>\n\t</log>\n");
        if (this.type.equals("ldap")) {
            this.toXMLLDAP(buf);
        } else if (this.type.equals("http")) {
            this.toXMLHTTP(buf);
        }
        buf.append("</downloader>");
        return buf.toString().getBytes("GB2312");
    }

    private void toXMLLDAP(StringBuffer buf) {
        buf.append("\t<connection type=\"ldap\">\n");
        buf.append("\t\t<url>" + this.ldapurl);
        buf.append("</url>\n\t</connection>\n");
        buf.append("\t<download-rule getcfl=\"false\">\n");
        buf.append("\t\t<base-dn>" + this.searchbasedn);
        if (this.searchbasedn.indexOf("SHECA") > -1) {
            buf.append("</base-dn>\n\t\t<crl-key>certificateRevocationList</crl-key>\n");
        } else {
            buf.append("</base-dn>\n\t\t<crl-key>certificateRevocationList;binary</crl-key>\n");
        }
        buf.append("\t\t<common-rule>\n");
        buf.append("\t\t\t<prefix-content>\n");
        if (this.searchfilter.indexOf("|") < 0) {
            buf.append("\t\t\t\t<value>" + this.searchfilter);
            buf.append("</value>\n");
        } else {
            String[] strs = this.searchfilter.split("\\|");
            int i = 0;
            int length = strs.length;
            while (i < length) {
                if (!strs[i].trim().equals("")) {
                    buf.append("\t\t\t\t<value>" + strs[i].trim());
                    buf.append("</value>\n");
                }
                ++i;
            }
        }
        buf.append("\t\t\t</prefix-content>\n");
        buf.append("\t\t\t<mid-content>\n\t\t\t\t<range division=\"100\">");
        buf.append(String.valueOf(this.maxcrls) + "</range>\n\t\t\t</mid-content>\n");
        buf.append("\t\t\t<!--<postfix-content>\n\t\t\t\t<value>.crl</value>");
        buf.append("\n\t\t\t</postfix-content>-->\n\t\t</common-rule>\n\t</download-rule>\n");
    }

    private void toXMLHTTP(StringBuffer buf) {
        buf.append("\t<connection type=\"http\">\n");
        buf.append("\t\t<url>" + this.url);
        buf.append("</url>\n\t</connection>\n");
        buf.append("\t<download-rule getcfl=\"false\">\n");
        buf.append("\t\t<special-rule>\n");
        if (this.crlfilename.indexOf("|") > 0) {
            String[] strs = this.crlfilename.split("\\|");
            int i = 0;
            int length = strs.length;
            while (i < length) {
                if (!strs[i].trim().equals("")) {
                    buf.append("\t\t\t<value>").append(strs[i].trim()).append("</value>\n");
                }
                ++i;
            }
        } else {
            buf.append("\t\t\t<value>").append(this.crlfilename).append("</value>\n");
        }
        buf.append("\t\t</special-rule>\n");
        buf.append("\t</download-rule>\n");
    }

    public void putConfig() throws Exception {
        DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.confignm)));
        System.out.println("save file " + this.confignm);
        if (this.pool != null) {
            try {
                dout.write(this.toByteXML());
                dout.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dout.close();
    }
}

