/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AdminConfig
implements Serializable {
    private String name;
    private String ip;
    private int port;
    private int timeout;
    private String logFile;
    private String size;
    private int maxFiles;
    private String lib;
    private String token;
    private String pwd;

    public static AdminConfig parse(String file) {
        AdminConfig ac = new AdminConfig();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            Element root = doc.getDocumentElement();
            ac.name = ConfigUtil.getNodeText(root, "name", "Management Channel");
            ac.ip = ConfigUtil.getNodeText(root, "ip", "*");
            ac.port = ConfigUtil.getNodeInt(root, "port", -1);
            ac.timeout = ConfigUtil.getNodeInt(root, "timeout", 3000) * 1000;
            ac.logFile = ConfigUtil.getNodeText(root, "log-file", "system.log");
            ac.size = ConfigUtil.getNodeText(root, "size", "10MB");
            ac.maxFiles = ConfigUtil.getNodeInt(root, "max-files", 10);
            if (ExtendedConfig.getAlgMode().equals("hard")) {
                NodeList p11L = root.getElementsByTagName("p11");
                if (p11L != null) {
                    Element p11 = (Element)p11L.item(0);
                    ac.lib = ConfigUtil.getAttributeValue(p11, "lib", null);
                    ac.token = ConfigUtil.getAttributeValue(p11, "token", null);
                    ac.pwd = ConfigUtil.getAttributeValue(p11, "pwd", null);
                    if (ac.lib == null || ac.token == null || ac.pwd == null) {
                        System.out.println("Missing P11 attributes");
                    }
                } else {
                    System.out.println("Missing P11 config");
                }
            }
            AdminConfig adminConfig = ac;
            return adminConfig;
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getLib() {
        return this.lib;
    }

    public void setLib(String lib) {
        this.lib = lib;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

