/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.ctrl.creator;

import java.util.List;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.el.FixedValue;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.openwebflow.util.CloneUtils;
import org.openwebflow.util.ProcessDefinitionUtils;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuntimeActivityCreatorSupport {
    private static int SEQUNCE_NUMBER = 0;

    protected ActivityImpl cloneActivity(ProcessDefinitionEntity processDefinition, ActivityImpl prototypeActivity, String newActivityId, String ... fieldNames) {
        ActivityImpl clone = processDefinition.createActivity(newActivityId);
        CloneUtils.copyFields(prototypeActivity, clone, fieldNames);
        return clone;
    }

    protected TaskDefinition cloneTaskDefinition(TaskDefinition taskDefinition) {
        TaskDefinition newTaskDefinition = new TaskDefinition(taskDefinition.getTaskFormHandler());
        BeanUtils.copyProperties((Object)taskDefinition, (Object)newTaskDefinition);
        return newTaskDefinition;
    }

    protected ActivityImpl createActivity(ProcessEngine processEngine, ProcessDefinitionEntity processDefinition, ActivityImpl prototypeActivity, String cloneActivityId, String assignee) {
        ActivityImpl clone = this.cloneActivity(processDefinition, prototypeActivity, cloneActivityId, "executionListeners", "properties");
        UserTaskActivityBehavior activityBehavior = (UserTaskActivityBehavior)prototypeActivity.getActivityBehavior();
        TaskDefinition taskDefinition = this.cloneTaskDefinition(activityBehavior.getTaskDefinition());
        taskDefinition.setKey(cloneActivityId);
        if (assignee != null) {
            taskDefinition.setAssigneeExpression((Expression)new FixedValue((Object)assignee));
        }
        UserTaskActivityBehavior cloneActivityBehavior = ((ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration()).getActivityBehaviorFactory().createUserTaskActivityBehavior(null, taskDefinition);
        clone.setActivityBehavior((ActivityBehavior)cloneActivityBehavior);
        return clone;
    }

    protected ActivityImpl createActivity(ProcessEngine processEngine, ProcessDefinitionEntity processDefinition, String prototypeActivityId, String cloneActivityId, String assignee) {
        ActivityImpl prototypeActivity = ProcessDefinitionUtils.getActivity(processEngine, processDefinition.getId(), prototypeActivityId);
        return this.createActivity(processEngine, processDefinition, prototypeActivity, cloneActivityId, assignee);
    }

    protected void createActivityChain(List<ActivityImpl> activities, ActivityImpl nextActivity) {
        for (int i = 0; i < activities.size(); ++i) {
            activities.get(i).getOutgoingTransitions().clear();
            activities.get(i).createOutgoingTransition("flow" + (i + 1)).setDestination(i == activities.size() - 1 ? nextActivity : activities.get(i + 1));
        }
    }

    protected String createUniqueActivityId(String processInstanceId, String prototypeActivityId) {
        return processInstanceId + ":" + prototypeActivityId + ":" + System.currentTimeMillis() + "-" + SEQUNCE_NUMBER++;
    }
}

