/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.alarm.impl;

import java.io.InputStreamReader;
import java.io.Reader;
import javax.script.ScriptEngine;
import org.activiti.engine.impl.scripting.JuelScriptEngineFactory;
import org.activiti.engine.task.Task;
import org.h2.util.IOUtils;
import org.openwebflow.alarm.MessageNotifier;
import org.openwebflow.alarm.impl.MailSender;
import org.openwebflow.identity.UserDetailsEntity;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class MailMessageNotifier
implements MessageNotifier,
InitializingBean {
    MailSender _mailSender;
    String _messageTemplate;
    Resource _messageTemplateResource;
    String _subject;
    private String _subjectTemplate;

    public void afterPropertiesSet() throws Exception {
        this._messageTemplate = IOUtils.readStringAndClose((Reader)new InputStreamReader(this._messageTemplateResource.getInputStream()), (int)((int)this._messageTemplateResource.contentLength()));
    }

    public MailSender getMailSender() {
        return this._mailSender;
    }

    public Resource getMessageTemplateResource() {
        return this._messageTemplateResource;
    }

    public String getSubject() {
        return this._subject;
    }

    public String getSubjectTemplate() {
        return this._subjectTemplate;
    }

    public void notify(UserDetailsEntity[] users, Task task) throws Exception {
        for (UserDetailsEntity user : users) {
            if (user == null) continue;
            ScriptEngine scriptEngine = new JuelScriptEngineFactory().getScriptEngine();
            scriptEngine.put("user", user);
            scriptEngine.put("task", task);
            String email = (String)user.getProperty("STRING_PROPERTY_EMAIL");
            if (email == null) continue;
            this._mailSender.sendMail(email, (String)scriptEngine.eval(this._subjectTemplate), (String)scriptEngine.eval(this._messageTemplate));
        }
    }

    public void setMailSender(MailSender mailSender) {
        this._mailSender = mailSender;
    }

    public void setMessageTemplateResource(Resource messageTemplateResource) {
        this._messageTemplateResource = messageTemplateResource;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public void setSubjectTemplate(String subjectTemplate) {
        this._subjectTemplate = subjectTemplate;
    }
}

