/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.util;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.Column;
import com.fr.fs.dao.FSDAOManager;
import com.fr.fs.dao.properties.ScheduleDAOProperties;
import com.fr.schedule.util.ScheduleLogUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleDaoUtils {
    public static boolean findColumnInTable(String string, String string2, Connection connection) {
        PreparedStatement preparedStatement;
        Table table = new Table(string);
        Select select = new Select(table, DialectFactory.generateDialect((Connection)connection));
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return false;
        }
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                if (!string2.equalsIgnoreCase(resultSetMetaData.getColumnName(i))) continue;
                return true;
            }
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addColumns4NewConnection(List<Column> list, String string) {
        Connection connection = null;
        String string2 = string;
        try {
            connection = ScheduleDAOProperties.getInstance().createDatabaseConnection().createConnection();
            connection.setAutoCommit(false);
            Dialect dialect = DialectFactory.generateDialect((Connection)connection);
            for (Column column : list) {
                FSDAOManager.addTableColumn(connection, dialect, column, string2);
            }
            connection.commit();
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            ScheduleLogUtils.error(exception);
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }
}

