/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.ConfigManager;
import com.fr.base.EmailManager;
import com.fr.base.FRContext;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.CompatiableIDFCMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.base.entity.User;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.fun.FileSenderProcessor;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.utils.ReportDelimiter;
import com.fr.schedule.output.AbstractOutputFileAction;
import com.fr.schedule.output.DefaultFileSenderProcessor;
import com.fr.schedule.output.EmailException;
import com.fr.schedule.output.OutputFileAction;
import com.fr.schedule.plugin.EmailAddressOrderProvider;
import com.fr.schedule.plugin.ExtraPlatformScheduleClassManager;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailNotification
extends AbstractOutputFileAction {
    public static final String XML_TAG = "EmailNotification";
    public static final String TABLE_NAME = "fr_schedule_email";
    private static final String EMAIL_SEPARATOR = ",";
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(EmailNotification.class, new Table("fr_schedule_email"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, new ColumnSize(20), false, true), new CommonFieldColumnMapper("toAddress", 12, "toAddress", new ColumnSize(255), true), new CommonFieldColumnMapper("ccAddress", 12, "ccAddress", new ColumnSize(255), true), new CommonFieldColumnMapper("bccAddress", 12, "bccAddress", new ColumnSize(255), true), new CommonFieldColumnMapper("subject", 12, "subject", new ColumnSize(255), true), new CommonFieldColumnMapper("bodyContent", 12, "bodyContent", new ColumnSize(255), true), new CommonFieldColumnMapper("canPreviewAttach", 16, "canPreviewAttach", new ColumnSize(20), true), new CommonFieldColumnMapper("isRole", 16, "isRole", new ColumnSize(20), false)});
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private String toAddress = "";
    private String ccAddress = "";
    private String bccAddress = "";
    private String subject;
    private String bodyContent;
    private Boolean canPreviewAttach;
    private List<File> previewFiles = null;
    private boolean isRole = false;
    private static FRLogger log = FRLogger.getLogger();

    public EmailNotification() {
    }

    public EmailNotification(String string, String string2, String string3, String string4, String string5, Boolean bl, boolean bl2) {
        this.toAddress = string;
        this.ccAddress = string2;
        this.bccAddress = string3;
        this.subject = string4;
        this.bodyContent = string5;
        this.canPreviewAttach = bl;
        this.isRole = bl2;
    }

    @Override
    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.getId());
        jSONObject.put("toAddress", (Object)this.getToAddress());
        jSONObject.put("ccAddress", (Object)this.getCcAddress());
        jSONObject.put("bccAddress", (Object)this.getBccAddress());
        jSONObject.put("subject", (Object)this.getSubject());
        jSONObject.put("bodyContent", (Object)this.getBodyContent());
        jSONObject.put("canPreviewAttach", (Object)this.getCanPreviewAttach());
        jSONObject.put("isRole", this.isRole());
        return jSONObject;
    }

    public boolean isRole() {
        return this.isRole;
    }

    public void setRole(boolean bl) {
        this.isRole = bl;
    }

    @Override
    public OutputFileAction analyzeJSON(JSONObject jSONObject) {
        try {
            EmailNotification emailNotification = null;
            emailNotification = jSONObject.has("id") ? (EmailNotification)ScheduleContext.createDAOSession().load(EmailNotification.class, jSONObject.optLong("id")) : new EmailNotification();
            String string = jSONObject.getString("toAddress");
            String string2 = jSONObject.getString("ccAddress");
            String string3 = jSONObject.getString("bccAddress");
            String string4 = jSONObject.getString("subject");
            String string5 = jSONObject.getString("bodyContent");
            Boolean bl = jSONObject.getBoolean("canPreviewAttach");
            boolean bl2 = jSONObject.optBoolean("isRole");
            try {
                string4 = CodeUtils.cjkDecode((String)string4);
                string5 = CodeUtils.cjkDecode((String)string5);
            }
            catch (Exception exception) {
                string4 = jSONObject.getString("subject");
                string5 = jSONObject.getString("bodyContent");
            }
            emailNotification.setToAddress(string);
            emailNotification.setCcAddress(string2);
            emailNotification.setBccAddress(string3);
            emailNotification.setSubject(string4);
            emailNotification.setBodyContent(string5);
            emailNotification.setCanPreviewAttach(bl);
            emailNotification.setRole(bl2);
            return emailNotification;
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
            return null;
        }
    }

    @Override
    public ObjectTableMapper objectTableMapper2Register() {
        return null;
    }

    @Override
    public File[] getFilesToDealWith(File[] fileArray) {
        Object object;
        if (this.getCanPreviewAttach().booleanValue()) {
            object = new ArrayList();
            for (File file : fileArray) {
                if (!file.getName().endsWith(".png")) continue;
                ((ArrayList)object).add(file);
            }
            if (!((ArrayList)object).isEmpty()) {
                this.setPreviewFiles((List<File>)object);
            }
        }
        if ((object = (FileSenderProcessor)ExtraPlatformClassManager.getInstance().getSingle("FileSenderProcessor")) == null) {
            object = new DefaultFileSenderProcessor();
        }
        return object.filterFiles(fileArray);
    }

    @Override
    public CompatiableIDFCMapper getExtraOutputFileActionForeignKey() {
        return null;
    }

    @Override
    public void doFileAction(File[] fileArray) throws Exception {
        try {
            this.doFileAction(fileArray, this.getToAddress());
        }
        catch (EmailException emailException) {
            ScheduleLogUtils.error(emailException);
            throw emailException;
        }
    }

    public String getNeedMailUser() {
        return this.getNeedMailUser(this.getToAddress());
    }

    public String getNeedMailUser(String string) {
        if (this.isRole && ReportDelimiter.containsRoleDelimiter((String)string)) {
            string = this.readRoleMailString(string);
        }
        Set set = ExtraPlatformScheduleClassManager.getInstance().getArray("EmailAddressOrderProvider");
        for (EmailAddressOrderProvider emailAddressOrderProvider : set) {
            String string2 = emailAddressOrderProvider.sortAddress(string);
            if (!StringUtils.isNotEmpty((String)string2)) continue;
            return string2;
        }
        return string;
    }

    private String readRoleMailString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split(EMAIL_SEPARATOR);
        List list = null;
        try {
            list = UserControl.getInstance().findAllUser();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        for (String string2 : stringArray) {
            Set set = this.getUserIdsInRole(string2);
            for (User user : list) {
                long l = user.getId();
                String string3 = user.getEmail();
                if (StringUtils.isEmpty((String)string3) || stringBuffer.toString().indexOf(string3) != -1 || !set.contains(l)) continue;
                stringBuffer.append(string3).append(EMAIL_SEPARATOR);
            }
        }
        String string4 = stringBuffer.toString();
        return string4.endsWith(EMAIL_SEPARATOR) ? string4.substring(0, string4.length() - 1) : string4;
    }

    protected Set getUserIdsInRole(String string) {
        HashSet hashSet = new HashSet();
        try {
            if (Long.parseLong(ReportDelimiter.getRoleType((String)string)) == 2L) {
                return CustomRoleControl.getInstance().getUsersID(Integer.parseInt(ReportDelimiter.getRoleId((String)string)));
            }
            if (Long.parseLong(ReportDelimiter.getRoleType((String)string)) == 1L) {
                return CompanyRoleControl.getInstance().getUsersID(Integer.parseInt(ReportDelimiter.getRoleId((String)string)));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return hashSet;
    }

    private MessagingException emailSendFailedProcess(File[] fileArray, SendFailedException sendFailedException) throws Exception {
        SendFailedException sendFailedException2 = sendFailedException;
        Object[] objectArray = sendFailedException.getValidUnsentAddresses();
        Object[] objectArray2 = sendFailedException.getInvalidAddresses();
        if (!ArrayUtils.isEmpty((Object[])objectArray2)) {
            String string = StableUtils.join((Object[])objectArray2, (String)";");
            sendFailedException2 = new MessagingException("\n" + Inter.getLocText((String)"FS-Schedule-Invalid_Unsent_Email_Address") + string + "\n" + sendFailedException.getCause());
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                EmailManager emailManager = EmailNotification.getEmailManager();
                emailManager.send(this.removeInvalidAddress(this.getNeedMailUser(this.toAddress), (Address[])objectArray2), this.removeInvalidAddress(this.getNeedMailUser(this.ccAddress), (Address[])objectArray2), this.removeInvalidAddress(this.getNeedMailUser(this.bccAddress), (Address[])objectArray2), null, this.dealWithParameter(this.getSubject()), this.dealWithParameter(this.getBodyContent()), (Object)fileArray, this.getPreviewFiles());
            }
        }
        return sendFailedException2;
    }

    private String removeInvalidAddress(String string, Address[] addressArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.trim().split(EMAIL_SEPARATOR);
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < addressArray.length; ++j) {
                if (!ComparatorUtils.equals((String)stringArray[i], (String)addressArray[j].toString())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(stringArray[i]);
        }
        return StableUtils.join(arrayList, (String)EMAIL_SEPARATOR);
    }

    public void doFileAction(File[] fileArray, String string) throws Exception {
        if (StringUtils.isNotBlank((String)string)) {
            string = this.getNeedMailUser(string);
            try {
                EmailManager emailManager = EmailNotification.getEmailManager();
                if (emailManager == null) {
                    throw new EmailException("Email Manager is not Configed!");
                }
                emailManager.send(string, this.getNeedMailUser(this.getCcAddress()), this.getNeedMailUser(this.getBccAddress()), null, this.dealWithParameter(this.getSubject()), this.dealWithParameter(this.getBodyContent()), (Object)fileArray, this.getPreviewFiles());
            }
            catch (SendFailedException sendFailedException) {
                throw new EmailException(this.emailSendFailedProcess(fileArray, sendFailedException));
            }
            catch (MessagingException messagingException) {
                throw new EmailException(messagingException);
            }
        }
    }

    public static EmailManager getEmailManager() {
        EmailManager emailManager = ConfigManager.getProviderInstance().getEmailManager();
        if (emailManager == null) {
            emailManager = new EmailManager();
            ConfigManager.getProviderInstance().setEmailManager(emailManager);
        }
        return emailManager;
    }

    public void setId(long l) {
        this.id = l;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setToAddress(String string) {
        this.toAddress = string;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setCcAddress(String string) {
        this.ccAddress = string;
    }

    public String getCcAddress() {
        return this.ccAddress;
    }

    public void setBccAddress(String string) {
        this.bccAddress = string;
    }

    public String getBccAddress() {
        return this.bccAddress;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setBodyContent(String string) {
        this.bodyContent = string;
    }

    public String getBodyContent() {
        if (this.bodyContent == null) {
            return "";
        }
        return this.bodyContent;
    }

    public void setCanPreviewAttach(Boolean bl) {
        this.canPreviewAttach = bl;
    }

    public Boolean getCanPreviewAttach() {
        return this.canPreviewAttach;
    }

    public void setPreviewFiles(List<File> list) {
        this.previewFiles = list;
    }

    public List<File> getPreviewFiles() {
        return this.previewFiles;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EmailNotification)) {
            return false;
        }
        EmailNotification emailNotification = (EmailNotification)object;
        return ComparatorUtils.equals((String)emailNotification.getBccAddress(), (String)this.getBccAddress()) && ComparatorUtils.equals((String)emailNotification.getCcAddress(), (String)this.getCcAddress()) && ComparatorUtils.equals((String)emailNotification.getToAddress(), (String)this.getToAddress()) && ComparatorUtils.equals((Object)emailNotification.isRole(), (Object)this.isRole());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EmailNotification emailNotification = (EmailNotification)super.clone();
        return emailNotification;
    }

    @Override
    public String getJsonTag() {
        return "emailNotification";
    }

    @Override
    public boolean isEmailNotification() {
        return true;
    }
}

