/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.plugin.customstyle.service;

import com.fr.base.FRContext;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONObject;
import com.fr.report.web.style.CustomStyleManagerProvider;
import com.fr.report.web.style.CustomStyleXMLFileManager;
import com.fr.stable.StringUtils;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CustomStyleGetSelectionAction
extends ActionNoSessionCMD {
    private static final String CUSTOM_STYLE_TYPE_TOAST = "toast";
    private static final String CUSTOM_STYLE_DEFAULT = "Default";

    public String getCMD() {
        return "get_selection";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 14L)) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"type");
        JSONObject jSONObject = JSONObject.create();
        jSONObject.put(string, (Object)this.getStyleSelection(string));
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private String getStyleSelection(String string) {
        CustomStyleManagerProvider customStyleManagerProvider = CustomStyleXMLFileManager.getProviderInstance();
        if (ComparatorUtils.equals((String)string, (String)CUSTOM_STYLE_TYPE_TOAST)) {
            String string2 = customStyleManagerProvider.getToastSelection();
            if (StringUtils.isEmpty((String)string2)) {
                customStyleManagerProvider.setToastSelection(CUSTOM_STYLE_DEFAULT);
            } else {
                return string2;
            }
        }
        try {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)customStyleManagerProvider);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return CUSTOM_STYLE_DEFAULT;
    }
}

