/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.dao.EntryDAO;
import com.fr.fs.dao.FileEntryDAO;
import com.fr.fs.dao.FolderEntryDAO;
import com.fr.fs.dao.ReportProcessEntryDAO;
import com.fr.fs.dao.ReportletEntryDAO;
import com.fr.fs.dao.URLEntryDAO;
import com.fr.fs.schedule.entry.FolderEntry;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.fs.web.platform.entry.BaseEntry;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.fs.web.platform.entry.ReportProcessEntry;
import com.fr.fs.web.platform.entry.URLEntry;
import com.fr.general.FRLogger;
import com.fr.stable.ArrayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryPoolFactory {
    private static Map<String, Class<? extends BaseEntry>> entryMap = new HashMap<String, Class<? extends BaseEntry>>();
    private static Map<Integer, EntryDAO<? extends Entry>> map = new HashMap<Integer, EntryDAO<? extends Entry>>();
    private static List<String> entryTableNames = new ArrayList<String>();
    private static List<String> mobileEntryTableNames = new ArrayList<String>();

    public static void registerEntry(String string, Class<? extends BaseEntry> clazz) {
        entryMap.put(string, clazz);
    }

    public static BaseEntry getEntry(String string) {
        Class<? extends BaseEntry> clazz = entryMap.get(string);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static void registerEntryDAO(int n, EntryDAO<? extends Entry> entryDAO) {
        map.put(n, entryDAO);
    }

    public static EntryDAO<? extends Entry> getEntryDAO(int n) {
        EntryDAO<? extends Entry> entryDAO = map.get(n);
        if (entryDAO != null) {
            return entryDAO;
        }
        throw new IllegalArgumentException("Illegal Type!");
    }

    public static void registerEntryTableNames(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        Collections.addAll(entryTableNames, stringArray);
    }

    public static String[] getEntryTableNames() {
        if (entryTableNames == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return entryTableNames.toArray(new String[entryTableNames.size()]);
    }

    public static void registerMobileEntryTableNames(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        Collections.addAll(mobileEntryTableNames, stringArray);
    }

    public static String[] getMobileEntryTableNames() {
        if (mobileEntryTableNames == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return mobileEntryTableNames.toArray(new String[mobileEntryTableNames.size()]);
    }

    public static String[] getExtraEntryTableNames() {
        if (entryTableNames == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, new String[entryTableNames.size()]);
        Collections.copy(arrayList, entryTableNames);
        arrayList.remove("fr_folderentry");
        arrayList.remove("fr_fileentry");
        arrayList.remove("fr_reportletentry");
        arrayList.remove("fr_urlentry");
        arrayList.remove("fr_reportprocessentry");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static {
        entryMap.put("folder", FolderEntry.class);
        entryMap.put("report", ReportletEntry.class);
        entryMap.put("link", URLEntry.class);
        entryMap.put("processType", ReportProcessEntry.class);
        map.put(0, FolderEntryDAO.getInstance());
        map.put(2, ReportletEntryDAO.getInstance());
        map.put(1, FileEntryDAO.getInstance());
        map.put(3, URLEntryDAO.getInstance());
        map.put(8, ReportProcessEntryDAO.getInstance());
        entryTableNames.add("fr_folderentry");
        entryTableNames.add("fr_fileentry");
        entryTableNames.add("fr_reportletentry");
        entryTableNames.add("fr_urlentry");
        entryTableNames.add("fr_reportprocessentry");
        mobileEntryTableNames.add("fr_folderentry");
        mobileEntryTableNames.add("fr_reportletentry");
        mobileEntryTableNames.add("fr_urlentry");
        mobileEntryTableNames.add("fr_reportprocessentry");
    }
}

