/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.cache.EntryCacheImpl;
import com.fr.fs.cache.EntryTreeFolderNode;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CacheFileProcessor;
import com.fr.fs.control.EntryPoolFactory;
import com.fr.fs.control.UserControl;
import com.fr.fs.dao.EntryDAO;
import com.fr.fs.dao.FSDAOManager;
import com.fr.fs.dao.FolderEntryDAO;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.schedule.entry.FolderEntry;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.platform.entry.BaseEntry;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.stable.bridge.StableFactory;
import java.util.Set;

public class EntryControl {
    private static EntryControl ec;
    private Object SORT_LOCK = new Object();

    public static EntryControl getInstance() {
        if (ec == null) {
            ec = new EntryControl();
        }
        return ec;
    }

    public Entry getEntry(int n, long l) {
        return EntryCacheImpl.getInstance().getCacheEntry(n, l);
    }

    public EntryTreeFolderNode getRootNode() {
        return EntryCacheImpl.getInstance().getRootNode();
    }

    public EntryTreeFolderNode getFolderNode(long l) {
        return EntryCacheImpl.getInstance().getFolderTreeNode(l);
    }

    public boolean saveOrUpdateEntry(Entry entry) throws Exception {
        if (entry == null) {
            return false;
        }
        FSContext.setUsingFS();
        EntryDAO<? extends Entry> entryDAO = EntryPoolFactory.getEntryDAO(entry.getEntryType());
        boolean bl = entryDAO.saveOrUpdate(entry);
        if (bl) {
            try {
                EntryCacheImpl.getInstance().cache(entry);
            }
            catch (Exception exception) {
                EntryCacheImpl.getInstance().reInit();
            }
            return true;
        }
        return false;
    }

    public void checkSaveOrUpdateEntryPrivilege(BaseEntry baseEntry, long l) throws Exception {
        String string;
        FSPrivilegeTools fSPrivilegeTools = FSPrivilegeTools.getInstance();
        if (!FSConfig.getProviderInstance().getAuthorizeAttr().isEditReportAuthority() || l == UserControl.getInstance().getSuperManagerID()) {
            return;
        }
        Set set = UserControl.getInstance().getAllEntryPrivileges(l);
        if (baseEntry.getId() < 0L ? !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(0, baseEntry.getParentId())) : (ComparatorUtils.equals((String)(string = this.getEntry(baseEntry.getEntryType(), baseEntry.getId()).getDisplayName()), (String)baseEntry.getDisplayName()) || baseEntry.getParentId() < 0L ? !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(baseEntry.getEntryType(), baseEntry.getId())) : !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(0, baseEntry.getParentId())))) {
            throw new NoPrivilegeException();
        }
    }

    public boolean deleteEntry(Entry entry) throws Exception {
        if (entry == null) {
            return false;
        }
        return this.deleteEntry(entry.getEntryType(), entry.getId());
    }

    public boolean deleteEntry(int n, long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        if (this.getEntryDAO(n).deleteByID(l)) {
            try {
                if (n == 1) {
                    CacheFileProcessor cacheFileProcessor = (CacheFileProcessor)StableFactory.getMarkedInstanceObjectFromClass((String)"CacheFileProcessor", CacheFileProcessor.class);
                    if (cacheFileProcessor != null) {
                        boolean bl = cacheFileProcessor.removeFromCache(n, l);
                        if (!bl) {
                            this.removeCache(n, l);
                        }
                    } else {
                        this.removeCache(n, l);
                    }
                } else {
                    this.removeCache(n, l);
                }
            }
            catch (Exception exception) {
                EntryCacheImpl.getInstance().reInit();
            }
            return true;
        }
        return false;
    }

    private void removeCache(int n, long l) {
        EntryCacheImpl.getInstance().removeCache(n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortEntry(long l, int n, int n2) throws Exception {
        Entry entry;
        if (l > 0L && n >= 0 && (entry = EntryControl.getInstance().getEntry(n2, l)) != null) {
            Object object = this.SORT_LOCK;
            synchronized (object) {
                EntryTreeFolderNode entryTreeFolderNode = EntryControl.getInstance().getFolderNode(entry.getParentId());
                Entry[] entryArray = entryTreeFolderNode.getNodes(n2);
                n = Math.min(n, entryArray.length);
                for (int i = 0; i < entryArray.length; ++i) {
                    int n3;
                    if (entryArray[i].getId() != entry.getId()) continue;
                    for (n3 = i; n3 < entryArray.length - 1; ++n3) {
                        entryArray[n3] = entryArray[n3 + 1];
                    }
                    for (n3 = entryArray.length - 1; n3 > n; --n3) {
                        entryArray[n3] = entryArray[n3 - 1];
                    }
                    entryArray[n] = entry;
                    for (n3 = 0; n3 < entryArray.length; ++n3) {
                        entryArray[n3].setSortindex(n3 + 1);
                        if (!FSDAOManager.createSession().saveOrUpdate((Object)entryArray[n3])) continue;
                        EntryCacheImpl.getInstance().cache(entryArray[n3]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortFolderEntry(long l, int n) throws Exception {
        FolderEntry folderEntry;
        if (l > 0L && n >= 0 && (folderEntry = (FolderEntry)EntryControl.getInstance().getEntry(0, l)) != null) {
            Object object = this.SORT_LOCK;
            synchronized (object) {
                EntryTreeFolderNode entryTreeFolderNode = EntryControl.getInstance().getFolderNode(folderEntry.getParentId());
                FolderEntry[] folderEntryArray = entryTreeFolderNode.getAllShowFolderNoPVCheck();
                n = Math.min(n, folderEntryArray.length);
                for (int i = 0; i < folderEntryArray.length; ++i) {
                    int n2;
                    if (folderEntryArray[i].getId() != folderEntry.getId()) continue;
                    for (n2 = i; n2 < folderEntryArray.length - 1; ++n2) {
                        folderEntryArray[n2] = folderEntryArray[n2 + 1];
                    }
                    for (n2 = folderEntryArray.length - 1; n2 > n; --n2) {
                        folderEntryArray[n2] = folderEntryArray[n2 - 1];
                    }
                    folderEntryArray[n] = folderEntry;
                    for (n2 = 0; n2 < folderEntryArray.length; ++n2) {
                        folderEntryArray[n2].setSortindex(n2 + 1);
                        if (!FolderEntryDAO.getInstance().saveOrUpdate(folderEntryArray[n2])) continue;
                        EntryCacheImpl.getInstance().cache(folderEntryArray[n2]);
                    }
                }
            }
        }
    }

    public JSONArray getRootShowFolder(long l) throws Exception {
        if (l < 0L && l != UserControl.getInstance().getSuperManagerID()) {
            return null;
        }
        FolderEntry[] folderEntryArray = EntryCacheImpl.getInstance().getRootNode().getShowFolderEntrys(l);
        JSONArray jSONArray = new JSONArray();
        if (folderEntryArray != null) {
            for (int i = 0; i < folderEntryArray.length; ++i) {
                jSONArray.put((Object)folderEntryArray[i].createJSONConfig(true));
            }
        }
        return jSONArray;
    }

    private EntryDAO getEntryDAO(int n) {
        return EntryPoolFactory.getEntryDAO(n);
    }
}

