/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.reserve;

import com.fr.base.ExcelUtils;
import com.fr.general.DeclareRecordType;
import com.fr.io.collection.ExportCollection;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.ExcelExportType;
import com.fr.io.exporter.ExcelExporter;
import com.fr.io.exporter.LargeDataPageExcelExporter;
import com.fr.io.exporter.PageExcelExporter;
import com.fr.io.exporter.PageToSheetExcelExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.core.A.A.A;
import com.fr.report.core.A.A.C;
import com.fr.report.core.ReportUtils;
import com.fr.report.fun.ExcelExportAppProvider;
import com.fr.web.Browser;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.reserve.DefaultOperate;
import com.fr.web.core.utils.ExportUtils;
import com.fr.web.utils.WebUtils;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelOperate
extends DefaultOperate {
    @Override
    public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
    }

    @Override
    public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string, boolean bl) {
        this.setContent(httpServletRequest, httpServletResponse, string, bl);
    }

    @Override
    public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
        return this.createExcelExportCollection(httpServletRequest, httpServletResponse, reportSessionIDInfor, string);
    }

    public AppExporter createExcelExporter(HttpServletRequest httpServletRequest, ReportSessionIDInfor reportSessionIDInfor) {
        ExportCollection exportCollection = this.createExcelExportCollection(httpServletRequest, null, reportSessionIDInfor, null);
        return exportCollection == null ? new ExcelExporter(null) : exportCollection.getExporter();
    }

    public ExportCollection createExcelExportCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
        ExcelExportType excelExportType = this.createExcelExportType(httpServletRequest, reportSessionIDInfor);
        if ("ldpage".equalsIgnoreCase(excelExportType.getExportType())) {
            Set set = ExtraReportClassManager.getInstance().getArray("ExcelExportAppProvider");
            for (ExcelExportAppProvider excelExportAppProvider : set) {
                ExportCollection exportCollection;
                if (!excelExportAppProvider.exportType().equalsIgnoreCase(excelExportType.getExportType()) || (exportCollection = excelExportAppProvider.createLargeDataExportCollection(httpServletRequest, httpServletResponse, reportSessionIDInfor, string, excelExportType)) == null) continue;
                return exportCollection;
            }
            return this.createLargeDataExportCollection(httpServletRequest, httpServletResponse, reportSessionIDInfor, string, excelExportType);
        }
        if (httpServletResponse != null) {
            if (ExcelUtils.checkThirdJarSupportPOI() && !WebUtils.getHTTPRequestBoolParameter((HttpServletRequest)httpServletRequest, (String)"isExcel2003")) {
                ExportUtils.setExcel2007Content(httpServletResponse, string);
            } else {
                ExportUtils.setExcelContent(httpServletResponse, string);
            }
        }
        ExportCollection exportCollection = ExportCollection.create();
        AppExporter<Boolean> appExporter = this.createExcelExporter(exportCollection, excelExportType, reportSessionIDInfor);
        appExporter.setVersion(WebUtils.getHTTPRequestBoolParameter((HttpServletRequest)httpServletRequest, (String)"isExcel2003"));
        return exportCollection;
    }

    public ExcelExportType createExcelExportType(HttpServletRequest httpServletRequest, ReportSessionIDInfor reportSessionIDInfor) {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"extype");
        ResultWorkBook resultWorkBook = reportSessionIDInfor.getWorkBook2Show();
        boolean bl = true;
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            if (!(resultWorkBook.getReport(i2) instanceof A) && !(resultWorkBook.getReport(i2) instanceof C)) continue;
            if ("simple".equalsIgnoreCase(string)) {
                bl = false;
            }
            if ("sheet".equalsIgnoreCase(string)) break;
            string = "ldpage";
            break;
        }
        return new ExcelExportType(string, bl);
    }

    public ExportCollection createLargeDataExportCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string, ExcelExportType excelExportType) {
        Browser browser = Browser.resolve((HttpServletRequest)httpServletRequest);
        if (httpServletResponse != null) {
            ExportUtils.setZipContext(httpServletResponse, string, browser.shouldSetContentTypeOnZipDownload());
        }
        LargeDataPageExcelExporter largeDataPageExcelExporter = new LargeDataPageExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(reportSessionIDInfor.getContextBook()), excelExportType.isPage());
        ExportCollection exportCollection = ExportCollection.create();
        exportCollection.setExporter(largeDataPageExcelExporter);
        exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_EXCEL_LARGE);
        return exportCollection;
    }

    public AppExporter<Boolean> createExcelExporter(ExportCollection exportCollection, ExcelExportType excelExportType, ReportSessionIDInfor reportSessionIDInfor) {
        ExcelExporter excelExporter;
        Set set = ExtraReportClassManager.getInstance().getArray("ExcelExportAppProvider");
        for (ExcelExportAppProvider excelExportAppProvider : set) {
            if (!excelExportAppProvider.exportType().equalsIgnoreCase(excelExportType.getExportType())) continue;
            return excelExportAppProvider.createAppExporter(exportCollection, excelExportType, reportSessionIDInfor);
        }
        if ("simple".equalsIgnoreCase(excelExportType.getExportType())) {
            excelExporter = new ExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(reportSessionIDInfor.getContextBook()));
            exportCollection.setExporter(excelExporter);
            exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_EXCEL_ORIGINAL);
        } else if ("sheet".equalsIgnoreCase(excelExportType.getExportType())) {
            excelExporter = new PageToSheetExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(reportSessionIDInfor.getContextBook()));
            exportCollection.setExporter(excelExporter);
            exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_EXCEL_PAGESHEET);
        } else {
            excelExporter = new PageExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(reportSessionIDInfor.getContextBook()));
            exportCollection.setExporter(excelExporter);
            exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_EXCEL_PAGE);
        }
        return excelExporter;
    }
}

