/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess.dao;

import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.AddColumn;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.DAOManagerFactory;
import com.fr.data.dao.DataAccessObjectOperator;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.JDBCDataAccessObjectProperties;
import com.fr.web.core.db.PlatformDB;
import com.fr.web.core.process.reportprocess.dao.ProcessLogJDBCProperties;
import com.fr.web.core.process.reportprocess.dao.ProcessNodeJDBCProperties;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskImplJDBCProperties;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskJDBCProperties;
import com.fr.web.core.process.reportprocess.dao.ReportProcessJDBCProperties;
import com.fr.web.core.process.reportprocess.dao.StashDataJDBCProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ProcessDAOManager {
    public static String FR_PROCESS_TASK_IMPL = "FR_PROCESS_TASK_IMPL";
    public static String FR_REPORT_PROCESS_TASK = "FR_REPORT_PROCESS_TASK";
    private static DataAccessObjectOperator reportProcessManager = null;
    private static DataAccessObjectOperator processTaskManager = null;
    private static DataAccessObjectOperator processTaskImplManager = null;
    private static DataAccessObjectOperator processNodeManager = null;
    private static DataAccessObjectOperator alertToastManager = null;
    private static DataAccessObjectOperator remindToastManager = null;
    private static DataAccessObjectOperator processLogManager = null;
    private static DataAccessObjectOperator stashDataManager = null;

    public static DataAccessObjectSession createReportProcessSession() {
        return ProcessDAOManager.getReportProcessJDBCDAOManager().startSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataAccessObjectOperator getReportProcessJDBCDAOManager() {
        Class<ProcessDAOManager> clazz = ProcessDAOManager.class;
        synchronized (ProcessDAOManager.class) {
            if (reportProcessManager == null) {
                ReportProcessJDBCProperties reportProcessJDBCProperties = new ReportProcessJDBCProperties();
                reportProcessManager = DAOManagerFactory.createJDBCDAOManager((JDBCDataAccessObjectProperties)reportProcessJDBCProperties);
                try {
                    reportProcessManager.checkTables();
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return reportProcessManager;
        }
    }

    public static DataAccessObjectSession createProcessTaskSession() {
        return ProcessDAOManager.getProcessTaskJDBCDAOManager().startSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataAccessObjectOperator getProcessTaskJDBCDAOManager() {
        Class<ProcessDAOManager> clazz = ProcessDAOManager.class;
        synchronized (ProcessDAOManager.class) {
            if (processTaskManager == null) {
                ProcessTaskJDBCProperties processTaskJDBCProperties = new ProcessTaskJDBCProperties();
                processTaskManager = DAOManagerFactory.createJDBCDAOManager((JDBCDataAccessObjectProperties)processTaskJDBCProperties);
                try {
                    Connection connection = PlatformDB.getDB().createConnection();
                    processTaskManager.checkTables();
                    try {
                        connection.setAutoCommit(false);
                        Dialect dialect = DialectFactory.generateDialect((Connection)connection);
                        if (!ProcessDAOManager.findColumnInTable("leapfrogBack", connection, FR_REPORT_PROCESS_TASK)) {
                            ProcessDAOManager.addTableColumn(connection, dialect, new Column("leapfrogBack", 16, new ColumnSize(1)), FR_REPORT_PROCESS_TASK);
                            connection.commit();
                        }
                    }
                    finally {
                        DBUtils.closeConnection((Connection)connection);
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return processTaskManager;
        }
    }

    public static DataAccessObjectSession createProcessNodeSession() {
        return ProcessDAOManager.getProcessNodeJDBCDAOManager().startSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataAccessObjectOperator getProcessNodeJDBCDAOManager() {
        Class<ProcessDAOManager> clazz = ProcessDAOManager.class;
        synchronized (ProcessDAOManager.class) {
            if (processNodeManager == null) {
                ProcessNodeJDBCProperties processNodeJDBCProperties = new ProcessNodeJDBCProperties();
                processNodeManager = DAOManagerFactory.createJDBCDAOManager((JDBCDataAccessObjectProperties)processNodeJDBCProperties);
                try {
                    processNodeManager.checkTables();
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return processNodeManager;
        }
    }

    public static DataAccessObjectSession createProcessTaskImplSession() {
        return ProcessDAOManager.getProcessTaskImplJDBCDAOManager().startSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataAccessObjectOperator getProcessTaskImplJDBCDAOManager() {
        Class<ProcessDAOManager> clazz = ProcessDAOManager.class;
        synchronized (ProcessDAOManager.class) {
            if (processTaskImplManager == null) {
                ProcessTaskImplJDBCProperties processTaskImplJDBCProperties = new ProcessTaskImplJDBCProperties();
                processTaskImplManager = DAOManagerFactory.createJDBCDAOManager((JDBCDataAccessObjectProperties)processTaskImplJDBCProperties);
                try {
                    Connection connection = PlatformDB.getDB().createConnection();
                    processTaskImplManager.checkTables();
                    try {
                        connection.setAutoCommit(false);
                        Dialect dialect = DialectFactory.generateDialect((Connection)connection);
                        if (!ProcessDAOManager.findColumnInTable("frTaskId", connection, FR_PROCESS_TASK_IMPL)) {
                            ProcessDAOManager.addTableColumn(connection, dialect, new Column("frTaskId", -5, new ColumnSize(8)), FR_PROCESS_TASK_IMPL);
                            connection.commit();
                        }
                    }
                    finally {
                        DBUtils.closeConnection((Connection)connection);
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return processTaskImplManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTableColumn(Connection connection, Dialect dialect, Column column, String string) throws SQLException {
        Table table = new Table(string);
        AddColumn addColumn = new AddColumn(table, column, dialect);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = addColumn.createPreparedStatement(connection);
            preparedStatement.execute();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static boolean findColumnInTable(String string, Connection connection, String string2) {
        PreparedStatement preparedStatement;
        Table table = new Table(string2);
        Select select = new Select(table, DialectFactory.generateDialect((Connection)connection));
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return false;
        }
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            for (int i2 = 1; i2 <= n2; ++i2) {
                if (!string.equalsIgnoreCase(resultSetMetaData.getColumnName(i2))) continue;
                return true;
            }
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    public static DataAccessObjectSession createProcessLogSession() {
        return ProcessDAOManager.getProcessLogJDBCDAOManager().startSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataAccessObjectOperator getProcessLogJDBCDAOManager() {
        Class<ProcessDAOManager> clazz = ProcessDAOManager.class;
        synchronized (ProcessDAOManager.class) {
            if (processLogManager == null) {
                ProcessLogJDBCProperties processLogJDBCProperties = new ProcessLogJDBCProperties();
                processLogManager = DAOManagerFactory.createJDBCDAOManager((JDBCDataAccessObjectProperties)processLogJDBCProperties);
                try {
                    processLogManager.checkTables();
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return processLogManager;
        }
    }

    public static DataAccessObjectSession createStashDataSession() {
        return ProcessDAOManager.getStashDataJDBCDAOManager().startSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataAccessObjectOperator getStashDataJDBCDAOManager() {
        Class<ProcessDAOManager> clazz = ProcessDAOManager.class;
        synchronized (ProcessDAOManager.class) {
            if (stashDataManager == null) {
                StashDataJDBCProperties stashDataJDBCProperties = new StashDataJDBCProperties();
                stashDataManager = DAOManagerFactory.createJDBCDAOManager((JDBCDataAccessObjectProperties)stashDataJDBCProperties);
                try {
                    stashDataManager.checkTables();
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return stashDataManager;
        }
    }
}

