/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.button;

import com.fr.base.IconManager;
import com.fr.base.TemplateUtils;
import com.fr.form.ui.Button;
import com.fr.form.ui.ToolBarMenuButton;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.plugin.proxy.PluginProxyCompatibleUtils;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.fun.ExtensionButtonProvider;
import com.fr.report.web.button.Excel;
import com.fr.report.web.button.Image;
import com.fr.report.web.button.PDF;
import com.fr.report.web.button.Word;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Export
extends ToolBarMenuButton {
    private boolean pdfAvailable = true;
    private boolean excelPAvailable = true;
    private boolean excelOAvailable = true;
    private boolean excelSAvailable = true;
    private boolean wordAvailable = true;
    private boolean imageAvailable = true;
    private boolean htmlAvailabel = true;
    private List<ExtensionButtonProvider> parentDerectorys;
    private Map<ExtensionButtonProvider, List<ExtensionButtonProvider>> options;
    private Map<ExtensionButtonProvider, List<ExtensionButtonProvider>> selectedOptions;

    public Export() {
        super(TemplateUtils.i18nTpl((String)"Export"), IconManager.EXPORT.getName());
        this.initCompoents();
    }

    private void initCompoents() {
        Set set = ExtraReportClassManager.getInstance().getArray("ExtensionButtonProvider");
        this.initExtraParentDerectory(set);
        this.initExtraOptions(set);
        this.initExtraSelectedOptions();
    }

    private void initExtraParentDerectory(Set<ExtensionButtonProvider> set) {
        if (set != null) {
            Set set2 = PluginProxyCompatibleUtils.toOriObjectHashSet(set);
            for (ExtensionButtonProvider extensionButtonProvider : set2) {
                if (extensionButtonProvider.getParentDirectory() != null) continue;
                if (this.parentDerectorys == null) {
                    this.parentDerectorys = new ArrayList<ExtensionButtonProvider>();
                }
                this.parentDerectorys.add(extensionButtonProvider);
            }
        }
    }

    private void initExtraOptions(Set<ExtensionButtonProvider> set) {
        if (this.parentDerectorys != null) {
            for (int i2 = 0; i2 < this.parentDerectorys.size(); ++i2) {
                ExtensionButtonProvider extensionButtonProvider = this.parentDerectorys.get(i2);
                ArrayList<ExtensionButtonProvider> arrayList = new ArrayList<ExtensionButtonProvider>();
                for (ExtensionButtonProvider extensionButtonProvider2 : set) {
                    if (extensionButtonProvider2.getParentDirectory() != null && ComparatorUtils.equals((String)extensionButtonProvider.getType(), (String)extensionButtonProvider2.getParentDirectory())) {
                        arrayList.add(extensionButtonProvider2);
                    }
                    if (this.options == null) {
                        this.options = new HashMap<ExtensionButtonProvider, List<ExtensionButtonProvider>>();
                    }
                    this.options.put(extensionButtonProvider, arrayList);
                }
            }
        }
    }

    private void initExtraSelectedOptions() {
        if (this.options != null) {
            boolean bl = false;
            for (ExtensionButtonProvider extensionButtonProvider : this.options.keySet()) {
                List<ExtensionButtonProvider> list = this.options.get(extensionButtonProvider);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (!list.get(i2).isSelected()) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                if (this.selectedOptions == null) {
                    this.selectedOptions = new HashMap<ExtensionButtonProvider, List<ExtensionButtonProvider>>();
                }
                this.selectedOptions.put(extensionButtonProvider, list);
            }
        }
    }

    public boolean isPdfAvailable() {
        return this.pdfAvailable;
    }

    public void setPdfAvailable(boolean bl) {
        this.pdfAvailable = bl;
    }

    public boolean isWordAvailable() {
        return this.wordAvailable;
    }

    public void setWordAvailable(boolean bl) {
        this.wordAvailable = bl;
    }

    public boolean isExcelPAvailable() {
        return this.excelPAvailable;
    }

    public void setExcelPAvailable(boolean bl) {
        this.excelPAvailable = bl;
    }

    public boolean isExcelOAvailable() {
        return this.excelOAvailable;
    }

    public void setExcelOAvailable(boolean bl) {
        this.excelOAvailable = bl;
    }

    public boolean isExcelSAvailable() {
        return this.excelSAvailable;
    }

    public void setExcelSAvailable(boolean bl) {
        this.excelSAvailable = bl;
    }

    public boolean isExcelAvailable() {
        return this.excelPAvailable || this.excelOAvailable || this.excelSAvailable;
    }

    public void setImageAvailable(boolean bl) {
        this.imageAvailable = bl;
    }

    public boolean isImageAvailable() {
        return this.imageAvailable;
    }

    public boolean isHtmlAvailabel() {
        return this.htmlAvailabel;
    }

    public void setHtmlAvailabel(boolean bl) {
        this.htmlAvailabel = bl;
    }

    public boolean supportMobile() {
        return false;
    }

    public Button[] createMenuItems() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.pdfAvailable) {
            arrayList.add((Object)new PDF());
        }
        if (this.isExcelAvailable()) {
            arrayList.add((Object)new Excel(this.excelPAvailable, this.excelOAvailable, this.excelSAvailable));
        }
        if (this.wordAvailable) {
            arrayList.add((Object)new Word());
        }
        if (this.imageAvailable) {
            arrayList.add((Object)new Image());
        }
        if (this.selectedOptions != null) {
            for (ExtensionButtonProvider extensionButtonProvider : this.selectedOptions.keySet()) {
                Class<? extends Widget> clazz = extensionButtonProvider.classForDirectoryButton();
                try {
                    if (clazz == null) continue;
                    Button button = (Button)clazz.newInstance();
                    arrayList.add(button);
                }
                catch (InstantiationException instantiationException) {
                    FRLogger.getLogger().error(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    FRLogger.getLogger().error(illegalAccessException.getMessage());
                }
            }
        }
        return arrayList.toArray(new Button[arrayList.size()]);
    }

    private void readExtraXML(XMLableReader xMLableReader) {
        if (this.selectedOptions != null && !this.selectedOptions.isEmpty()) {
            Iterator<ExtensionButtonProvider> iterator = this.selectedOptions.keySet().iterator();
            while (iterator.hasNext()) {
                List<ExtensionButtonProvider> list = this.selectedOptions.get(iterator.next());
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    list.get(i2).readXML(xMLableReader);
                }
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        this.readExtraXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Buttons")) {
            this.setPdfAvailable(xMLableReader.getAttrAsBoolean("pdf", true));
            this.setWordAvailable(xMLableReader.getAttrAsBoolean("word", true));
            this.setExcelPAvailable(xMLableReader.getAttrAsBoolean("excelP", true));
            this.setExcelOAvailable(xMLableReader.getAttrAsBoolean("excelO", true));
            this.setExcelSAvailable(xMLableReader.getAttrAsBoolean("excelS", true));
            this.setImageAvailable(xMLableReader.getAttrAsBoolean("image", true));
            this.setHtmlAvailabel(xMLableReader.getAttrAsBoolean("html", true));
        }
    }

    public void writeExtraXML(XMLPrintWriter xMLPrintWriter) {
        if (this.selectedOptions != null && !this.selectedOptions.isEmpty()) {
            Iterator<ExtensionButtonProvider> iterator = this.selectedOptions.keySet().iterator();
            while (iterator.hasNext()) {
                List<ExtensionButtonProvider> list = this.selectedOptions.get(iterator.next());
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    list.get(i2).writeXML(xMLPrintWriter);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        this.writeExtraXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Buttons").attr("pdf", this.pdfAvailable).attr("excelP", this.excelPAvailable).attr("excelO", this.excelOAvailable).attr("excelS", this.excelSAvailable).attr("word", this.wordAvailable).attr("image", this.imageAvailable).attr("html", this.htmlAvailabel).end();
    }

    public boolean equals(Object object) {
        return object instanceof Export && super.equals(object) && ((Export)((Object)object)).excelPAvailable == this.excelPAvailable && ((Export)((Object)object)).excelOAvailable == this.excelOAvailable && ((Export)((Object)object)).excelSAvailable == this.excelSAvailable && ((Export)((Object)object)).imageAvailable == this.imageAvailable && ((Export)((Object)object)).pdfAvailable == this.pdfAvailable && ((Export)((Object)object)).wordAvailable == this.wordAvailable && ((Export)((Object)object)).htmlAvailabel == this.htmlAvailabel;
    }
}

