/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.poly;

import com.fr.base.chart.BaseChartCollection;
import com.fr.general.ComparatorUtils;
import com.fr.report.core.block.BlockSequenceExecutor;
import com.fr.report.core.block.ChartBlockExecutor;
import com.fr.report.core.sheet.SheetExecutor;
import com.fr.report.poly.BlockShiftAction;
import com.fr.report.poly.PolyWorkSheet;
import com.fr.report.poly.ResultChartBlock;
import com.fr.report.poly.TemplateBlock;
import com.fr.report.report.TemplateReport;
import com.fr.report.stable.PolyBlockAttr;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.core.PropertyChangeAdapter;
import com.fr.stable.core.PropertyChangeListener;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UnitRectangle;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PolyChartBlock
implements TemplateBlock {
    private String blockName;
    private UnitRectangle bounds;
    private BaseChartCollection cc;
    private PolyBlockAttr blockAttr;
    private List createListeners = new ArrayList();

    public PolyChartBlock() {
    }

    public PolyChartBlock(BaseChartCollection baseChartCollection) {
        this.cc = baseChartCollection;
    }

    public BaseChartCollection getChartCollection() {
        return this.cc;
    }

    public void setChartCollection(BaseChartCollection baseChartCollection) {
        this.cc = baseChartCollection;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String string) {
        this.blockName = string;
    }

    public int[] getVerticalLine() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    public int[] getHorizontalLine() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    public boolean isCells() {
        return false;
    }

    public PolyBlockAttr getBlockAttr() {
        if (this.blockAttr == null) {
            this.blockAttr = new PolyBlockAttr();
        }
        return this.blockAttr;
    }

    public void setBlockAttr(PolyBlockAttr polyBlockAttr) {
        this.blockAttr = polyBlockAttr;
    }

    public UnitRectangle getBounds() {
        return this.bounds == null ? null : new UnitRectangle(this.bounds);
    }

    public void setBounds(UnitRectangle unitRectangle) {
        this.setBounds(unitRectangle, null);
    }

    private void makeSureMoreThanZero(UnitRectangle unitRectangle) {
        if (unitRectangle.x.less_than_zero()) {
            unitRectangle.x = UNIT.ZERO;
        }
        if (unitRectangle.y.less_than_zero()) {
            unitRectangle.y = UNIT.ZERO;
        }
    }

    public void setBounds(UnitRectangle unitRectangle, PolyWorkSheet polyWorkSheet) {
        this.makeSureMoreThanZero(unitRectangle);
        new BlockShiftAction().shift(unitRectangle, polyWorkSheet, this.bounds);
        this.bounds = unitRectangle;
        this.firePropertyChange();
    }

    public SheetExecutor createExecutor(TemplateReport templateReport, Map map, BlockSequenceExecutor blockSequenceExecutor) {
        PolyChartBlock polyChartBlock;
        try {
            polyChartBlock = (PolyChartBlock)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        return new ChartBlockExecutor(templateReport, polyChartBlock, map, blockSequenceExecutor);
    }

    public void cloneWidthoutCC(ResultChartBlock resultChartBlock) throws CloneNotSupportedException {
        if (resultChartBlock == null) {
            return;
        }
        resultChartBlock.blockName = this.blockName;
        resultChartBlock.bounds = (UnitRectangle)this.bounds.clone();
        if (this.blockAttr != null) {
            resultChartBlock.blockAttr = (PolyBlockAttr)this.blockAttr.clone();
        }
    }

    public void firePropertyChange() {
        for (int i2 = this.createListeners.size() - 1; i2 >= 0; --i2) {
            ((PropertyChangeAdapter)this.createListeners.get(i2)).propertyChange();
        }
    }

    public void addPropertyListener(PropertyChangeListener propertyChangeListener) {
        int n2 = this.createListeners.indexOf(propertyChangeListener);
        if (n2 == -1) {
            this.createListeners.add(propertyChangeListener);
        } else {
            this.createListeners.set(n2, propertyChangeListener);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("PCBAttr".equals(string)) {
                this.setBlockName(xMLableReader.getAttrAsString("blockName", ""));
                this.setBounds(new UnitRectangle((UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("x", 0L)), (UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("y", 0L)), (UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("width", 0L)), (UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("height", 0L))));
            } else if (ComparatorUtils.equals((String)string, (String)"CC")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        XMLable xMLable = StableFactory.createXmlObject((String)"CC");
                        PolyChartBlock.this.setChartCollection((BaseChartCollection)xMLableReader.readXMLObject((XMLReadable)xMLable));
                    }
                });
            } else if ("PolyBlockAttr".equals(string)) {
                this.setBlockAttr(ReportXMLUtils.readXMLPolyBlockAttr(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("PCBAttr");
        if (StringUtils.isNotEmpty((String)this.blockName)) {
            xMLPrintWriter.attr("blockName", this.blockName);
        }
        if (this.bounds != null) {
            xMLPrintWriter.attr("x", this.bounds.x.toFU()).attr("y", this.bounds.y.toFU()).attr("width", this.bounds.width.toFU()).attr("height", this.bounds.height.toFU());
        }
        xMLPrintWriter.end();
        if (this.cc != null) {
            xMLPrintWriter.startTAG("CC");
            this.cc.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        ReportXMLUtils.writeXMLPloyBlockAttr(xMLPrintWriter, this.blockAttr);
    }

    public Object clone() throws CloneNotSupportedException {
        PolyChartBlock polyChartBlock = (PolyChartBlock)super.clone();
        polyChartBlock.createListeners = new ArrayList();
        if (this.bounds != null) {
            polyChartBlock.bounds = (UnitRectangle)this.bounds.clone();
        }
        if (StringUtils.isNotEmpty((String)this.blockName)) {
            polyChartBlock.blockName = this.blockName;
        }
        if (this.cc != null) {
            polyChartBlock.cc = (BaseChartCollection)this.cc.clone();
        }
        if (this.blockAttr != null) {
            polyChartBlock.blockAttr = (PolyBlockAttr)this.blockAttr.clone();
        }
        return polyChartBlock;
    }
}

