/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.core;

import com.fr.base.Style;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.report.cell.StyleProvider;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.html.Html;
import com.fr.stable.html.Tag;
import com.fr.stable.html.TextHtml;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.SynchronizedStyleList;
import java.awt.Color;

public class RichChar
implements XMLable,
StyleProvider {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "RichChar";
    private String text;
    private Style style;

    public RichChar() {
    }

    public RichChar(String string) {
        this.text = string;
        this.style = Style.DEFAULT_STYLE;
    }

    public RichChar(String string, Style style) {
        this.text = string;
        this.style = style;
    }

    public void appendText(String string) {
        this.text = new StringBuffer(this.text).append(string).toString();
    }

    public String getText() {
        return this.text;
    }

    public int getTextLength() {
        return StringUtils.getLength((String)this.text);
    }

    public void setText(String string) {
        this.text = string;
    }

    public Style getStyle() {
        return this.style;
    }

    public FRFont getFont() {
        if (this.style == null) {
            this.style = Style.DEFAULT_STYLE;
        }
        return this.style.getFRFont();
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public String toTag() {
        if (this.style == null) {
            return "";
        }
        Tag tag = new Tag("span");
        String string = this.isFormula() ? this.text : CodeUtils.htmlEncode((CharSequence)this.text);
        FRFont fRFont = this.style.getFRFont();
        TextHtml textHtml = null;
        textHtml = new TextHtml(StringUtils.isNotBlank((String)string) ? string : "");
        textHtml = this.appendStyleTags((Html)textHtml, fRFont);
        this.applyCssStyle(tag, fRFont);
        tag.sub((Html)textHtml);
        return tag.toHtml();
    }

    private void applyCssStyle(Tag tag, FRFont fRFont) {
        tag.css("font-family", fRFont.getFontName());
        tag.css("font-size", fRFont.getSize() + "px");
        Color color = fRFont.getForeground();
        if (!ComparatorUtils.equals((Object)color, (Object)Color.BLACK)) {
            tag.css("color", StableUtils.javaColorToCSSColor((Color)color));
        }
    }

    private Html appendStyleTags(Html html, FRFont fRFont) {
        if (fRFont.isBold()) {
            html = new Tag("strong").sub(html);
        }
        if (fRFont.isItalic()) {
            html = new Tag("em").sub(html);
        }
        if (fRFont.getUnderline() != 0) {
            html = new Tag("u").sub(html);
        }
        if (fRFont.isSubscript()) {
            html = new Tag("sub").sub(html);
        }
        if (fRFont.isSuperscript()) {
            html = new Tag("sup").sub(html);
        }
        return html;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void readXML(XMLableReader xMLableReader) {
        int n2 = xMLableReader.getAttrAsInt("styleIndex", 0);
        SynchronizedStyleList synchronizedStyleList = SynchronizedStyleList.getSynchronizedStyleList();
        synchronizedStyleList.put(n2, this);
        if (xMLableReader.isChildNode()) {
            this.readTextNode(xMLableReader);
        }
    }

    private void readTextNode(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                String string = xMLableReader.getTagName();
                if (ComparatorUtils.equals((String)"text", (String)string)) {
                    RichChar.this.text = xMLableReader.getElementValue();
                }
            }
        });
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        SynchronizedStyleList synchronizedStyleList = SynchronizedStyleList.getSynchronizedStyleList();
        int n2 = synchronizedStyleList.indexOfStyle(this.style);
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("styleIndex", n2);
        xMLPrintWriter.startTAG("text").textNode(this.text).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof RichChar && ComparatorUtils.equals((String)this.text, (String)((RichChar)object).getText()) && ComparatorUtils.equals((Object)this.style, (Object)((RichChar)object).getStyle());
    }

    public boolean styleEquals(Style style) {
        if (this.isFormula()) {
            return false;
        }
        return ComparatorUtils.equals((Object)style, (Object)this.style);
    }

    private boolean isFormula() {
        return StringUtils.isNotEmpty((String)this.text) && this.text.startsWith("${");
    }

    public String toString() {
        return this.toTag();
    }
}

