/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.core;

import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.PageExportCellElement;
import com.fr.report.elementcase.ElementCase;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ExcelCellIterator
implements Iterator {
    private Iterator cell_it;
    private CellElement next = null;
    private int column;
    private int row;
    private int width;
    private int height;

    public ExcelCellIterator(ElementCase elementCase, int n2, int n3, int n4, int n5) {
        this.cell_it = elementCase.intersect(n2, n3, n4, n5);
        this.column = n2;
        this.row = n3;
        this.width = n4;
        this.height = n5;
        this.findNext();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("At last element");
        }
        CellElement cellElement = this.next;
        this.findNext();
        return cellElement;
    }

    private void findNext() {
        if (this.cell_it.hasNext()) {
            CellElement cellElement = (CellElement)this.cell_it.next();
            int n2 = cellElement.getColumnSpan();
            int n3 = cellElement.getRowSpan();
            int n4 = cellElement.getColumn() - this.column;
            int n5 = cellElement.getRow() - this.row;
            if (n4 < 0) {
                n2 = n4 + n2;
                n4 = 0;
            }
            if (n5 < 0) {
                n3 = n5 + n3;
                n5 = 0;
            }
            if (n4 + n2 > this.width) {
                n2 = this.width - n4;
            }
            if (n5 + n3 > this.height) {
                n3 = this.height - n5;
            }
            this.next = new PageExportCellElement(cellElement, n4, n5, n2, n3);
            return;
        }
        this.next = null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

