/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.collection;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.general.DeclareRecordType;
import com.fr.io.exporter.AppExporter;
import com.fr.log.LogUtils;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.reserve.ExportErrorCollector;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportCollection {
    private AppExporter exporter;
    private DeclareRecordType recordType;

    public static ExportCollection create() {
        return new ExportCollection();
    }

    private ExportCollection() {
    }

    public AppExporter getExporter() {
        return this.exporter;
    }

    public void setExporter(AppExporter appExporter) {
        this.exporter = appExporter;
    }

    public DeclareRecordType getRecordType() {
        return this.recordType;
    }

    public void setRecordType(DeclareRecordType declareRecordType) {
        this.recordType = declareRecordType;
    }

    public void doExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) throws Exception {
        if (this.getRecordType() == null) {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, "Cannot recognize the specifed export format:" + string + ",\nThe correct format can be PDF,Excel,Word,SVG,CSV,Text or Image.");
            return;
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            LogUtils.exportAndLogRecord(this.exporter, (OutputStream)servletOutputStream, new ReportRepositoryDeal(httpServletRequest, reportSessionIDInfor), this.recordType);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            String string2 = String.valueOf(System.currentTimeMillis());
            ExportErrorCollector.getInstance().addError(exception, string2);
            httpServletResponse.sendRedirect(ConfigManager.getProviderInstance().getServletMapping() + "?op=export&cmd=export_error&timestamp=" + string2);
        }
        try {
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

