/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.manager;

import cn.com.infosec.netsign.base.Channel;
import cn.com.infosec.netsign.base.channels.ChannelException;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.channels.factory.ChannelFactory;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.Service;
import cn.com.infosec.netsign.jmx.MBeanManager;
import cn.com.infosec.netsign.jmx.mbeans.ServiceInfo;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.ChannelManager;
import cn.com.infosec.netsign.manager.JKSManager;

public class NetSignServerGroup {
    public static synchronized void addServer(Service service) throws ChannelException {
        ConfigManager.getService().addService(service);
        Channel channel = ChannelFactory.createServerChannel(service.getName());
        ChannelManager.registerServerChannel(channel);
        if (!ExtendedConfig.getJmxMonitorLevel().equals("none")) {
            try {
                ServiceInfo si = MBeanManager.registServiceInfoMBean(service.getName());
                si.setStartTimeL(System.currentTimeMillis());
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
                throw new ChannelException("Regist MBean for " + service.getName() + " failed");
            }
        }
        channel.startChannel();
    }

    public static synchronized void modifyServer(Service config) throws ChannelException {
        if (ConfigManager.getService().getService(config.getName()) == null) {
            throw new ChannelException("Server not exist, Server Name = " + config.getName());
        }
        ConfigManager.reload((String)"config");
        try {
            JKSManager.initJKS();
            ServerChannel channel = ChannelManager.getServerChannel(config.getName());
            if (channel == null) {
                throw new ChannelException("Channel " + config.getName() + " does not exist");
            }
            channel.reload(config.getName());
            channel.startChannel();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ChannelException(e);
        }
    }

    public static synchronized void startupServer(String name, int type) throws ChannelException {
        Channel channel = ChannelManager.getServerChannel(name);
        if (channel != null) {
            Channel sc = channel;
            if (!sc.IsStarted()) {
                Service config = ConfigManager.getService().getService(name);
                if (config == null) {
                    throw new ChannelException("Server not exist, Server Name = " + name);
                }
                if (type == 1 || type == 3) {
                    channel = ChannelFactory.createServerChannel(name);
                    ChannelManager.registerServerChannel(channel);
                }
                if (type == 2 || type == 3) {
                    channel.startChannel();
                }
            }
        } else {
            Service config = ConfigManager.getService().getService(name);
            if (config == null) {
                throw new ChannelException("Server not exist, Server Name = " + name);
            }
            if (type == 1 || type == 3) {
                channel = ChannelFactory.createServerChannel(name);
                ChannelManager.registerServerChannel(channel);
                if (!ExtendedConfig.getJmxMonitorLevel().equals("none")) {
                    try {
                        ServiceInfo si = MBeanManager.registServiceInfoMBean(config.getName());
                        si.setStartTimeL(System.currentTimeMillis());
                    }
                    catch (Exception e) {
                        ConsoleLogger.logException((Throwable)e);
                        throw new ChannelException("Regist MBean for " + config.getName() + " failed");
                    }
                }
            }
            if (type == 2 || type == 3) {
                channel.startChannel();
            }
        }
    }

    public static synchronized void stopServer(String name) throws ChannelException {
        ServiceInfo si;
        ServerChannel channel = ChannelManager.getServerChannel(name);
        if (channel == null) {
            if (ConfigManager.getService().getService(name) == null) {
                throw new ChannelException("Server not exist, Server Name = " + name);
            }
            throw new ChannelException("Server not running, Server Name = " + name);
        }
        channel.stopChannel();
        if (!ExtendedConfig.getJmxMonitorLevel().equals("none") && (si = MBeanManager.getServiceInfoMBean(name)) != null) {
            si.setStatus("stopped");
        }
    }

    public static synchronized void removeServer(String name) throws ChannelException {
        Service config = ConfigManager.getService().getService(name);
        if (config == null) {
            throw new ChannelException("Server not exist, Server ID = " + name);
        }
        ServerChannel channel = ChannelManager.removeServerChannel(name);
        if (channel != null) {
            channel.stopChannel();
        }
        ConfigManager.getService().removeService(name);
        try {
            if (!ExtendedConfig.getJmxMonitorLevel().equals("none")) {
                MBeanManager.unregistServiceInfoMBean(name);
            }
        }
        catch (Exception idEx) {
            throw new ChannelException(idEx);
        }
    }
}

