/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.manager;

import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.Key;
import cn.com.infosec.netsign.frame.config.KeyStoreConfig;
import cn.com.infosec.netsign.frame.util.JKSFile;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;

public class JKSManager {
    private static JKSFile jksFile;
    private static HashMap privateKeys;
    private static HashMap certificates;
    private static HashMap certChains;

    static {
        certChains = new HashMap();
    }

    public static void initJKS() throws Exception {
        KeyStoreConfig ksc = ConfigManager.getKeyStore();
        if (ksc != null) {
            String file = ksc.getStoreFile();
            String storePwd = ksc.getStorePwd();
            if (file == null) {
                return;
            }
            privateKeys = new HashMap();
            certificates = new HashMap();
            jksFile = new JKSFile(file, storePwd);
            Key[] keys = ksc.getKeys();
            CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
            int i = 0;
            int length = keys.length;
            while (i < length) {
                Key k = keys[i];
                if (k.getAlias() != null) {
                    X509Certificate[] x509Chain;
                    Certificate[] chain;
                    X509Certificate cert;
                    RSAPrivateKey key = jksFile.getPrivateKey(k.getAlias(), k.getPwd());
                    if (key != null) {
                        privateKeys.put(k.getAlias(), key);
                    }
                    if ((cert = jksFile.getCertificate(k.getAlias())) != null) {
                        ByteArrayInputStream in = new ByteArrayInputStream(cert.getEncoded());
                        certificates.put(k.getAlias(), cf.generateCertificate(in));
                        in.close();
                    }
                    if ((chain = jksFile.getCertChain(k.getAlias())) != null) {
                        x509Chain = new X509Certificate[chain.length];
                        int j = 0;
                        int size = chain.length;
                        while (j < size) {
                            ByteArrayInputStream in = new ByteArrayInputStream(chain[j].getEncoded());
                            x509Chain[j] = (X509Certificate)cf.generateCertificate(in);
                            in.close();
                            ++j;
                        }
                        certChains.put(k.getAlias(), x509Chain);
                    } else if (cert != null) {
                        x509Chain = new X509Certificate[]{cert};
                        certChains.put(k.getAlias(), x509Chain);
                    }
                }
                ++i;
            }
        }
    }

    public static RSAPrivateKey getPriKey(String alias) {
        return (RSAPrivateKey)privateKeys.get(alias);
    }

    public static X509Certificate getCertificate(String alias) {
        return (X509Certificate)certificates.get(alias);
    }

    public static X509Certificate[] getCertChain(String alias) {
        try {
            return (X509Certificate[])certChains.get(alias);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JKSFile getJKSFile() {
        return jksFile;
    }
}

