/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.manager;

import cn.com.infosec.netsign.manager.IdentifyException;
import java.util.ArrayList;
import java.util.Collections;

public class IdentifyManager {
    public static final int MANAGEMENT_CHANNEL_ID = 1;
    public static final int SYSTEMINFO_CHANNEL_ID = 2;
    public static final int P10REQUEST_CHANNEL_ID = 3;
    public static final int DOWNLOADCRL_CHANNEL_ID = 4;
    public static final int MIN_BUSINESS_CHANNEL_ID = 10;
    public static final String MANAGEMENT_CHANNEL = "Management Channel";
    public static final String SYSTEM_INFO_CHANNEL = "System Info Channel";
    public static final String P10_REQUEST_CHANNEL = "P10 Request Channel";
    public static final String DOWNLOAD_CRL_CHANNEL = "Download Crl Channel";
    private static ArrayList idList = new ArrayList();
    private static ArrayList dcNameList = new ArrayList();

    public static synchronized void registerId(int id) throws IdentifyException {
        if (idList.contains(new Integer(id))) {
            throw new IdentifyException("The Channel Id \"" + id + "\" has been used by other NetSign Server");
        }
        idList.add(new Integer(id));
    }

    public static synchronized void removeId(int id) throws IdentifyException {
        try {
            if (!idList.remove(new Integer(id))) {
                throw new IdentifyException("The Channel Id \"" + id + "\" do not Exist");
            }
        }
        catch (UnsupportedOperationException unsp) {
            throw new IdentifyException(unsp);
        }
    }

    public static synchronized int generateId() {
        if (idList.size() == 0) {
            return 10;
        }
        Collections.sort(idList);
        Integer currentId = (Integer)idList.get(idList.size() - 1);
        return currentId + 1;
    }

    public static synchronized void registerDCName(String name) throws IdentifyException {
        if (dcNameList.contains(name)) {
            throw new IdentifyException("The Name \"" + name + "\" has been used by other Download Crl Server");
        }
        dcNameList.add(name);
    }

    public static synchronized void removeDCName(String name) throws IdentifyException {
        try {
            if (!dcNameList.remove(name)) {
                throw new IdentifyException("The Name \"" + name + "\" do not exist");
            }
        }
        catch (UnsupportedOperationException unsp) {
            throw new IdentifyException(unsp);
        }
    }
}

