/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.listeners;

import cn.com.infosec.netsign.base.channels.BasicChannel;
import cn.com.infosec.netsign.base.channels.ChannelException;
import cn.com.infosec.netsign.listeners.AdminServerListener;
import cn.com.infosec.netsign.listeners.ServerListener;

public abstract class AbstractListener
implements Runnable {
    private static final String INVALID_CHANNEL_ID = "Channel ID Is Invalid";

    public static AbstractListener createServerListener(String name, BasicChannel channel) throws ChannelException {
        return new ServerListener(name, channel);
    }

    public static AbstractListener createAdminListener() throws ChannelException {
        return new AdminServerListener();
    }

    public abstract int countCurrentThreads();

    byte[] getRAWIP(String ip) {
        String[] ips = ip.split("\\.");
        byte[] a = new byte[ips.length];
        int i = 0;
        while (i < a.length) {
            a[i] = (byte)Integer.parseInt(ips[i]);
            ++i;
        }
        return a;
    }

    public abstract void run();

    public abstract void shutdown() throws ChannelException;

    public abstract void reload(String var1, BasicChannel var2) throws ChannelException;
}

