/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.jmx;

import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.jmx.mbeans.JVMInfo;
import cn.com.infosec.netsign.jmx.mbeans.ServiceInfo;
import cn.com.infosec.netsign.jmx.mbeans.ServiceStat;
import cn.com.infosec.netsign.jmx.mbeans.SignatureCache;
import cn.com.infosec.netsign.jmx.mbeans.TaskQueueInfoMBean;
import cn.com.infosec.netsign.jmx.mbeans.ThreadPoolStatus;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MBeanManager {
    private static MBeanServer mbs;
    private static HashMap serviceInfos;
    private static HashMap objectNames;
    private static HashMap threadPoolStatus;
    private static TaskQueueInfoMBean queue;

    static {
        serviceInfos = new HashMap();
        objectNames = new HashMap();
        threadPoolStatus = new HashMap();
    }

    public static synchronized TaskQueueInfoMBean getTaskQueueMBean() {
        if (queue == null) {
            queue = new TaskQueueInfoMBean();
        }
        return queue;
    }

    public static synchronized void initJMX() {
        if (mbs == null) {
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
    }

    public static void registJVMInfoMBean() throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (ExtendedConfig.getJmxMonitorLevel().equals("none")) {
            return;
        }
        JVMInfo info = new JVMInfo();
        ObjectName oName = new ObjectName("cn.com.infosec.netsign.jmx.mbeans:type=JVMInfo");
        mbs.registerMBean(info, oName);
    }

    public static void registSignatureCatchMBean() throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (ExtendedConfig.getJmxMonitorLevel().equals("none")) {
            return;
        }
        SignatureCache info = new SignatureCache();
        ObjectName oName = new ObjectName("cn.com.infosec.netsign.jmx.mbeans:type=SignatureCatch");
        mbs.registerMBean(info, oName);
    }

    public static ServiceInfo registServiceInfoMBean(String channelName) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (ExtendedConfig.getJmxMonitorLevel().equals("full")) {
            ServiceInfo info = (ServiceInfo)serviceInfos.get(channelName);
            if (info == null) {
                info = new ServiceInfo();
                info.setChannelName(channelName);
                ObjectName oName = new ObjectName("cn.com.infosec.netsign.jmx.mbeans:type=" + channelName);
                mbs.registerMBean(info, oName);
                serviceInfos.put(channelName, info);
                objectNames.put(channelName, oName);
            }
            return info;
        }
        return null;
    }

    public static ThreadPoolStatus registThreadPoolStatus(ThreadPoolExecutor executor, String channelName) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (ExtendedConfig.getJmxMonitorLevel().equals("full")) {
            ThreadPoolStatus status = (ThreadPoolStatus)threadPoolStatus.get(channelName);
            if (status == null) {
                status = new ThreadPoolStatus(executor, channelName);
                ObjectName oName = new ObjectName("cn.com.infosec.netsign.jmx.mbeans:type=TheadPoolStatus" + channelName);
                mbs.registerMBean(status, oName);
                threadPoolStatus.put(channelName, status);
                objectNames.put("ThreadPoolStatus" + channelName, oName);
            }
            return status;
        }
        return null;
    }

    public static ServiceInfo getServiceInfoMBean(String channelName) {
        ServiceInfo info = (ServiceInfo)serviceInfos.get(channelName);
        return info;
    }

    public static void unregistServiceInfoMBean(String channelName) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName oName;
        if (ExtendedConfig.getJmxMonitorLevel().equals("full") && (oName = (ObjectName)objectNames.get(channelName)) != null) {
            mbs.unregisterMBean(oName);
            serviceInfos.remove(channelName);
            objectNames.remove(channelName);
        }
    }

    public static void unregistThreadPoolStatusMBean(String channelName) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName oName;
        if (ExtendedConfig.getJmxMonitorLevel().equals("full") && (oName = (ObjectName)objectNames.get("ThreadPoolStatus" + channelName)) != null) {
            mbs.unregisterMBean(oName);
            threadPoolStatus.remove(channelName);
            objectNames.remove("ThreadPoolStatus" + channelName);
        }
    }

    public static ServiceStat createServiceStat(String name) {
        ServiceStat ss = new ServiceStat();
        ss.setChannelID(name);
        ss.setChannelName(name);
        return ss;
    }

    public static MBeanServer getMBeanServer() {
        return mbs;
    }
}

