/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.isfwimpl;

import cn.com.infosec.isfw2.impl.DefaultProtocolHandler;
import cn.com.infosec.isfw2.impl.ProcessorManager;
import cn.com.infosec.isfw2.sfw.FilterAdapter;
import cn.com.infosec.isfw2.sfw.ProtocolHandler;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.isfw2.sfw.SocketSession;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.PDFVerifyResult;
import cn.com.infosec.netsign.base.XMLVerifyResult;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignProtocolHandler;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.jmx.Task;
import cn.com.infosec.netsign.jmx.TaskFactory;
import cn.com.infosec.netsign.jmx.TaskQueue;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NetSignIOFilter
extends FilterAdapter {
    private ProcessorManager pm;
    private ProtocolHandler parser;
    private ServerChannel channel;
    private byte[] pwd;

    public NetSignIOFilter(ProtocolHandler parser, ProcessorManager pm, ServerChannel channel) {
        this.parser = parser;
        this.pm = pm;
        if (channel == null) {
            throw new NullPointerException("Channel is null");
        }
        this.channel = channel;
        this.pwd = channel.getService().getPasswd();
    }

    public boolean DataReceived(SocketSession s, long beginReadTimeNano) throws Exception {
        ConsoleLogger.logString((String)"Data received");
        ByteBuffer buff = s.getBuffer();
        Socket socket = s.getChannel().socket();
        String inetAddress = String.valueOf(socket.getInetAddress().getHostAddress()) + ":" + socket.getPort();
        if (this.parser == null) {
            this.parser = new DefaultProtocolHandler();
        }
        NSMessageOpt nsresp = null;
        NetSignResponse res = null;
        NetSignRequest req = (NetSignRequest)((NetSignProtocolHandler)this.parser).parseRequest(buff, System.nanoTime() - beginReadTimeNano);
        if (req == null) {
            nsresp = new NSMessageOpt();
            nsresp.setType("response");
            nsresp.setErrMsg("ProtocolHandler can not parse the request message");
            nsresp.setResult(-100004);
            res = NetSignResponse.createNetSignResponse(nsresp, req);
            this.channel.getDebugLogger().Log(String.valueOf(this.channel.getId()) + " RecieveMessage: " + nsresp.getResult());
            this.channel.getAccessLogger().Log(String.valueOf(this.channel.getId()) + " " + inetAddress + " RecieveMessage failed");
        } else {
            nsresp = this.checkPolicy(req.getNSMessage(), s.getChannel().socket());
            if (nsresp == null) {
                NetSignProcessor p = (NetSignProcessor)this.pm.getProcessor(req.getType());
                if (p != null) {
                    byte[] passwd;
                    boolean processorPolicyChecked = true;
                    if (ConfigManager.getPpConfig().getProcessorPwdPolicy(req.getType()) && this.pwd != null && ((passwd = req.getNSMessage().getAPIPasswd()) == null || !Arrays.equals(passwd, this.pwd))) {
                        nsresp = new NSMessageOpt();
                        nsresp.setType("response");
                        nsresp.setProcessor(req.getType());
                        nsresp.setResult(-100006);
                        nsresp.setErrMsg("API password verify did not passed");
                        res = NetSignResponse.createNetSignResponse(nsresp, req);
                        ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), req.getNSMessage(), nsresp);
                        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + req.getAbstractMessage().getAddress() + " " + req.getType() + ":" + -100006, this.channel.getLogLevel(), req);
                        processorPolicyChecked = false;
                    }
                    if (processorPolicyChecked) {
                        req.getNSMessage().setAddress(inetAddress);
                        p.setChannel(this.channel);
                        res = (NetSignResponse)p.process(req);
                    }
                } else {
                    nsresp = new NSMessageOpt();
                    nsresp.setType("response");
                    nsresp.setResult(-100002);
                    nsresp.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100002)) + ":" + req.getType());
                    res = NetSignResponse.createNetSignResponse(nsresp, req);
                    this.channel.getDebugLogger().Log(String.valueOf(this.channel.getId()) + " GetProcessor: " + nsresp.getResult());
                    this.channel.getAccessLogger().Log(String.valueOf(this.channel.getId()) + " " + inetAddress + " GetProcessor failed");
                }
            } else {
                res = NetSignResponse.createNetSignResponse(nsresp, req);
                this.channel.getDebugLogger().Log(String.valueOf(this.channel.getId()) + " GetProcessor: " + nsresp.getResult());
                this.channel.getAccessLogger().Log(String.valueOf(this.channel.getId()) + " " + inetAddress + " GetProcessor failed");
            }
        }
        s.setWriteStartTimeNano(System.nanoTime());
        if (ExtendedConfig.getJmxMonitorLevel().equals("full")) {
            TaskQueue queue = TaskFactory.getTaskQueue();
            Task t = null;
            String taskType = res.getAbstractMessage().getType();
            if (taskType.equals("PDFVerifyProcessor")) {
                ArrayList results = res.getNSMessageOpt().getPDFVerifyResults();
                int returnCode = 1;
                int i = 0;
                int size = results.size();
                while (i < size) {
                    PDFVerifyResult vr = (PDFVerifyResult)results.get(i);
                    if (vr.getReturnCode() < 0) {
                        returnCode = vr.getReturnCode();
                        break;
                    }
                    ++i;
                }
                t = Task.getInstance(this.channel.getId(), returnCode);
            } else if (taskType.equals("XMLAlipayVerifyProcessor") || taskType.equals("XMLSignatureVerifyProcessor") || taskType.equals("XMLSignatureAfterwardsVerifyProcessor")) {
                ArrayList results = res.getNSMessageOpt().getXmlVerifyResults();
                int returnCode = 1;
                int i = 0;
                int size = results.size();
                while (i < size) {
                    XMLVerifyResult vr = (XMLVerifyResult)results.get(i);
                    if (vr.getReturnCode() < 0) {
                        returnCode = vr.getReturnCode();
                        break;
                    }
                    ++i;
                }
                t = Task.getInstance(this.channel.getId(), returnCode);
            } else {
                t = Task.getInstance(this.channel.getId(), res.getReturnCode());
            }
            queue.addTask(t);
        }
        ByteBuffer buffRes = this.parser.encodeResponse((Response)res);
        res.clear();
        res = null;
        s.continueRead();
        s.sendData(buffRes);
        return true;
    }

    private NSMessageOpt checkPolicy(AbstractMessage req, Socket s) {
        List authList = this.channel.getAuthList();
        if (authList == null || authList.size() == 0) {
            return null;
        }
        if (this.channel.isCheckAuth()) {
            if (req.getClientId() != null) {
                if (!authList.contains(req.getClientId())) {
                    NSMessageOpt res = new NSMessageOpt();
                    res.setProcessor(req.getProcessor());
                    res.setType("response");
                    res.setResult(-100001);
                    res.setErrMsg(ErrorInfoRes.getErrorInfo(-100001));
                    return res;
                }
            } else {
                String inetAddress = s.getInetAddress().getHostAddress();
                String localAddress = s.getLocalAddress().getHostAddress();
                if (!localAddress.equals(inetAddress) && !authList.contains(inetAddress)) {
                    NSMessageOpt res = new NSMessageOpt();
                    res.setProcessor(req.getProcessor());
                    res.setType("response");
                    res.setResult(-100001);
                    res.setErrMsg(ErrorInfoRes.getErrorInfo(-100001));
                    return res;
                }
            }
        }
        return null;
    }

    public boolean SessionException(SocketSession s, Throwable tr) {
        if (!(tr instanceof NullPointerException)) {
            ConsoleLogger.logException((Throwable)tr);
        }
        if (s != null) {
            s.close();
        }
        return true;
    }
}

