/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.communication.multiple;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.communication.multiple.Rotator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ObjectRotator
implements Rotator {
    public void write(AbstractMessage msg, DataOutputStream out) throws IOException {
        byte[] bytes = null;
        long now = System.currentTimeMillis();
        ByteArrayOutputStream outByte = new ByteArrayOutputStream();
        ObjectOutputStream outObject = new ObjectOutputStream(outByte);
        try {
            outObject.writeObject(msg);
            outObject.flush();
            bytes = outByte.toByteArray();
        }
        finally {
            outObject.close();
        }
        out.writeByte(0);
        out.flush();
        out.writeInt(bytes.length);
        out.flush();
        out.write(bytes);
        out.flush();
    }

    public AbstractMessage read(DataInputStream in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        byte[] allData = new byte[len];
        byte[] data = null;
        int rlen = len;
        data = rlen > 10240 ? new byte[10240] : new byte[rlen];
        while (rlen > 0) {
            int ilen = in.read(data);
            System.arraycopy(data, 0, allData, len - rlen, ilen);
            rlen -= ilen;
        }
        long recvtime = System.currentTimeMillis();
        ObjectInputStream inObject = new ObjectInputStream(new ByteArrayInputStream(allData));
        AbstractMessage message = null;
        try {
            message = (AbstractMessage)inObject.readObject();
            message.setSize(len + 5);
        }
        finally {
            inObject.close();
        }
        allData = null;
        data = null;
        return message;
    }
}

