/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.bccms.InfosecCMSSignedData;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.base.util.PKCS7SignedDataFX;
import cn.com.infosec.netsign.crypto.util.PKCS7EnvelopedData;
import cn.com.infosec.netsign.crypto.weekalg.AlgorithmParamter;
import cn.com.infosec.netsign.crypto.weekalg.WeekAlgorithmException;
import cn.com.infosec.netsign.crypto.weekalg.WeekAlgorithmList;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.oscca.OID;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class WeekAlgorithmUtil {
    public static void isWeekAlg4Verify(PKCS7SignedDataFX p7b) throws WeekAlgorithmException {
        if (ExtendedConfig.isCheckWeekAlg()) {
            X509Certificate cert = p7b.getSigningCertificate();
            AlgorithmParamter ap = new AlgorithmParamter();
            PublicKey pubk = cert.getPublicKey();
            if (pubk instanceof RSAPublicKey) {
                ap.setName("RSA Verify");
                ap.setKeySize(((RSAPublicKey)pubk).getModulus().bitLength());
                ap.setMode("verify");
                WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
            }
            if (pubk instanceof SM2PublicKey || pubk instanceof JCESM2PublicKey) {
                ap.setName("SM2 Verify");
                ap.setKeySize(256);
                ap.setMode("verify");
                WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
            }
            String digestAlg = p7b.getDigAlg();
            ap.setName(digestAlg);
            WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
        }
    }

    public static void isWeekAlg4Verify(InfosecCMSSignedData p7b) throws WeekAlgorithmException {
        if (ExtendedConfig.isCheckWeekAlg()) {
            X509Certificate cert = p7b.getSignCert();
            AlgorithmParamter ap = new AlgorithmParamter();
            PublicKey pubk = cert.getPublicKey();
            if (pubk instanceof RSAPublicKey) {
                ap.setName("RSA Verify");
                ap.setKeySize(((RSAPublicKey)pubk).getModulus().bitLength());
                ap.setMode("verify");
                WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
            }
            if (pubk instanceof SM2PublicKey || pubk instanceof JCESM2PublicKey) {
                ap.setName("SM2 Verify");
                ap.setKeySize(256);
                ap.setMode("verify");
                WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
            }
            String digestAlg = WeekAlgorithmUtil.getDigestAlgNameByOID(p7b.getDigestAlg());
            ap.setName(digestAlg);
            WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
        }
    }

    public static void isWeekAlg4Verify(PublicKey pubk, String digestAlg) throws WeekAlgorithmException {
        if (ExtendedConfig.isCheckWeekAlg()) {
            AlgorithmParamter ap = new AlgorithmParamter();
            if (pubk instanceof RSAPublicKey) {
                ap.setName("RSA Verify");
                ap.setKeySize(((RSAPublicKey)pubk).getModulus().bitLength());
                ap.setMode("verify");
                WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
            }
            if (pubk instanceof SM2PublicKey || pubk instanceof JCESM2PublicKey) {
                ap.setName("SM2 Verify");
                ap.setKeySize(256);
                ap.setMode("verify");
                WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
            }
            ap.setName(digestAlg);
            WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
        }
    }

    public static void isWeekAlg4Sign(PrivateKey prik, String digestAlg) throws WeekAlgorithmException {
        if (ExtendedConfig.isCheckWeekAlg()) {
            AlgorithmParamter ap = new AlgorithmParamter();
            ap.setMode("sign");
            if (prik instanceof RSAPrivateKey) {
                ap.setName("RSA Sign");
                ap.setKeySize(((RSAPrivateKey)prik).getModulus().bitLength());
                WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
            }
            ap.setName(digestAlg.toUpperCase());
            WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
        }
    }

    public static void isWeekAlg4Decrypt(PrivateKey prik, PKCS7EnvelopedData p7b) throws WeekAlgorithmException {
        if (ExtendedConfig.isCheckWeekAlg()) {
            AlgorithmParamter ap = new AlgorithmParamter();
            ap.setMode("decrypt");
            if (prik instanceof RSAPrivateKey) {
                ap.setName("RSA Decrypt");
                ap.setKeySize(((RSAPrivateKey)prik).getModulus().bitLength());
                WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
            }
            ap.setName(p7b.getEncAlg());
            WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
        }
    }

    public static void isWeekAlg4Encrypt(PublicKey pubk, String encAlg) throws WeekAlgorithmException {
        if (ExtendedConfig.isCheckWeekAlg()) {
            AlgorithmParamter ap = new AlgorithmParamter();
            ap.setMode("encrypt");
            if (pubk instanceof RSAPublicKey) {
                ap.setName("RSA Encrypt");
                ap.setKeySize(((RSAPublicKey)pubk).getModulus().bitLength());
                WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
            }
            ap.setName(encAlg.toUpperCase());
            WeekAlgorithmList.isWeek((AlgorithmParamter)ap);
        }
    }

    private static String getDigestAlgNameByOID(String oid) {
        String digAlgTmp = OID.getAlgrithmNameByOid((String)oid);
        if (digAlgTmp != null) {
            return digAlgTmp;
        }
        return PKCS7SignedDataFX.getAlgName(oid);
    }
}

