/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.netsign.base.channels.ChannelException;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.crypto.cryptodevice.CryptoDevice;
import cn.com.infosec.netsign.crypto.cryptodevice.CryptoDeviceFactory;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.Key;
import cn.com.infosec.netsign.frame.util.CertificateUtil;
import cn.com.infosec.netsign.frame.util.PrivateKeyUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.JKSManager;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import cn.com.infosec.swxa.SWXAUtil;
import com.sansec.jce.provider.SwxaProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Hashtable;

public class ServerKeyStore
implements Serializable {
    private static final long serialVersionUID = 5448645554507725029L;
    private String mode;
    private String type;
    private String certDN;
    private String X500CertDN;
    private String issuerDN;
    private String serialNumber;
    private String notBefore;
    private String notAfter;
    private X509Certificate[] certChain;
    private X509Certificate cert;
    private DERObject[] certChainEncoded;
    private Hashtable isAndsns = new Hashtable();
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private byte[] label;
    private static SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ServerKeyStore(Key key, String provider) throws ChannelException {
        this.type = key.getKeytype();
        this.mode = key.getMode();
        if (this.mode.equals("soft")) {
            this.initRSAKey(key, provider);
        } else if (this.mode.equals("hard.sm2")) {
            this.initSM2Key(key);
        } else if (this.mode.equals("hard.store")) {
            this.initHardStoreKey(key);
        }
    }

    private void initHardStoreKey(Key key) throws ChannelException {
        ConsoleLogger.logString((String)("init hard store key:" + key.getAlias() + " " + key.getKeylable()));
        CryptoDevice cd = CryptoDeviceFactory.getCryptoDevice((String)ExtendedConfig.getHardKeyStoreDevice());
        try {
            if (key.getCert() != null) {
                this.cert = CertificateUtil.generateCertificate((byte[])key.getCert().getBytes());
                this.certDN = this.cert.getSubjectDN().getName();
                this.X500CertDN = this.cert.getSubjectX500Principal().getName();
                this.issuerDN = this.cert.getIssuerDN().getName();
                this.serialNumber = this.cert.getSerialNumber().toString(16).toUpperCase();
                this.notBefore = dformat.format(this.cert.getNotBefore());
                this.notAfter = dformat.format(this.cert.getNotAfter());
                this.certChain = new X509Certificate[]{this.cert};
                ASN1InputStream asn1In = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.certChain[0].getEncoded()));
                this.certChainEncoded = new DERObject[]{asn1In.readObject()};
                IssuerAndSerialNumber isAndsn = new IssuerAndSerialNumber((X509Name)((X509Principal)this.cert.getIssuerDN()), new DERInteger(this.cert.getSerialNumber()));
                this.isAndsns.put(String.valueOf(this.certChain[0].getIssuerDN().getName()) + this.certChain[0].getSerialNumber().toString(10), isAndsn);
            }
            int keyindex = Integer.parseInt(key.getKeylable().split(":")[1]);
            KeyPair kp = cd.exportKeyPair(keyindex, key.getKeytype());
            if (key.getKeytype().equals("SM2")) {
                this.privateKey = new SM2PrivateKey(((JCESM2PrivateKey)kp.getPrivate()).getD());
                this.publicKey = new SM2PublicKey(kp.getPublic().getEncoded());
                this.cert = new SM2Certificate((InputStream)new ByteArrayInputStream(this.cert.getEncoded()));
                this.certChain = new X509Certificate[]{this.cert};
            } else {
                this.privateKey = kp.getPrivate();
                this.publicKey = kp.getPublic();
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ChannelException(e);
        }
    }

    private void initSM2Key(Key key) throws ChannelException {
        try {
            byte[] certbs = Base64.decode((String)key.getCert());
            this.cert = new SM2Certificate((InputStream)new ByteArrayInputStream(certbs));
            this.certDN = this.cert.getSubjectDN().getName();
            this.X500CertDN = this.cert.getSubjectX500Principal().getName();
            this.issuerDN = this.cert.getIssuerDN().getName();
            this.serialNumber = this.cert.getSerialNumber().toString(16).toUpperCase();
            this.notBefore = dformat.format(this.cert.getNotBefore());
            this.notAfter = dformat.format(this.cert.getNotAfter());
            this.certChain = new X509Certificate[]{this.cert};
            ASN1InputStream asn1In = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.certChain[0].getEncoded()));
            this.certChainEncoded = new DERObject[]{asn1In.readObject()};
            IssuerAndSerialNumber isAndsn = new IssuerAndSerialNumber((X509Name)((X509Principal)this.cert.getIssuerDN()), new DERInteger(this.cert.getSerialNumber()));
            this.isAndsns.put(String.valueOf(this.certChain[0].getIssuerDN().getName()) + this.certChain[0].getSerialNumber().toString(10), isAndsn);
            if (key.getPrikey() != null) {
                this.privateKey = new SM2PrivateKey(PrivateKeyUtil.decryptPrivateKey((String)key.getPrikey(), (String)key.getAlias()));
            }
            this.publicKey = this.cert.getPublicKey();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ChannelException(e);
        }
    }

    private void initRSAKey(Key key, String provider) throws ChannelException {
        boolean isUseHsmConfig = "jce:SwxaJCE".equals(ExtendedConfig.getPrivateKeyAlg()) && ExtendedConfig.isUsehardkeystore();
        boolean isUseHsm = false;
        if (key.getPrivateKeyAlg() != null) {
            isUseHsm = true;
        }
        try {
            this.cert = !isUseHsm ? JKSManager.getCertificate(key.getAlias()) : SWXAUtil.getCertificate((String)key.getKeylable());
            if (this.cert == null) {
                throw new ChannelException("No Certificate found: " + key.getAlias());
            }
            this.certDN = this.cert.getSubjectDN().getName();
            this.X500CertDN = this.cert.getSubjectX500Principal().getName();
            this.issuerDN = this.cert.getIssuerDN().getName();
            this.serialNumber = this.cert.getSerialNumber().toString(16).toUpperCase();
            this.notBefore = dformat.format(this.cert.getNotBefore());
            this.notAfter = dformat.format(this.cert.getNotAfter());
            this.certChain = JKSManager.getCertChain(key.getAlias());
            if (this.certChain == null || this.certChain.length == 0) {
                this.certChain = new X509Certificate[]{this.cert};
            }
            this.certChainEncoded = new DERObject[this.certChain.length];
            int i = 0;
            int length = this.certChain.length;
            while (i < length) {
                ASN1InputStream asn1In = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.certChain[i].getEncoded()));
                this.certChainEncoded[i] = asn1In.readObject();
                IssuerAndSerialNumber isAndsn = new IssuerAndSerialNumber((X509Name)((X509Principal)this.cert.getIssuerDN()), new DERInteger(this.cert.getSerialNumber()));
                this.isAndsns.put(String.valueOf(this.certChain[i].getIssuerDN().getName()) + this.certChain[i].getSerialNumber().toString(10), isAndsn);
                ++i;
            }
            if (isUseHsm) {
                if (!isUseHsmConfig) {
                    return;
                }
                Security.insertProviderAt((Provider)new SwxaProvider(), 100);
                KeyPair kp = SWXAUtil.getHsmKeyPair((String)key.getKeylable(), (String)"SwxaJCE");
                this.privateKey = kp.getPrivate();
                this.publicKey = this.cert.getPublicKey();
            } else if (provider.equals("DatechCrypto")) {
                KeyPair kr = NetSignImpl.generateDatechKeyPair(key.getKeylable());
                this.privateKey = kr.getPrivate();
                this.publicKey = kr.getPublic();
            } else {
                if (key.getMode().equals("soft")) {
                    this.privateKey = JKSManager.getPriKey(key.getAlias());
                }
                this.publicKey = this.cert.getPublicKey();
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ChannelException(e);
        }
    }

    public String getX500CertDN() {
        return this.X500CertDN;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public String getType() {
        return this.type;
    }

    public String getCertDN() {
        return this.certDN;
    }

    public X509Certificate[] getCertChain() {
        return this.certChain;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getLabel() {
        return this.label;
    }

    public Hashtable getIsAndsns() {
        return this.isAndsns;
    }

    public DERObject[] getCertChainEncoded() {
        return this.certChainEncoded;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(String notBefore) {
        this.notBefore = notBefore;
    }

    public String getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(String notAfter) {
        this.notAfter = notAfter;
    }
}

