/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERConstructedSet;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.X509CertificateObjectFX;
import cn.com.infosec.jce.provider.fastparser.DerUtil;
import cn.com.infosec.jce.provider.fastparser.FastPkcs7;
import cn.com.infosec.jce.provider.fastparser.Item;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.base.util.VerifySignatureException;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.OID;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class PKCS7SignedDataFX
implements PKCSObjectIdentifiers {
    int version;
    int signerversion;
    Set digestalgos;
    ArrayList certs;
    ArrayList crls;
    X509Certificate signCert;
    byte[] bsCert;
    byte[] digest;
    byte[] contentData;
    String digestAlgorithm;
    String digestEncryptionAlgorithm;
    Signature sig;
    String digAlg;
    String signAlg;
    transient PrivateKey privKey;
    boolean verified = false;
    byte[] signCertTBS;
    DERObject[] certsEncoded;
    Hashtable isAndsns;
    final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    static final String ID_MD5 = "1.2.840.113549.2.5";
    static final String ID_MD2 = "1.2.840.113549.2.2";
    static final String ID_SHA1 = "1.3.14.3.2.26";
    static final String ID_RSA = "1.2.840.113549.1.1.1";
    static final String ID_DSA = "1.2.840.10040.4.1";
    static final String ID_SHA224 = "2.16.840.1.101.3.4.2.4";
    static final String ID_SHA256 = "2.16.840.1.101.3.4.2.1";
    static final String ID_SHA384 = "2.16.840.1.101.3.4.2.2";
    static final String ID_SHA512 = "2.16.840.1.101.3.4.2.3";
    static final String ID_RC4 = "1.2.840.113549.3.4";
    static final String ID_DES = "1.3.14.3.2.7";
    static final String ID_DESEDE = "1.2.840.113549.3.7";
    static final String ID_RC2 = "1.2.840.113549.3.2";
    static final String ID_AES = "2.16.840.1.101.3.4.2";
    static final int MD5 = 1;
    static final int MD2 = 2;
    static final int SHA1 = 3;
    static final int RSA = 4;
    static final int DSA = 5;
    static final int SHA224 = 6;
    static final int SHA256 = 7;
    static final int SHA384 = 8;
    static final int SHA512 = 9;
    static final int RC4 = 10;
    static final int DES = 11;
    static final int DESEDE = 12;
    static final int RC2 = 13;
    static final int AES = 14;
    static String[] algArray = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "DESEDE", "RC2", "AES"};
    static String[] algArray2 = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "3DES", "RC2", "AES"};
    static HashMap algmap = null;
    byte[] bsPKCS7 = null;
    FastPkcs7 fxPKCS7 = null;
    String provider = "";

    static {
        algmap = new HashMap();
        algmap.put(ID_MD5, "MD5");
        algmap.put(ID_MD2, "MD2");
        algmap.put(ID_SHA1, "SHA1");
        algmap.put(ID_RSA, "RSA");
        algmap.put(ID_DSA, "DSA");
        algmap.put(ID_SHA224, "SHA224");
        algmap.put(ID_SHA256, "SHA256");
        algmap.put(ID_SHA384, "SHA384");
        algmap.put(ID_SHA512, "SHA512");
        algmap.put(ID_RC4, "RC4");
        algmap.put(ID_DES, "DES");
        algmap.put(ID_DESEDE, "DESEDE");
        algmap.put(ID_RC2, "RC2");
        algmap.put(ID_AES, "AES");
    }

    public PKCS7SignedDataFX() {
    }

    public PKCS7SignedDataFX(byte[] in, String digestAlg) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        this(in, "INFOSEC", digestAlg, null);
    }

    public PKCS7SignedDataFX(byte[] in, String provider, String digestAlg) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        this(in, provider, digestAlg, null);
    }

    public PKCS7SignedDataFX(byte[] in, String provider, String digestAlg, String standard) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        if ("PBC Shanghai local clearing".equals(standard)) {
            this.initFXLC(in, provider, digestAlg);
        } else {
            this.init(in, provider, digestAlg);
        }
    }

    private void initFXLC(byte[] in, String provider, String digestAlg) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        this.fxPKCS7 = new FastPkcs7();
        this.fxPKCS7.pkcs7SignedData(in);
        this.provider = provider;
        this.bsPKCS7 = in;
        Item signCertItem = this.fxPKCS7.getSignCert();
        this.bsCert = DerUtil.getItemDataAndTag((byte[])this.bsPKCS7, (Item)signCertItem);
        this.signCert = new X509CertificateObjectFX(this.bsCert);
        this.signCertTBS = this.signCert.getTBSCertificate();
        ArrayList ilst = this.fxPKCS7.getCerts();
        this.certs = new ArrayList();
        int i = 0;
        int length = ilst.size();
        while (i < length) {
            Item item = (Item)ilst.get(i);
            this.addCertChain(in, item);
            ++i;
        }
        ArrayList daAl = this.fxPKCS7.getDigestAlgorithms();
        this.digestalgos = new HashSet();
        int i2 = 0;
        while (i2 < daAl.size()) {
            Item daItem = (Item)daAl.get(i2);
            byte[] ds = DerUtil.getItemDataAndTag((byte[])this.bsPKCS7, (Item)daItem);
            ASN1InputStream a = new ASN1InputStream(ds);
            ASN1Sequence asn = null;
            try {
                DERObject obj = a.readObject();
                asn = (ASN1Sequence)obj;
            }
            catch (IOException e) {
                ConsoleLogger.logException((Throwable)e);
            }
            DERObjectIdentifier o = (DERObjectIdentifier)asn.getObjectAt(0);
            this.digestalgos.add(o.getId());
            ++i2;
        }
        this.version = this.fxPKCS7.getVersion();
        this.signerversion = this.fxPKCS7.getSignInfoVersion();
        Item rawDataItem = this.fxPKCS7.getRawData();
        this.contentData = DerUtil.getItemData((byte[])this.bsPKCS7, (Item)rawDataItem);
        Item digestItem = this.fxPKCS7.getDigest();
        this.digest = DerUtil.getItemData((byte[])this.bsPKCS7, (Item)digestItem);
        this.digestAlgorithm = this.fxPKCS7.getDigestAlgorithm();
        this.digestEncryptionAlgorithm = this.fxPKCS7.getDigestEncryptionAlgorithm();
        String sigAlgTmp = this.getSignautreAlgorithm();
        if (digestAlg != null && !sigAlgTmp.startsWith(digestAlg)) {
            throw new SecurityException("The digest algoritm is not match, " + sigAlgTmp + " " + digestAlg);
        }
        if (!(this.digestEncryptionAlgorithm.startsWith("1.2.156.10197.1.301") || this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.301") || this.digestEncryptionAlgorithm.startsWith("1.2.156.10197.1.501") || this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.501"))) {
            this.sig = Signature.getInstance(sigAlgTmp, provider);
            this.sig.initVerify(this.signCert.getPublicKey());
        } else {
            if (!(sigAlgTmp.startsWith("SM3") || sigAlgTmp.startsWith("SHA1") || sigAlgTmp.startsWith("SHA256"))) {
                throw new NoSuchAlgorithmException(String.valueOf(sigAlgTmp) + " not be supported");
            }
            this.digest = DERUtil.generateDERCode((int)48, (byte[])this.digest);
        }
    }

    private void init(byte[] in, String provider, String digestAlg) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        this.fxPKCS7 = new FastPkcs7();
        this.fxPKCS7.pkcs7SignedData(in);
        this.provider = provider;
        this.bsPKCS7 = in;
        Item signCertItem = this.fxPKCS7.getSignCert();
        this.bsCert = DerUtil.getItemDataAndTag((byte[])this.bsPKCS7, (Item)signCertItem);
        this.signCert = new X509CertificateObjectFX(this.bsCert);
        this.signCertTBS = this.signCert.getTBSCertificate();
        ArrayList ilst = this.fxPKCS7.getCerts();
        this.certs = new ArrayList();
        int i = 0;
        int length = ilst.size();
        while (i < length) {
            Item item = (Item)ilst.get(i);
            this.addCertChain(in, item);
            ++i;
        }
        ArrayList daAl = this.fxPKCS7.getDigestAlgorithms();
        this.digestalgos = new HashSet();
        int i2 = 0;
        while (i2 < daAl.size()) {
            Item daItem = (Item)daAl.get(i2);
            byte[] ds = DerUtil.getItemDataAndTag((byte[])this.bsPKCS7, (Item)daItem);
            ASN1InputStream a = new ASN1InputStream(ds);
            ASN1Sequence asn = null;
            try {
                DERObject obj = a.readObject();
                asn = (ASN1Sequence)obj;
            }
            catch (IOException e) {
                ConsoleLogger.logException((Throwable)e);
            }
            DERObjectIdentifier o = (DERObjectIdentifier)asn.getObjectAt(0);
            this.digestalgos.add(o.getId());
            ++i2;
        }
        this.version = this.fxPKCS7.getVersion();
        this.signerversion = this.fxPKCS7.getSignInfoVersion();
        Item rawDataItem = this.fxPKCS7.getRawData();
        this.contentData = DerUtil.getItemData((byte[])this.bsPKCS7, (Item)rawDataItem);
        Item digestItem = this.fxPKCS7.getDigest();
        this.digest = DerUtil.getItemData((byte[])this.bsPKCS7, (Item)digestItem);
        this.digestAlgorithm = this.fxPKCS7.getDigestAlgorithm();
        this.digestEncryptionAlgorithm = this.fxPKCS7.getDigestEncryptionAlgorithm();
        String sigAlgTmp = this.getSignautreAlgorithm();
        if (digestAlg != null && !sigAlgTmp.startsWith(digestAlg)) {
            throw new SecurityException("The digest algoritm is not match, " + sigAlgTmp + " " + digestAlg);
        }
        if (!(this.digestEncryptionAlgorithm.startsWith("1.2.156.10197.1.301") || this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.301") || this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.501") || this.digestEncryptionAlgorithm.startsWith("1.2.156.10197.1.501"))) {
            this.sig = Signature.getInstance(sigAlgTmp, provider);
            this.sig.initVerify(this.signCert.getPublicKey());
        } else if (!(sigAlgTmp.startsWith("SM3") || sigAlgTmp.startsWith("SHA1") || sigAlgTmp.startsWith("SHA256"))) {
            throw new NoSuchAlgorithmException(String.valueOf(sigAlgTmp) + " not be supported");
        }
    }

    private void addCertChain(byte[] in, Item i) {
        try {
            byte[] bs = DerUtil.getItemDataAndTag((byte[])in, (Item)i);
            ConsoleLogger.saveBinary((String)"/opt/infosec/NetSignServer52/patch/a.cer", (byte[])bs);
            ByteArrayInputStream bai = new ByteArrayInputStream(bs);
            X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X509FX", "INFOSEC").generateCertificate(bai);
            this.certs.add(cert);
            bai.close();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
    }

    public PKCS7SignedDataFX(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, hashAlgorithm, "INFOSEC");
    }

    public PKCS7SignedDataFX(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, null, hashAlgorithm, provider);
    }

    public PKCS7SignedDataFX(PrivateKey privKey, Certificate[] certChain, CRL[] crlList, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.privKey = privKey;
        try {
            this.digestAlgorithm = AlgorithmUtil.getDigestAlgByName((String)hashAlgorithm).getOId();
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + hashAlgorithm);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        int i = 0;
        while (i < certChain.length) {
            this.certs.add(certChain[i]);
            ++i;
        }
        if (crlList != null) {
            i = 0;
            while (i < crlList.length) {
                this.crls.add(crlList[i]);
                ++i;
            }
        }
        this.digestEncryptionAlgorithm = privKey.getAlgorithm();
        if (this.digestEncryptionAlgorithm.equals("RSA")) {
            this.digestEncryptionAlgorithm = ID_RSA;
        } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
            this.digestEncryptionAlgorithm = ID_DSA;
        } else {
            throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
        }
        this.sig = Signature.getInstance(this.getSignautreAlgorithm(), provider);
        this.sig.initSign(privKey);
    }

    public static String getAlgName(String oid) {
        String name = null;
        if (algmap.containsKey(oid)) {
            name = algmap.get(oid).toString();
        }
        return name;
    }

    private static String getAlgName(int alg) {
        String name = null;
        name = algArray[alg - 1];
        return name;
    }

    private static int getAlgID(String alg) {
        int id = 0;
        int i = 0;
        int loop = algArray2.length;
        if (i < loop && alg.equalsIgnoreCase(algArray2[i])) {
            id = i + 1;
        }
        return id;
    }

    public String getSignautreAlgorithm() {
        this.digAlg = this.digestAlgorithm;
        this.signAlg = this.digestEncryptionAlgorithm;
        DigestAlgorithm da = AlgorithmUtil.getDigestAlgByOId((String)this.digestAlgorithm);
        if (da != null) {
            this.digAlg = da.getName();
        }
        if (this.digestEncryptionAlgorithm.equals(ID_RSA)) {
            this.signAlg = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals(ID_DSA)) {
            this.signAlg = "DSA";
        } else if (this.digestEncryptionAlgorithm.equals("1.2.156.197.1.301") || this.digestEncryptionAlgorithm.equals("1.2.156.197.1.301.1") || this.digestEncryptionAlgorithm.equals("1.2.156.10197.1.301") || this.digestEncryptionAlgorithm.equals("1.2.156.10197.1.301.1") || this.digestEncryptionAlgorithm.equals("1.2.156.197.1.501") || this.digestEncryptionAlgorithm.equals("1.2.156.10197.1.501")) {
            this.signAlg = "SM2";
        }
        return String.valueOf(this.digAlg) + "with" + this.signAlg;
    }

    public void reset() {
        try {
            if (this.privKey == null) {
                this.sig.initVerify(this.signCert.getPublicKey());
            } else {
                this.sig.initSign(this.privKey);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[0]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public byte[] getSignCertTBS() {
        return this.signCertTBS;
    }

    public void update(byte buf) throws SignatureException {
        if (this.sig != null) {
            this.sig.update(buf);
        }
    }

    public void update(byte[] buf, int off, int len) throws SignatureException {
        if (this.sig != null) {
            this.sig.update(buf, off, len);
        } else {
            this.contentData = new byte[len];
            System.arraycopy(buf, off, this.contentData, 0, len);
        }
    }

    public boolean verify() throws VerifySignatureException, NoSuchProviderException {
        if (!(this.digestEncryptionAlgorithm.startsWith("1.2.156.10197.1.301") || this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.301") || this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.501") || this.digestEncryptionAlgorithm.startsWith("1.2.156.10197.1.501"))) {
            try {
                return this.sig.verify(this.digest);
            }
            catch (Exception e) {
                throw new VerifySignatureException(e);
            }
        }
        SM2Certificate sm2Cert = new SM2Certificate(this.signCert, this.bsCert, this.signCertTBS);
        String digestName = OID.getAlgrithmNameByOid((String)this.digestAlgorithm);
        try {
            return SDFJNI.SM2VierifyWithExternalKey((byte[])this.contentData, (String)digestName, (byte[])this.digest, (SM2PublicKey)((SM2PublicKey)sm2Cert.getPublicKey()), (byte[])Utils.getOSCCApucID(2, null));
        }
        catch (NoSuchAlgorithmException e) {
            ConsoleLogger.logException((Throwable)e);
            return false;
        }
        catch (CryptoException e) {
            ConsoleLogger.logException((Throwable)e);
            return false;
        }
    }

    public boolean verify(byte[] id) throws VerifySignatureException, NoSuchProviderException {
        if (!this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.301")) {
            try {
                return this.sig.verify(this.digest);
            }
            catch (Exception e) {
                throw new VerifySignatureException(e);
            }
        }
        SM2Certificate sm2Cert = new SM2Certificate(this.signCert, this.bsCert, this.signCertTBS);
        String digestName = OID.getAlgrithmNameByOid((String)this.digestAlgorithm);
        try {
            return SDFJNI.SM2VierifyWithExternalKey((byte[])this.contentData, (String)digestName, (byte[])this.digest, (SM2PublicKey)((SM2PublicKey)sm2Cert.getPublicKey()), (byte[])id);
        }
        catch (NoSuchAlgorithmException e) {
            ConsoleLogger.logException((Throwable)e);
            return false;
        }
        catch (CryptoException e) {
            ConsoleLogger.logException((Throwable)e);
            return false;
        }
    }

    private DERObject getIssuer(byte[] enc) {
        try {
            DERInputStream in = new DERInputStream((InputStream)new ByteArrayInputStream(enc));
            DERConstructedSequence seq = (DERConstructedSequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }

    public byte[] getEncoded() {
        return this.getEncoded(null);
    }

    public byte[] getEncoded(byte[] _contentData) {
        try {
            if (this.digest == null) {
                this.digest = this.sig.sign();
            }
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject((DEREncodable)a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject((DEREncodable)new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            if (_contentData != null) {
                DEROctetString octets = new DEROctetString(_contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, (DEREncodable)octets);
                contentinfo.addObject((DEREncodable)tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream((InputStream)new ByteArrayInputStream(((X509Certificate)i2.next()).getEncoded()));
                dercertificates.addObject((DEREncodable)tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject((DEREncodable)new DERInteger(this.signerversion));
            byte[] bsIssuer = this.signCert.getIssuerX500Principal().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject((DEREncodable)isAnds);
            signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject((DEREncodable)new DEROctetString(this.digest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject((DEREncodable)new DERInteger(this.version));
            body.addObject((DEREncodable)algos);
            body.addObject((DEREncodable)contentinfo);
            body.addObject((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)dercertificates));
            if (this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream((InputStream)new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject((DEREncodable)t.readObject());
                }
                body.addObject((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject((DEREncodable)signerinfo);
            body.addObject((DEREncodable)signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject((DEREncodable)new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.addObject((DEREncodable)new DERTaggedObject(0, (DEREncodable)body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream((OutputStream)bOut);
            dout.writeObject((Object)whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        String p7 = "MIICaAYKKoEcz1UGAQQCAqCCAlgwggJUAgEBMQ4wDAYIKoEcz1UBgxEFADAMBgoqgRzPVQYBBAIBoIIBkDCCAYwwggEwoAMCAQICBRAAABFWMAwGCCqBHM9VAYN1BQAwJzELMAkGA1UEBhMCQ04xGDAWBgNVBAoMD0NGQ0Egc20yIFJDQTExMTAeFw0xMzAyMjYwMjU5MjFaFw0xNDAyMjEwMjU5MjFaMB8xCzAJBgNVBAYTAkNOMRAwDgYDVQQDDAdzbTJ0ZXN0MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE7VVu9jkN1i0oUDtp0ocl8pXKF0eHXtKewa8wzmR9Ym98j67PDOhxq8YUr9VuRw+CDaJmmXZuHuf+VYjSx3qIwqNPME0wHwYDVR0jBBgwFoAUAJAK6++jihENFsJYJe0OJ5DtGCcwCwYDVR0PBAQDAgbAMB0GA1UdDgQWBBRbEMk1WzZ9V7LCM/Ae/LJEvkDMizAMBggqgRzPVQGDdQUAA0gAMEUCIHqrOB1qmaYKJPUz6j5dyxcHlyjlyqM49ixHiJQ/m/TXAiEA1+o0P25BzTa7rygPOVFXU7CKspXQHW8tyQyc/+2rsoAxgZwwgZkCAQEwMDAnMQswCQYDVQQGEwJDTjEYMBYGA1UECgwPQ0ZDQSBzbTIgUkNBMTExAgUQAAARVjAMBggqgRzPVQGDEQUAMAwGCCqBHM9VAYN1BQAwRgIhAJdtI9zvURu8XmIU9mmD6vguOg6H27d+iqwy1xafJ1GuAiEA3aeMC6gdLX1jsZrCtb81cjWSVNf+oYqlCQIh7hVx+Dg=";
        byte[] bs = Base64.decode((String)p7);
        FastPkcs7 fxPKCS7 = new FastPkcs7();
        fxPKCS7.pkcs7SignedData(bs);
        Item digestItem = fxPKCS7.getDigest();
        byte[] digest = DerUtil.getItemData((byte[])bs, (Item)digestItem);
        ConsoleLogger.logBinary((String)"digest", (byte[])digest);
    }

    public String getDigAlg() {
        return this.digAlg;
    }

    public String getDigestEncryptionAlg() {
        return this.signAlg;
    }
}

