/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors.util;

import cn.com.infosec.netsign.base.PDFBookmarkPos;
import cn.com.infosec.netsign.base.PDFImage;
import cn.com.infosec.netsign.base.PDFPosition;
import cn.com.infosec.netsign.base.PDFPositionParser;
import cn.com.infosec.netsign.base.PDFTextPos;
import cn.com.infosec.netsign.base.processors.util.BinaryUtil;
import cn.com.infosec.netsign.exceptions.AddImage2PDFException;
import cn.com.infosec.netsign.exceptions.PDFPageNumberOutofRangeException;
import cn.com.infosec.netsign.exceptions.ReadImageException;
import cn.com.infosec.netsign.exceptions.ReadPDFException;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfDestination;
import com.itextpdf.text.pdf.PdfOutline;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.SimpleBookmark;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PDFUtil {
    public static PdfStamper generatePdfStamper(byte[] pdf, byte[] passwd, ByteArrayOutputStream out) throws Exception {
        PdfReader reader;
        PdfReader pdfReader = reader = passwd == null ? new PdfReader(pdf) : new PdfReader(pdf, passwd);
        if (reader.computeUserPassword() == null) {
            passwd = null;
            reader = new PdfReader(pdf);
        }
        PdfStamper stamp = new PdfStamper(reader, (OutputStream)out);
        if (passwd != null) {
            stamp.setEncryption(passwd, passwd, reader.getPermissions(), true);
        }
        return stamp;
    }

    public static byte[] closePdf(PdfStamper stamp, ByteArrayOutputStream out) throws Exception {
        stamp.close();
        return out.toByteArray();
    }

    public static void addImg2PDF(PdfStamper stamp, PDFImage pdfImg, PDFPosition pdfPos) throws ReadPDFException, ReadImageException, AddImage2PDFException, PDFPageNumberOutofRangeException {
        PdfReader reader = stamp.getReader();
        ArrayList posList = PDFPositionParser.parse(pdfPos, reader);
        try {
            if (pdfPos.getType() == 1) {
                PDFUtil.addImg2PDFIndictPos(stamp, pdfImg.getImage(), pdfPos.getX2() - pdfPos.getX1(), pdfPos.getY2() - pdfPos.getY1(), pdfPos.getPage(), pdfPos.getX1(), pdfPos.getY1());
            } else if (pdfPos.getType() == 2) {
                PDFBookmarkPos bookmark_Pos = (PDFBookmarkPos)posList.get(0);
                PDFUtil.addImg2PDFIndictPos(stamp, pdfImg.getImage(), bookmark_Pos.getX2() - bookmark_Pos.getX1(), bookmark_Pos.getY2() - bookmark_Pos.getY1(), bookmark_Pos.getPage(), bookmark_Pos.getX1(), bookmark_Pos.getY1());
            } else if (pdfPos.getType() == 3) {
                PDFTextPos text_Pos = (PDFTextPos)posList.get(0);
                PDFUtil.addImg2PDFIndictPos(stamp, pdfImg.getImage(), pdfPos.getWidth(), pdfPos.getHeight(), text_Pos.getPage(), text_Pos.getX1(), text_Pos.getY1());
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
    }

    public static void addImg2PDFIndictPos(PdfStamper stamp, byte[] image, int w, int h, int pageNumber, int x, int y) throws ReadPDFException, ReadImageException, AddImage2PDFException, PDFPageNumberOutofRangeException {
        PdfContentByte over = stamp.getOverContent(pageNumber = pageNumber < 1 ? 1 : pageNumber);
        if (over == null) {
            throw new PDFPageNumberOutofRangeException("Page number " + pageNumber + " out of range");
        }
        Image img = null;
        try {
            img = Image.getInstance((byte[])image);
            if (w > 0) {
                img.scaleAbsoluteWidth((float)w);
            }
            if (h > 0) {
                img.scaleAbsoluteHeight((float)h);
            }
            x = x > 0 ? x : 0;
            y = y > 0 ? y : 0;
            img.setAbsolutePosition((float)x, (float)y);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ReadImageException(e.toString());
        }
        try {
            over.addImage(img);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new AddImage2PDFException(e.toString());
        }
    }

    public static boolean isValid(byte[] pdf) {
        if (pdf == null) {
            return false;
        }
        String pdfstr = new String(pdf);
        int typeIndex = 0;
        boolean result = true;
        int sindex = 0;
        while ((typeIndex = pdfstr.indexOf("/Sig", sindex)) != -1) {
            int cstart;
            String tmp;
            int contentIndex;
            int end = pdfstr.indexOf(">>", typeIndex) + 2;
            String strtmp = pdfstr.substring(0, end);
            int start = strtmp.lastIndexOf("<<");
            sindex = end;
            if (typeIndex < start || (contentIndex = (tmp = pdfstr.substring(start, end)).indexOf("/Contents")) == -1 || (cstart = tmp.indexOf("<", contentIndex)) != -1) continue;
            result = false;
            break;
        }
        return result;
    }

    public static byte[] getRecipients(byte[] pdf) {
        if (pdf == null) {
            return null;
        }
        BinaryUtil butil = new BinaryUtil();
        butil.setXML(pdf);
        byte[] result = null;
        if (butil.moveto("/DefaultCryptFilter".getBytes())) {
            int subs = 0;
            int sube = 0;
            if (butil.moveto("/Recipients[(".getBytes())) {
                subs = butil.getLocation();
                if (butil.moveto(")]>>>>".getBytes())) {
                    sube = butil.getLocation();
                    int tmp = "/Recipients[(".getBytes().length;
                    result = new byte[sube - subs - tmp];
                    System.arraycopy(pdf, subs + tmp, result, 0, sube - subs - tmp);
                }
            }
        }
        return result;
    }

    public static byte[] addBookmark2Pdf(PdfReader reader, ArrayList bookmarkList) throws DocumentException, IOException {
        byte[] fileBytes = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            List list = SimpleBookmark.getBookmark((PdfReader)reader);
            if (list != null) {
                int size = list.size();
                PdfStamper stamper = new PdfStamper(reader, (OutputStream)os);
                int i = 0;
                while (i < bookmarkList.size()) {
                    HashMap map = (HashMap)bookmarkList.get(i);
                    list.add(i + size, map);
                    ++i;
                }
                stamper.setOutlines(list);
                stamper.close();
            } else {
                int n = reader.getNumberOfPages();
                Document document = new Document();
                PdfCopy copy = new PdfCopy(document, (OutputStream)os);
                document.open();
                int i = 0;
                while (i < n) {
                    copy.addPage(copy.getImportedPage(reader, ++i));
                }
                PdfContentByte cb = copy.getDirectContent();
                PdfOutline root = cb.getRootOutline();
                int i2 = 0;
                while (i2 < bookmarkList.size()) {
                    PdfOutline oline;
                    PdfDestination dest;
                    HashMap map = (HashMap)bookmarkList.get(i2);
                    String temp = (String)map.get("Page");
                    String[] tempStr = temp.split(" ");
                    if (tempStr[1].equals("FitR")) {
                        dest = new PdfDestination(4, (float)Integer.parseInt(tempStr[2]), (float)Integer.parseInt(tempStr[3]), (float)Integer.parseInt(tempStr[4]), (float)Integer.parseInt(tempStr[5]));
                        oline = new PdfOutline(root, PdfAction.gotoLocalPage((int)Integer.parseInt(tempStr[0]), (PdfDestination)dest, (PdfWriter)copy), (String)map.get("Title"));
                    } else if (tempStr[1].equals("XYZ")) {
                        dest = new PdfDestination(0, (float)Integer.parseInt(tempStr[2]), (float)Integer.parseInt(tempStr[3]), (float)Integer.parseInt(tempStr[4]));
                        oline = new PdfOutline(root, PdfAction.gotoLocalPage((int)Integer.parseInt(tempStr[0]), (PdfDestination)dest, (PdfWriter)copy), (String)map.get("Title"));
                    } else if (tempStr[1].equals("Fit")) {
                        dest = new PdfDestination(1);
                        oline = new PdfOutline(root, PdfAction.gotoLocalPage((int)Integer.parseInt(tempStr[0]), (PdfDestination)dest, (PdfWriter)copy), (String)map.get("Title"));
                    } else if (tempStr[1].equals("FitV")) {
                        dest = new PdfDestination(3, (float)Integer.parseInt(tempStr[2]));
                        oline = new PdfOutline(root, PdfAction.gotoLocalPage((int)Integer.parseInt(tempStr[0]), (PdfDestination)dest, (PdfWriter)copy), (String)map.get("Title"));
                        oline.setOpen(false);
                        ++i2;
                        while (i2 < bookmarkList.size()) {
                            PdfOutline olineChild = null;
                            boolean isFitV = false;
                            int j = i2;
                            while (j < bookmarkList.size()) {
                                PdfDestination destChild;
                                ++i2;
                                HashMap mapChild = (HashMap)bookmarkList.get(j);
                                String tempChild = (String)mapChild.get("Page");
                                String[] tempChildStr = tempChild.split(" ");
                                if (tempChildStr[1].equals("FitR")) {
                                    destChild = new PdfDestination(4, (float)Integer.parseInt(tempChildStr[2]), (float)Integer.parseInt(tempChildStr[3]), (float)Integer.parseInt(tempChildStr[4]), (float)Integer.parseInt(tempChildStr[5]));
                                    olineChild = new PdfOutline(oline, PdfAction.gotoLocalPage((int)Integer.parseInt(tempStr[0]), (PdfDestination)destChild, (PdfWriter)copy), (String)mapChild.get("Title"));
                                } else if (tempChildStr[1].equals("XYZ")) {
                                    destChild = new PdfDestination(0, (float)Integer.parseInt(tempChildStr[2]), (float)Integer.parseInt(tempChildStr[3]), (float)Integer.parseInt(tempChildStr[4]));
                                    olineChild = new PdfOutline(oline, PdfAction.gotoLocalPage((int)Integer.parseInt(tempChildStr[0]), (PdfDestination)destChild, (PdfWriter)copy), (String)mapChild.get("Title"));
                                } else if (tempChildStr[1].equals("Fit")) {
                                    destChild = new PdfDestination(1);
                                    olineChild = new PdfOutline(oline, PdfAction.gotoLocalPage((int)Integer.parseInt(tempChildStr[0]), (PdfDestination)destChild, (PdfWriter)copy), (String)mapChild.get("Title"));
                                } else if (tempChildStr[1].equals("FitV")) {
                                    destChild = new PdfDestination(3, (float)Integer.parseInt(tempStr[2]));
                                    olineChild = new PdfOutline(root, PdfAction.gotoLocalPage((int)Integer.parseInt(tempStr[0]), (PdfDestination)destChild, (PdfWriter)copy), (String)mapChild.get("Title"));
                                    olineChild.setOpen(false);
                                    isFitV = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!isFitV) break;
                            isFitV = false;
                            oline = olineChild;
                        }
                    }
                    ++i2;
                }
                document.close();
            }
            fileBytes = os.toByteArray();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileBytes;
    }

    public static void addBookmarkFitR2List(ArrayList bookmarkList, String bookmark, int page, int left, int bottom, int right, int top) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Title", bookmark);
        map.put("Action", "GoTo");
        String pageStr = String.valueOf(page) + " " + "FitR" + " " + left + " " + bottom + " " + right + " " + top;
        map.put("Page", pageStr);
        bookmarkList.add(map);
    }

    public static void addBookmarkXYZ2List(ArrayList bookmarkList, String bookmark, int page, int left, int top) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Title", bookmark);
        map.put("Action", "GoTo");
        String pageStr = String.valueOf(page) + " " + "XYZ" + " " + left + " " + top + " " + 1;
        map.put("Page", pageStr);
        bookmarkList.add(map);
    }

    public static void addBookmarkFit2List(ArrayList bookmarkList, String bookmark, int page) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Title", bookmark);
        map.put("Action", "GoTo");
        String pageStr = String.valueOf(page) + " " + "Fit";
        map.put("Page", pageStr);
        bookmarkList.add(map);
    }

    public static void addBookmarkFitV2List(ArrayList bookmarkList, String bookmark, int page, int left) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Title", bookmark);
        map.put("Action", "GoTo");
        String pageStr = String.valueOf(page) + " " + "FitV" + " " + left;
        map.put("Page", pageStr);
        bookmarkList.add(map);
    }

    public static void main(String[] args) throws Exception {
        FileInputStream in = null;
        FileOutputStream fos = null;
        try {
            try {
                in = new FileInputStream("D:\\pdfsig-collision\\1.enced.pdf");
                byte[] bs = new byte[in.available()];
                in.read(bs);
                byte[] result = PDFUtil.getRecipients(bs);
                fos = new FileOutputStream("d:\\crypt.txt");
                fos.write(result);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (in != null) {
                    in.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }
}

